/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.SupplierBlockStateProviderAE;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.hollingsworth.arsnouveau.setup.registry.WorldgenRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModWorldgen {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"ars_elemental");
    public static final String SIMPLE_FLASHING_ID = "simple_flashing";
    public static final String COMMON_FLASHING_ID = "common_flashing";
    public static final String RARE_RANDOM_FLASHING_ID = "random_simple_flashing";
    public static final String COMMON_RANDOM_FLASHING_ID = "random_common_flashing";
    public static final String FINAL_RARE_FLASHING = "flashing_archwood";
    public static final String FINAL_COMMON_FLASHING = "common_flashing_archwood";
    public static final String FINAL_CLUSTER_FLASHING = "cluster_flashing_archwood";
    public static final String FINAL_CLUSTER_CASCADING = "cluster_cascading_archwood";
    public static final String FINAL_CLUSTER_BLAZING = "cluster_blazing_archwood";
    public static final String FINAL_CLUSTER_FLOURISHING = "cluster_flourishing_archwood";
    public static final String FINAL_CLUSTER_VEXING = "cluster_vexing_archwood";
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLASHING_TREE_SAPLING = ModWorldgen.registerConfKey("flashing_tree_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_FLASHING_TREE = ModWorldgen.registerConfKey("natural_flashing_tree");
    public static final ResourceKey<PlacedFeature> SIMPLE_FLASHING_PLACED = ModWorldgen.registerPlacedKey("simple_flashing");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_PLACED = ModWorldgen.registerPlacedKey("common_flashing");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RARE_FLASHING_TREES = ModWorldgen.registerConfKey("random_simple_flashing");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COMMON_FLASHING_TREES = ModWorldgen.registerConfKey("random_common_flashing");
    public static final ResourceKey<PlacedFeature> RARE_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("flashing_archwood");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("common_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_BLAZING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_blazing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_CASCADING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_cascading_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLOURISHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flourishing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_VEXING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_vexing_archwood");

    public static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placed = context.lookup(Registries.PLACED_FEATURE);
        WorldgenRegistry.bootstrapConfiguredFeatures(context);
        context.register(FLASHING_TREE_SAPLING, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 1, 0, false, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).ignoreVines().build()));
        context.register(NATURAL_FLASHING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 2, 0, true, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).build()));
        context.register(RARE_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(SIMPLE_FLASHING_PLACED)}))));
        context.register(COMMON_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(COMMON_FLASHING_PLACED)}))));
    }

    public static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        WorldgenRegistry.bootstrapPlacedFeatures(context);
        context.register(SIMPLE_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.get(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.register(COMMON_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.get(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.countExtra((int)5, (float)0.01f, (int)1), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.register(RARE_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(RARE_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)200))));
        context.register(COMMON_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(COMMON_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)2), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.register(CLUSTER_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(COMMON_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)6), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.register(CLUSTER_CASCADING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_CASCADING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)6), (Block)((Block)BlockRegistry.CASCADING_SAPLING.get()))));
        context.register(CLUSTER_BLAZING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_BLAZING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)6), (Block)((Block)BlockRegistry.BLAZING_SAPLING.get()))));
        context.register(CLUSTER_FLOURISHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_FLOURISHING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)6), (Block)((Block)BlockRegistry.FLOURISHING_SAPLING.get()))));
        context.register(CLUSTER_VEXING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_VEXING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)6), (Block)((Block)BlockRegistry.VEXING_SAPLING.get()))));
    }

    public static ResourceKey<Feature<?>> registerFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)name));
    }

    public static class Biomes {
        public static final String FLASHING_FOREST_ID = "flashing_forest";
        public static final String BLAZING_FOREST_ID = "blazing_forest";
        public static final String CASCADING_FOREST_ID = "cascading_forest";
        public static final String FLOURISHING_FOREST_ID = "flourishing_forest";
        public static final ResourceKey<Biome> FLASHING_FOREST_KEY = Biomes.register("flashing_forest");
        public static final ResourceKey<Biome> BLAZING_FOREST_KEY = Biomes.register("blazing_forest");
        public static final ResourceKey<Biome> CASCADING_FOREST_KEY = Biomes.register("cascading_forest");
        public static final ResourceKey<Biome> FLOURISHING_FOREST_KEY = Biomes.register("flourishing_forest");
        public static final ResourceLocation[] ArchwoodBiomes = new ResourceLocation[]{FLASHING_FOREST_KEY.location(), BLAZING_FOREST_KEY.location(), CASCADING_FOREST_KEY.location(), FLOURISHING_FOREST_KEY.location()};

        public static ResourceKey<Biome> register(String name) {
            return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsElemental.prefix(name));
        }

        public static void registerBiomes(BootstrapContext<Biome> context) {
            BiomeRegistry.bootstrap(context);
            context.register(FLASHING_FOREST_KEY, (Object)Biomes.flashingArchwoodForest(context));
            context.register(BLAZING_FOREST_KEY, (Object)Biomes.blazingArchwoodForest(context));
            context.register(CASCADING_FOREST_KEY, (Object)Biomes.cascadingArchwoodForest(context));
            context.register(FLOURISHING_FOREST_KEY, (Object)Biomes.flourishArchwoodForest(context));
        }

        public static Biome flashingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FLASHING_WEALD_WALKER.get(), 3, 1, 3));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_FLASHING_CONFIGURED, context);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.9f).temperature(0.4f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(13414701).foliageColorOverride(13084948).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome blazingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_BLAZING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_BLAZING_CONFIGURED, context);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.4f).temperature(0.9f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(16077890).foliageColorOverride(2210437).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome cascadingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_CASCADING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_CASCADING_CONFIGURED, context);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.9f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(1142955).foliageColorOverride(2210437).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome flourishArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_FLOURISHING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_FLOURISHING_CONFIGURED, context);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.8f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(1346066).foliageColorOverride(2210437).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static MobSpawnSettings.Builder archwoodSpawns() {
            MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
            BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnBuilder);
            BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
            return spawnBuilder;
        }

        private static BiomeGenerationSettings.Builder getArchwoodBiomeBuilder(ResourceKey<PlacedFeature> archwoodCluster, BootstrapContext<Biome> context) {
            BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
            BiomeRegistry.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeRegistry.softDisks((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_PLAINS);
            BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WorldgenRegistry.PLACED_LIGHTS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, archwoodCluster);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_GRASS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_FLOWERS);
            return biomeBuilder;
        }
    }
}

