/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.util;

import com.hollingsworth.arsnouveau.client.particle.ColorParticleTypeData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleUtil {
    public static ParticleColor fireColor = new ParticleColor(250, 15, 15);
    public static ParticleColor waterColor = new ParticleColor(50, 50, 250);
    public static ParticleColor earthColor = new ParticleColor(50, 250, 55);
    public static ParticleColor airColor = new ParticleColor(255, 255, 26);
    public static ParticleColor soulColor = new ParticleColor(200, 200, 200);

    public static ParticleColor schoolToColor(String school) {
        return switch (school) {
            case "fire" -> fireColor;
            case "water" -> waterColor;
            case "earth" -> earthColor;
            case "air" -> airColor;
            case "necromancy" -> soulColor;
            default -> ParticleColor.defaultParticleColor();
        };
    }

    public static ParticleColor schoolToColor2(String school) {
        return switch (school) {
            case "fire", "water" -> airColor;
            case "earth" -> waterColor;
            case "air", "necromancy" -> fireColor;
            default -> ParticleColor.defaultParticleColor();
        };
    }

    public void makeCouple(ParticleColor color1, ParticleColor color2, float size1, float size2, int age, BlockPos pos, Vec3 speed, Level world) {
        ParticleBuilder p1 = new ParticleBuilder(color1).scale(size1).setLifetime(age).setVelocity(speed);
        ParticleBuilder p2 = new ParticleBuilder(color2).scale(size2).setLifetime(age).setVelocity(speed);
        p1.spawn(world, pos);
        p2.spawn(world, pos);
    }

    public static class ParticleBuilder {
        Random random = new Random();
        ParticleColor color;
        float scale = 1.0f;
        float alpha = 1.0f;
        int lifetime = 20;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double maxXSpeed = 0.0;
        double maxYSpeed = 0.0;
        double maxZSpeed = 0.0;
        double maxXDist = 0.0;
        double maxYDist = 0.0;
        double maxZDist = 0.0;

        public ParticleBuilder(ParticleColor color) {
            this.color = color;
        }

        public ParticleBuilder(float r, float g, float b) {
            this(new ParticleColor(r, b, g));
        }

        public ParticleBuilder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public ParticleBuilder alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public ParticleBuilder setLifetime(int lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public ParticleBuilder randomVelocity(double maxSpeed) {
            return this.randomVelocity(maxSpeed, maxSpeed, maxSpeed);
        }

        public ParticleBuilder randomVelocity(double maxHSpeed, double maxVSpeed) {
            return this.randomVelocity(maxHSpeed, maxVSpeed, maxHSpeed);
        }

        public ParticleBuilder randomVelocity(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
            this.maxXSpeed = maxXSpeed;
            this.maxYSpeed = maxYSpeed;
            this.maxZSpeed = maxZSpeed;
            return this;
        }

        public ParticleBuilder addVelocity(double vx, double vy, double vz) {
            this.vx += vx;
            this.vy += vy;
            this.vz += vz;
            return this;
        }

        public ParticleBuilder setVelocity(Vec3 speed) {
            return this.setVelocity(speed.x(), speed.y(), speed.z());
        }

        public ParticleBuilder setVelocity(double vx, double vy, double vz) {
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            return this;
        }

        public ParticleBuilder randomOffset(double maxDistance) {
            return this.randomOffset(maxDistance, maxDistance, maxDistance);
        }

        public ParticleBuilder randomOffset(double maxHDist, double maxVDist) {
            return this.randomOffset(maxHDist, maxVDist, maxHDist);
        }

        public ParticleBuilder randomOffset(double maxXDist, double maxYDist, double maxZDist) {
            this.maxXDist = maxXDist;
            this.maxYDist = maxYDist;
            this.maxZDist = maxZDist;
            return this;
        }

        public void spawn(Level world, BlockPos pos) {
            this.spawn(world, pos.getX(), pos.getY(), pos.getZ());
        }

        public void spawn(Level world, double x, double y, double z) {
            double yaw = (double)this.random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)this.random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)this.random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)this.random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)this.random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            double yaw2 = (double)this.random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)this.random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)this.random.nextFloat() * this.maxXDist;
            double yDist = (double)this.random.nextFloat() * this.maxYDist;
            double zDist = (double)this.random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            world.addParticle((ParticleOptions)this.build(), x + this.dx, y + this.dy, z + this.dz, this.vx, this.vy, this.vz);
        }

        ColorParticleTypeData build() {
            return new ColorParticleTypeData(this.color, false, this.scale, this.alpha, this.lifetime);
        }
    }
}

