/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.world.ModWorldgen;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AEWorldgenProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModWorldgen::bootstrapConfiguredFeatures).add(Registries.PLACED_FEATURE, ModWorldgen::bootstrapPlacedFeatures).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, AEWorldgenProvider::generateBiomeModifiers).add(Registries.BIOME, ModWorldgen.Biomes::registerBiomes);
    public static final ResourceKey<BiomeModifier> SIREN_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ArsElemental.prefix("siren_spawns"));
    public static final ResourceKey<BiomeModifier> COMMON_FLASHING_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ModWorldgen.COMMON_FLASHING_CONFIGURED.location());

    public AEWorldgenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("ars_elemental"));
    }

    public static void generateBiomeModifiers(BootstrapContext<BiomeModifier> context) {
        HolderSet.Named OVERWORLD_TAG = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderSet.Named COMMON_FLASH_ARCHWOOD_TAG = context.lookup(Registries.BIOME).getOrThrow(AETagsProvider.AEBiomeTagsProvider.FLASHING_TREE_COMMON_BIOME);
        HolderSet.Named SIREN_SPAWN_TAG = context.lookup(Registries.BIOME).getOrThrow(AETagsProvider.AEBiomeTagsProvider.SIREN_SPAWN_TAG);
        context.register(SIREN_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)SIREN_SPAWN_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SIREN_ENTITY.get(), 3, 1, 3)));
        Holder.Reference TREESET_CMN = (Holder.Reference)context.lookup(Registries.PLACED_FEATURE).get(ModWorldgen.COMMON_FLASHING_CONFIGURED).get();
        context.register(COMMON_FLASHING_MODIFIER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)COMMON_FLASH_ARCHWOOD_TAG, (HolderSet)HolderSet.direct((Holder[])new Holder[]{TREESET_CMN}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

