/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.glyphs.EffectCharm;
import alexthw.ars_elemental.common.glyphs.EffectConjureTerrain;
import alexthw.ars_elemental.common.glyphs.EffectDischarge;
import alexthw.ars_elemental.common.glyphs.EffectEnvenom;
import alexthw.ars_elemental.common.glyphs.EffectLifeLink;
import alexthw.ars_elemental.common.glyphs.EffectNullify;
import alexthw.ars_elemental.common.glyphs.EffectPhantom;
import alexthw.ars_elemental.common.glyphs.EffectSpark;
import alexthw.ars_elemental.common.glyphs.EffectSpike;
import alexthw.ars_elemental.common.glyphs.EffectSpores;
import alexthw.ars_elemental.common.glyphs.EffectWaterGrave;
import alexthw.ars_elemental.common.glyphs.MethodArcProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.glyphs.PropagatorArc;
import alexthw.ars_elemental.common.glyphs.PropagatorHoming;
import alexthw.ars_elemental.common.glyphs.filters.AerialFilter;
import alexthw.ars_elemental.common.glyphs.filters.AquaticFilter;
import alexthw.ars_elemental.common.glyphs.filters.FieryFilter;
import alexthw.ars_elemental.common.glyphs.filters.InsectFilter;
import alexthw.ars_elemental.common.glyphs.filters.SummonFilter;
import alexthw.ars_elemental.common.glyphs.filters.UndeadFilter;
import alexthw.ars_elemental.registry.ModItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class AEGlyphProvider
extends GlyphRecipeProvider {
    public AEGlyphProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.addRecipe((AbstractSpellPart)EffectConjureTerrain.INSTANCE, new ItemLike[]{ItemsRegistry.EARTH_ESSENCE, Items.DIRT});
        this.addRecipe((AbstractSpellPart)EffectWaterGrave.INSTANCE, new ItemLike[]{Items.KELP, Items.PRISMARINE_SHARD, ItemsRegistry.WATER_ESSENCE});
        this.addRecipe((AbstractSpellPart)EffectBubbleShield.INSTANCE, new ItemLike[]{Items.HEART_OF_THE_SEA, Items.PRISMARINE_SHARD, BlockRegistry.BASTION_POD.asItem(), ItemsRegistry.WATER_ESSENCE});
        this.addRecipe((AbstractSpellPart)EffectSpores.INSTANCE, new ItemLike[]{Items.SPORE_BLOSSOM, Items.RED_MUSHROOM, ItemsRegistry.EARTH_ESSENCE});
        this.addRecipe((AbstractSpellPart)EffectDischarge.INSTANCE, new ItemLike[]{Items.LIGHTNING_ROD, ((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem(), ItemsRegistry.AIR_ESSENCE});
        this.recipes.add(this.get((AbstractSpellPart)EffectSpark.INSTANCE).withItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withIngredient(Ingredient.of((TagKey)ItemTags.WOOL)).withItem((ItemLike)Items.IRON_BARS));
        this.addRecipe((AbstractSpellPart)EffectCharm.INSTANCE, new ItemLike[]{(ItemLike)ModItems.ANIMA_ESSENCE.get(), Items.GOLDEN_CARROT, ItemsRegistry.SOURCE_BERRY_PIE, Blocks.CAKE});
        this.addRecipe((AbstractSpellPart)EffectLifeLink.INSTANCE, new ItemLike[]{Items.LEAD, (ItemLike)ModItems.ANIMA_ESSENCE.get(), Items.SCULK_SENSOR});
        this.addRecipe((AbstractSpellPart)EffectPhantom.INSTANCE, new ItemLike[]{Items.PHANTOM_MEMBRANE, Items.PHANTOM_MEMBRANE, (ItemLike)ModItems.ANIMA_ESSENCE.get()});
        this.addRecipe((AbstractSpellPart)EffectSpike.INSTANCE, new ItemLike[]{Items.POINTED_DRIPSTONE, Items.NETHERITE_INGOT, ItemsRegistry.EARTH_ESSENCE});
        this.addRecipe((AbstractSpellPart)EffectEnvenom.INSTANCE, new ItemLike[]{Items.POISONOUS_POTATO, Items.FERMENTED_SPIDER_EYE, Items.SUSPICIOUS_STEW});
        this.addRecipe((AbstractSpellPart)MethodArcProjectile.INSTANCE, new ItemLike[]{Items.ARROW, Items.SNOWBALL, Items.SLIME_BALL, Items.ENDER_PEARL});
        this.addRecipe((AbstractSpellPart)MethodHomingProjectile.INSTANCE, new ItemLike[]{Items.NETHER_STAR, ItemsRegistry.MANIPULATION_ESSENCE, ItemsRegistry.DOWSING_ROD, Items.ENDER_EYE});
        this.addRecipe((AbstractSpellPart)PropagatorArc.INSTANCE, new ItemLike[]{ItemsRegistry.MANIPULATION_ESSENCE, MethodArcProjectile.INSTANCE.getGlyph()});
        this.addRecipe((AbstractSpellPart)PropagatorHoming.INSTANCE, new ItemLike[]{ItemsRegistry.MANIPULATION_ESSENCE, MethodHomingProjectile.INSTANCE.getGlyph()});
        this.recipes.add(this.get((AbstractSpellPart)AquaticFilter.INSTANCE).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withIngredient(Ingredient.of((TagKey)ItemTags.FISHES)));
        this.recipes.add(this.get((AbstractSpellPart)AquaticFilter.NOT_INSTANCE).withItem((ItemLike)ItemsRegistry.DENY_ITEM_SCROLL).withIngredient(Ingredient.of((TagKey)ItemTags.FISHES)));
        this.addRecipe((AbstractSpellPart)AerialFilter.INSTANCE, new ItemLike[]{ItemsRegistry.ALLOW_ITEM_SCROLL, Items.PHANTOM_MEMBRANE});
        this.addRecipe((AbstractSpellPart)AerialFilter.NOT_INSTANCE, new ItemLike[]{ItemsRegistry.DENY_ITEM_SCROLL, Items.PHANTOM_MEMBRANE});
        this.addRecipe((AbstractSpellPart)FieryFilter.INSTANCE, new ItemLike[]{ItemsRegistry.ALLOW_ITEM_SCROLL, Items.BLAZE_POWDER});
        this.addRecipe((AbstractSpellPart)FieryFilter.NOT_INSTANCE, new ItemLike[]{ItemsRegistry.DENY_ITEM_SCROLL, Items.BLAZE_POWDER});
        this.addRecipe((AbstractSpellPart)UndeadFilter.INSTANCE, new ItemLike[]{ItemsRegistry.ALLOW_ITEM_SCROLL, Items.ROTTEN_FLESH});
        this.addRecipe((AbstractSpellPart)UndeadFilter.NOT_INSTANCE, new ItemLike[]{ItemsRegistry.DENY_ITEM_SCROLL, Items.ROTTEN_FLESH});
        this.addRecipe((AbstractSpellPart)SummonFilter.INSTANCE, new ItemLike[]{ItemsRegistry.ALLOW_ITEM_SCROLL, Items.BONE});
        this.addRecipe((AbstractSpellPart)SummonFilter.NOT_INSTANCE, new ItemLike[]{ItemsRegistry.DENY_ITEM_SCROLL, Items.BONE});
        this.addRecipe((AbstractSpellPart)InsectFilter.INSTANCE, new ItemLike[]{ItemsRegistry.ALLOW_ITEM_SCROLL, Items.SPIDER_EYE});
        this.addRecipe((AbstractSpellPart)InsectFilter.NOT_INSTANCE, new ItemLike[]{ItemsRegistry.DENY_ITEM_SCROLL, Items.SPIDER_EYE});
        for (GlyphRecipe recipe : this.recipes) {
            Path path = AEGlyphProvider.getScribeGlyphPath(this.output, recipe.output.getItem());
            this.saveStable(cache, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
        }
        JsonElement conditionalRecipe = (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.addRecipe((AbstractSpellPart)EffectNullify.INSTANCE, new ItemLike[]{Items.NETHER_STAR, ModItems.MARK_OF_MASTERY, Items.NETHERITE_BLOCK, ModItems.MARK_OF_MASTERY})).getOrThrow();
        JsonObject condition = new JsonObject();
        condition.addProperty("config", "frame_skip_recipe");
        condition.addProperty("type", "ars_elemental:config");
        JsonArray array = new JsonArray();
        array.add((JsonElement)condition);
        conditionalRecipe.getAsJsonObject().add("neoforge:conditions", (JsonElement)array);
        this.saveStable(cache, conditionalRecipe, AEGlyphProvider.getScribeGlyphPath(this.output, (Item)EffectNullify.INSTANCE.getGlyph()));
    }

    public GlyphRecipe addRecipe(AbstractSpellPart part, ItemLike ... items) {
        GlyphRecipe builder = this.get(part);
        for (ItemLike item : items) {
            builder.withItem(item);
        }
        this.recipes.add(builder);
        return builder;
    }

    protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
        return pathIn.resolve("data/ars_elemental/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
    }

    @NotNull
    public String getName() {
        return "Ars Elemental Glyph Recipes";
    }
}

