/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.IPropagator;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectReset;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class PropagatorHoming
extends ElementalAbstractEffect
implements IPropagator {
    public static PropagatorHoming INSTANCE = new PropagatorHoming();

    public PropagatorHoming() {
        super("propagator_homing", "Propagate Homing");
        EffectReset.RESET_LIMITS.add(this);
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        Vec3 pos = hitResult.getLocation();
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        ArrayList<EntityHomingProjectileSpell> projectiles = new ArrayList<EntityHomingProjectileSpell>();
        for (int i = 0; i < numSplits; ++i) {
            projectiles.add(new EntityHomingProjectileSpell(world, resolver));
        }
        float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        Vec3 direction = IPropagator.getDirection(shooter, resolver, pos);
        for (EntityHomingProjectileSpell proj : projectiles) {
            proj.setPos(pos.add(0.0, 1.0, 0.0));
            proj.setIgnored(MethodHomingProjectile.basicIgnores(shooter, stats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE), resolver.spell));
            if (!(shooter instanceof FakePlayer)) {
                proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
            } else {
                proj.shoot(direction.x, direction.y, direction.z, velocity, 0.8f);
            }
            opposite *= -1;
            ++counter;
            world.addFreshEntity((Entity)proj);
        }
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 400;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodHomingProjectile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public Integer getTypeIndex() {
        return 8;
    }
}

