/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.mixin.ZombieInvoker;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectWaterGrave
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectWaterGrave INSTANCE = new EffectWaterGrave();

    private EffectWaterGrave() {
        super("watery_grave", "Watery Grave");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            int airSupply;
            LivingEntity living = (LivingEntity)entity;
            if (spellStats.hasBuff((AbstractAugment)AugmentExtendTime.INSTANCE)) {
                this.applyConfigPotion(living, (Holder)ModPotions.WATER_GRAVE, spellStats);
            } else {
                Vec3 delta = living.getDeltaMovement();
                double dy = Math.min(-1.0, delta.y - 0.05);
                living.setDeltaMovement(delta.x, dy, delta.z);
            }
            if (living instanceof Zombie) {
                Zombie zombie = (Zombie)living;
                if (!(living instanceof Drowned)) {
                    ((ZombieInvoker)zombie).callStartUnderWaterConversion(20);
                    return;
                }
            }
            if ((airSupply = living.getAirSupply()) <= 0 || living.getType().is(EntityTypeTags.AQUATIC)) {
                double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
                this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)living, this.buildDamageSource(world, shooter), (float)damage);
            } else {
                double newSupply = Math.max(-19.0, (double)airSupply - 50.0 * (3.0 + spellStats.getAmpMultiplier()));
                living.setAirSupply((int)newSupply);
            }
            living.hurtMarked = true;
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return shooter.damageSources().drown();
    }

    public int getDefaultManaCost() {
        return 25;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
        this.addDamageConfig(builder, 5.0);
        this.addAmpConfig(builder, 2.0);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentRandomize.INSTANCE});
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.ELEMENTAL_WATER);
    }

    public String getBookDescription() {
        return "Causes entities to drown. When augmented with Extend Time, they will be dragged down and unable to swim up.";
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

