/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectLifeLink
extends ElementalAbstractEffect
implements IPotionEffect {
    public static EffectLifeLink INSTANCE = new EffectLifeLink();

    public EffectLifeLink() {
        super("life_link", "Life Link");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (shooter instanceof Player && (player = (Player)shooter) != livingEntity) {
                if (resolver.hasFocus((Item)ModItems.NECRO_FOCUS.get())) {
                    this.forceApplyPotion(livingEntity, (LivingEntity)player, (Holder<MobEffect>)ModPotions.LIFE_LINK, spellStats);
                } else {
                    this.applyPotion(livingEntity, (LivingEntity)player, (Holder<MobEffect>)ModPotions.LIFE_LINK, spellStats);
                }
            }
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getSummonAugments();
    }

    public void applyPotion(LivingEntity entity, LivingEntity owner, Holder<MobEffect> potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        entity.addEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity));
        owner.addEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity));
    }

    public void forceApplyPotion(LivingEntity entity, LivingEntity owner, Holder<MobEffect> potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        entity.forceAddEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity), (Entity)entity);
        owner.forceAddEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity), (Entity)owner);
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

