/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import alexthw.ars_elemental.mixin.FoxInvoker;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectCharm
extends ElementalAbstractEffect
implements IPotionEffect {
    public static EffectCharm INSTANCE = new EffectCharm();

    public EffectCharm() {
        super("charm", "Charm");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                Entity entity = rayTraceResult.getEntity();
                if (entity instanceof Mob) {
                    Animal a;
                    Mob mob = (Mob)entity;
                    if (mob instanceof Enemy || mob instanceof NeutralMob && (!(mob instanceof Animal) || !(a = (Animal)mob).canFallInLove())) {
                        if (mob.getMaxHealth() < (float)((Integer)this.GENERIC_INT.get()).intValue() || player.getUUID().equals(ArsElemental.Dev)) {
                            float resistance = 10.0f + 100.0f * (mob.getHealth() / mob.getMaxHealth());
                            double chanceBoost = 10.0 + spellStats.getAmpMultiplier() * 5.0;
                            if (mob.getType().is(EntityTypeTags.UNDEAD) && NecroticFocus.hasFocus(world, (Entity)shooter)) {
                                chanceBoost += 50.0;
                            }
                            if (this.rollToSeduce((int)resistance, chanceBoost, level.getRandom())) {
                                this.applyPotion((LivingEntity)mob, (LivingEntity)player, (Holder<MobEffect>)ModPotions.ENTHRALLED, spellStats);
                                this.playHeartParticles((LivingEntity)mob, level);
                            }
                        }
                    } else {
                        Entity resistance = rayTraceResult.getEntity();
                        if (resistance instanceof Animal) {
                            Fox fox;
                            AbstractHorse horse;
                            TamableAnimal tamable;
                            Animal animal = (Animal)resistance;
                            if (animal instanceof TamableAnimal && !(tamable = (TamableAnimal)animal).isTame()) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.getRandom())) {
                                    tamable.tame(player);
                                }
                            } else if (animal instanceof AbstractHorse && !(horse = (AbstractHorse)animal).isTamed()) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.getRandom())) {
                                    horse.setTamed(true);
                                }
                            } else if (animal instanceof Fox && !((FoxInvoker)(fox = (Fox)animal)).callTrusts(player.getUUID())) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.getRandom())) {
                                    ((FoxInvoker)fox).callAddTrustedUUID(player.getUUID());
                                }
                            } else if (animal.canFallInLove() && this.rollToSeduce(90, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.getRandom())) {
                                animal.setInLove(player);
                            }
                        }
                    }
                }
            }
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    private boolean rollToSeduce(int resistance, double chanceBoost, RandomSource rand) {
        return (double)rand.nextInt(0, resistance) + chanceBoost >= (double)resistance;
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
        this.addGenericInt(builder, 150, "Set the max hp limit for Charm, mobs with more max hp will be immune.", "charm_hp_limit");
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getPotionAugments();
    }

    public void applyPotion(LivingEntity entity, LivingEntity owner, Holder<MobEffect> potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.addEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, amp, false, true, owner, null));
    }

    private void playHeartParticles(LivingEntity entity, ServerLevel world) {
        for (int i = 0; i < 5; ++i) {
            double d0 = entity.getRandom().nextGaussian() * 0.02;
            double d1 = entity.getRandom().nextGaussian() * 0.02;
            double d2 = entity.getRandom().nextGaussian() * 0.02;
            world.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getX() + ((double)world.random.nextFloat() - 0.5) / 2.0, entity.getY() + ((double)world.random.nextFloat() + 0.5), entity.getZ() + ((double)world.random.nextFloat() - 0.5) / 2.0, 2, d0, d1, d2, (double)0.1f);
        }
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

