/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.mages;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.api.item.ISchoolProvider;
import alexthw.ars_elemental.common.entity.ai.ProjCastingGoal;
import alexthw.ars_elemental.common.entity.ai.SelfCastGoal;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMageBase
extends Monster
implements RangedAttackMob,
ISchoolProvider {
    public final List<Spell> pSpells = new ArrayList<Spell>();
    public final List<Spell> sSpells = new ArrayList<Spell>();
    public SpellSchool school;
    public int castCooldown = 0;

    protected EntityMageBase(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.pSpells.add(new Spell(new AbstractSpellPart[]{MethodProjectile.INSTANCE, EffectHarm.INSTANCE, AugmentAmplify.INSTANCE}));
        this.sSpells.add(new Spell(new AbstractSpellPart[]{MethodSelf.INSTANCE, EffectHeal.INSTANCE, AugmentAmplify.INSTANCE}));
    }

    public void tick() {
        super.tick();
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityMageBase.class, true, e -> {
            if (!(e instanceof EntityMageBase)) return false;
            EntityMageBase mage = (EntityMageBase)e;
            if (this.school == mage.school) return false;
            return true;
        }));
        if (((Boolean)ConfigHandler.Common.MAGES_AGGRO.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, e -> {
                Player player;
                return e instanceof Player && ISchoolFocus.hasFocus((Entity)(player = (Player)e)) != this.school;
            }));
        }
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, e -> !(e instanceof EntityMageBase)));
        this.goalSelector.addGoal(3, new ProjCastingGoal<EntityMageBase>(this, 1.0, 30, 64.0f, () -> this.castCooldown <= 0, 0, 10));
        this.goalSelector.addGoal(6, new SelfCastGoal<EntityMageBase>(this, 20, 0, () -> this.castCooldown <= 0 && this.getHealth() < this.getMaxHealth() / 4.0f, 0, 10));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        super.registerGoals();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.populateDefaultEquipmentSlots(pLevel.getRandom(), pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource randomSource, @NotNull DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(randomSource, pDifficulty);
        if (this.school != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.setItemSlot(slot, EntityMageBase.getArmorForSlot(slot, this.school));
            }
        } else {
            this.setItemSlot(EquipmentSlot.HEAD, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_HOOD.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.CHEST, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_ROBES.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.LEGS, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_LEGGINGS.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.FEET, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_BOOTS.get()).getDefaultInstance());
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, ((SpellBook)ItemsRegistry.APPRENTICE_SPELLBOOK.get()).getDefaultInstance());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        Spell spell = this.pSpells.get(this.random.nextInt(this.pSpells.size()));
        ParticleColor color = ParticleUtil.schoolToColor(this.school.getId());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.level(), spell, (LivingEntity)this, (IWrappedCaster)new LivingCaster((LivingEntity)this)).withColors(color));
        resolver.onCast(ItemStack.EMPTY, this.level());
        this.castCooldown = 40;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("cast", this.castCooldown);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.castCooldown = tag.getInt("cast");
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public boolean isAlliedTo(@NotNull Entity pEntity) {
        return super.isAlliedTo(pEntity) || this.school.equals(ISchoolFocus.hasFocus(pEntity));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getBaseExperienceReward() {
        return 15;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel serverLevel, @NotNull DamageSource source, boolean wasRecentlyHit) {
    }

    public static ItemStack getArmorForSlot(EquipmentSlot slot, SpellSchool school) {
        Item item;
        switch (slot) {
            case HEAD: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getHat();
                break;
            }
            case CHEST: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getChest();
                break;
            }
            case LEGS: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getLegs();
                break;
            }
            case FEET: {
                Item item2 = EntityMageBase.getArmorSetFromElement(school).getBoots();
                break;
            }
            default: {
                Item item2 = item = null;
            }
        }
        if (item == null) {
            return ItemStack.EMPTY;
        }
        return item.getDefaultInstance();
    }

    private static ArmorSet getArmorSetFromElement(SpellSchool school) {
        return switch (school.getId()) {
            case "fire" -> ModItems.FIRE_ARMOR;
            case "water" -> ModItems.WATER_ARMOR;
            case "earth" -> ModItems.EARTH_ARMOR;
            case "air" -> ModItems.AIR_ARMOR;
            default -> new ArmorSet("necro", SpellSchools.NECROMANCY);
        };
    }

    @Override
    public SpellSchool getSchool() {
        return this.school;
    }
}

