/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.ai.CastGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;

public class ProjCastingGoal<T extends Mob>
extends CastGoal<T> {
    private int strafingTime;
    private boolean strafingBackwards;
    private boolean strafingClockwise;

    public ProjCastingGoal(T entity, double speed, int attackInterval, float attackRange, Supplier<Boolean> canUse, int animId, int delayTicks) {
        super(entity, speed, attackInterval, attackRange, canUse, animId, delayTicks);
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return;
        }
        double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        boolean canSeeEnemy = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
        if (canSeeEnemy != this.seeTime > 0) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeEnemy ? ++this.seeTime : --this.seeTime;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
            this.mob.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
        } else {
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
        }
        this.animationChecks(livingentity);
    }

    void animationChecks(LivingEntity target) {
        if (this.seeTime >= 40 && !this.hasAnimated) {
            this.hasAnimated = true;
            Networking.sendToNearbyClient((Level)this.mob.level, (Entity)this.mob, (CustomPacketPayload)new PacketAnimEntity(this.mob.getId(), this.animId));
        }
        if (this.hasAnimated) {
            ++this.animatedTicks;
            if (this.animatedTicks >= this.delayTicks) {
                ((RangedAttackMob)this.mob).performRangedAttack(target, 1.0f);
                this.done = true;
            }
        }
    }
}

