/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.common.glyphs.EffectSpike;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DripstoneSpikeEntity
extends Entity
implements GeoEntity,
IEntityWithComplexSpawn {
    private LivingEntity caster;
    private UUID casterUUID;
    private int lifeTicks = 20;
    float damage;
    SpellStats stats;
    SpellContext context;
    SpellResolver resolver;
    double pierce;
    double aoe = 1.0;
    private static final RawAnimation SPROUT_ANIM = RawAnimation.begin().thenPlay("sprout");
    public final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DripstoneSpikeEntity(Level worldIn, BlockPos pos, float damage, LivingEntity casterIn, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        this((EntityType)ModEntities.DRIPSTONE_SPIKE.get(), worldIn, pos, damage, casterIn, spellStats, context, resolver);
    }

    public double getPierce() {
        return this.pierce;
    }

    public double getAoe() {
        return this.aoe;
    }

    public DripstoneSpikeEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DripstoneSpikeEntity(EntityType<?> pEntityType, Level worldIn, BlockPos pos, float damage, LivingEntity casterIn, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        this(pEntityType, worldIn);
        this.setOwner(casterIn);
        this.setPos(pos.getCenter().add(0.0, 0.5, 0.0));
        this.damage = damage;
        this.stats = spellStats;
        this.context = context;
        this.resolver = resolver;
        this.pierce = 1.0 + (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE) * 0.25;
        this.aoe = 1.0 + (spellStats.getAoeMultiplier() - 1.0) * 0.25;
        this.lifeTicks += (int)(5.0 * spellStats.getDurationMultiplier());
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.DRIPSTONE_SPIKE.get();
    }

    public boolean damage(LivingEntity entity) {
        return EffectSpike.INSTANCE.attemptDamage(entity.level(), this.caster, this.stats, this.context, this.resolver, (Entity)entity, DamageUtil.source((LevelAccessor)entity.level(), (ResourceKey)DamageTypes.STALAGMITE, (Entity)this.caster), this.damage);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder pBuilder) {
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.caster = pOwner;
        this.casterUUID = pOwner == null ? null : pOwner.getUUID();
    }

    public void tick() {
        if (!this.level().isClientSide() && (double)this.lifeTicks < 16.0 + this.stats.getDurationMultiplier() * 5.0 && this.lifeTicks % 5 == 0) {
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), e -> e instanceof LivingEntity)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)entity;
                this.damage(target);
            }
        }
        if (--this.lifeTicks < 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (this.caster == null && this.casterUUID != null && (level = this.level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.casterUUID)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public boolean isAlliedTo(@NotNull Entity pEntity) {
        if (this.getOwner() != null) {
            return pEntity == this.getOwner() || this.getOwner().isAlliedTo(pEntity);
        }
        return super.isAlliedTo(pEntity);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("OwnerUUID")) {
            this.casterUUID = compound.getUUID("OwnerUUID");
        }
        this.pierce = compound.getDouble("pierce");
        this.aoe = compound.getDouble("aoe");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        if (this.casterUUID != null) {
            compound.putUUID("OwnerUUID", this.casterUUID);
        }
        compound.putDouble("pierce", this.pierce);
        compound.putDouble("aoe", this.aoe);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController((GeoAnimatable)this, "controller", 0, a -> a.setAndContinue(SPROUT_ANIM)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pPose) {
        EntityDimensions base = super.getDimensions(pPose);
        return EntityDimensions.scalable((float)((float)((double)base.width() * this.aoe)), (float)((float)((double)base.height() * (this.aoe + this.pierce - 0.5))));
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(this.pierce);
        buffer.writeDouble(this.aoe);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.pierce = additionalData.readDouble();
        this.aoe = additionalData.readDouble();
    }
}

