/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.mermaid_block;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.registry.ModTiles;
import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class MermaidTile
extends SummoningTile
implements ITooltipProvider {
    public int progress;
    public int bonus;
    public boolean needsMana;
    public static final ParticleColor shrineParticle = new ParticleColor(20, 100, 200);

    public MermaidTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.MERMAID_TILE.get(), pos, state);
    }

    public void convertedEffect() {
        super.convertedEffect();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.tickCounter >= 120) {
                this.converted = true;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
                MermaidEntity mermaid = new MermaidEntity(this.level, true);
                mermaid.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5);
                mermaid.setHome(this.getBlockPos());
                this.level.addFreshEntity((Entity)mermaid);
                ParticleUtil.spawnPoof((ServerLevel)world, (BlockPos)this.worldPosition.above());
                this.tickCounter = 0;
                return;
            }
            if (this.tickCounter % 10 == 0) {
                RandomSource r = this.level.random;
                int min = -2;
                int max = 2;
                EntityFollowProjectile proj1 = new EntityFollowProjectile(this.level, this.worldPosition.offset(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.worldPosition, r.nextInt(255), r.nextInt(255), r.nextInt(255));
                this.level.addFreshEntity((Entity)proj1);
            }
        }
    }

    public int getMaxProgress() {
        return (Integer)ConfigHandler.Common.SIREN_MAX_PROGRESS.get();
    }

    public void giveProgress() {
        if (this.progress < this.getMaxProgress() && this.level != null) {
            ++this.progress;
            this.updateBlock();
        }
    }

    public void evaluateAquarium() {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        HashSet<BlockState> blocks = new HashSet<BlockState>();
        int score = 0;
        int water = 0;
        for (BlockPos b2 : BlockPos.betweenClosed((BlockPos)this.getBlockPos().north(8).west(8).below(10), (BlockPos)this.getBlockPos().south(8).east(8).above(10))) {
            if (world.isOutsideBuildHeight(b2)) continue;
            BlockState block = world.getBlockState(b2);
            int points = this.getScore(block);
            switch (points) {
                case 0: 
                case 1: {
                    ++water;
                }
            }
            score += blocks.add(block) ? points : 0;
        }
        if (water > 50) {
            HashSet entities = new HashSet();
            score += this.getNearbyEntities().stream().filter(b -> entities.add(b.getType())).mapToInt(b -> 5).sum();
        }
        this.bonus = score;
    }

    public int getScore(BlockState state) {
        if (state.isAir()) {
            return 0;
        }
        if (state == Blocks.WATER.defaultBlockState()) {
            return 1;
        }
        if (state.is(BlockTags.CORALS) || state.getBlock() instanceof KelpPlantBlock || state.getBlock() instanceof CoralBlock) {
            return 2;
        }
        return 0;
    }

    ItemStack getRod() {
        return Items.FISHING_ROD.getDefaultInstance();
    }

    public void generateItems() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)server);
        ReloadableServerRegistries.Holder lootData = server.getServer().reloadableRegistries();
        LootTable lootTable = lootData.getLootTable(BuiltInLootTables.FISHING);
        LootTable lootTableTreasure = lootData.getLootTable(BuiltInLootTables.FISHING_TREASURE);
        LootTable lootTableJunk = lootData.getLootTable(BuiltInLootTables.FISHING_JUNK);
        LootParams lootContext = new LootParams.Builder(server).withParameter(LootContextParams.ORIGIN, (Object)fakePlayer.position()).withParameter(LootContextParams.TOOL, (Object)this.getRod()).create(LootContextParamSets.FISHING);
        boolean flag = true;
        int bonus_rolls = Math.min(this.bonus / 25, (Integer)ConfigHandler.Common.SIREN_UNIQUE_BONUS.get());
        int counter = 0;
        for (int i = 0; i < (Integer)ConfigHandler.Common.SIREN_BASE_ITEM.get() + bonus_rolls; ++i) {
            ObjectArrayList list;
            if (flag && this.bonus > 50 && this.level.random.nextDouble() < Math.max(0.1, (double)this.bonus * (Double)ConfigHandler.Common.SIREN_TREASURE_BONUS.get())) {
                list = lootTableTreasure.getRandomItems(lootContext);
                flag = false;
            } else {
                list = flag && this.bonus <= 25 && this.level.random.nextDouble() < 0.5 ? lootTableJunk.getRandomItems(lootContext) : lootTable.getRandomItems(lootContext);
            }
            for (ItemStack item : list) {
                BlockUtil.insertItemAdjacent((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)item);
                ++counter;
            }
            if (counter >= (Integer)ConfigHandler.Common.SIREN_QUANTITY_CAP.get()) break;
        }
        this.progress = 0;
        this.needsMana = true;
        this.updateBlock();
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.isOff) {
            return;
        }
        if (this.level.isClientSide() && !this.needsMana) {
            for (int i = 0; i < this.progress / 2; ++i) {
                this.level.addParticle(GlowParticleData.createData((ParticleColor)shrineParticle, (float)((float)i / 2.0f * 0.2f), (float)((float)i / 2.0f * 0.75f), (int)20), (double)this.getBlockPos().getX() + 0.5 + ParticleUtil.inRange((double)-0.1, (double)0.1), (double)this.getBlockPos().getY() + 1.0 + ParticleUtil.inRange((double)-0.1, (double)0.1), (double)this.getBlockPos().getZ() + 0.5 + ParticleUtil.inRange((double)-0.1, (double)0.1), 0.0, 0.0, 0.0);
            }
        } else {
            long gameTime = this.level.getGameTime();
            if (gameTime % 2400L == 0L) {
                this.evaluateAquarium();
            }
            if (gameTime % 80L == 0L && this.needsMana && SourceUtil.takeSourceWithParticles((BlockPos)this.worldPosition, (Level)this.level, (int)7, (int)((Integer)ConfigHandler.Common.SIREN_MANA_COST.get())) != null) {
                this.needsMana = false;
                this.updateBlock();
            }
            if (gameTime % 2000L == 0L && !this.needsMana) {
                if (this.progress >= this.getMaxProgress()) {
                    this.generateItems();
                } else {
                    LivingEntity rnd = this.getRandomEntity();
                    if (rnd != null) {
                        EntityLerpedProjectile orb = new EntityLerpedProjectile(this.level, rnd.blockPosition(), this.getBlockPos(), 20, 50, 255);
                        this.level.addFreshEntity((Entity)orb);
                        this.giveProgress();
                    }
                }
            }
        }
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.needsMana) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.wixie.need_mana"));
        } else {
            tooltip.add((Component)Component.translatable((String)("Aquarium Bonus: " + this.bonus)));
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.progress = compound.getInt("progress");
        this.bonus = compound.getInt("bonus");
        this.needsMana = compound.getBoolean("needsMana");
        super.loadAdditional(compound, pRegistries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("progress", this.progress);
        tag.putInt("bonus", this.bonus);
        tag.putBoolean("needsMana", this.needsMana);
    }

    public LivingEntity getRandomEntity() {
        if (this.getNearbyEntities().isEmpty() || this.level == null) {
            return null;
        }
        return this.getNearbyEntities().get(this.level.random.nextInt(this.getNearbyEntities().size()));
    }

    private List<LivingEntity> getNearbyEntities() {
        if (this.level == null) {
            return ImmutableList.of();
        }
        return this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().north(10).west(10).below(10).getCenter(), this.getBlockPos().south(10).east(10).above(10).getCenter()), e -> e.getType().is(EntityTypeTags.AQUATIC) && !(e instanceof MermaidEntity));
    }
}

