/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.registry.ModTiles;
import alexthw.ars_elemental.util.BotaniaCompat;
import alexthw.ars_elemental.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EverfullUrnTile
extends ModdedTile
implements ITickable,
IWandable,
ITooltipProvider {
    Set<BlockPos> toList = new HashSet<BlockPos>();
    static final FluidStack waterStack = new FluidStack((Fluid)Fluids.WATER, 1000);

    public EverfullUrnTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.URN_TILE.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        if (this.level == null || this.level.getGameTime() % 60L != 0L || this.toList.isEmpty() || this.level.isClientSide) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos toPos : this.toList) {
            if (!this.level.isLoaded(toPos)) continue;
            if (!this.isRefillable(toPos, this.level)) {
                stale.add(toPos);
                continue;
            }
            if (!SourceUtil.hasSourceNearby((BlockPos)this.worldPosition, (Level)this.level, (int)6, (int)((Integer)ConfigHandler.Common.WATER_URN_COST.get())) || !this.tryRefill(this.level, toPos)) continue;
            SourceUtil.takeSourceWithParticles((BlockPos)this.getBlockPos(), (Level)this.level, (int)6, (int)((Integer)ConfigHandler.Common.WATER_URN_COST.get()));
            this.createParticles(this.worldPosition.above(), toPos);
        }
        for (BlockPos s : stale) {
            this.toList.remove(s);
        }
        this.updateBlock();
    }

    private boolean tryRefill(Level world, BlockPos toPos) {
        if (world.getBlockState(toPos) == Blocks.CAULDRON.defaultBlockState()) {
            world.setBlockAndUpdate(toPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
            return true;
        }
        IFluidHandler tank = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, toPos, (Object)Direction.UP);
        if (tank != null && tank.fill(waterStack, IFluidHandler.FluidAction.SIMULATE) > 100) {
            tank.fill(waterStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return CompatUtils.isBotaniaLoaded() && BotaniaCompat.tryFillApothecary(toPos, world);
    }

    public void onWanded(Player playerEntity) {
        this.clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
    }

    public void clearPos() {
        this.toList.clear();
        this.updateBlock();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || !(this.level instanceof ServerLevel) || storedPos.equals((Object)this.getBlockPos())) {
            return;
        }
        if (this.isRefillable(storedPos, this.level)) {
            if (this.setSendTo(storedPos.immutable())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
                ParticleUtil.beam((BlockPos)storedPos, (BlockPos)this.worldPosition, (Level)this.level);
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail"));
            }
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail.urn"));
        }
    }

    private boolean isRefillable(BlockPos storedPos, Level level) {
        if (storedPos == null) {
            return false;
        }
        if (level.getBlockState(storedPos).getBlock() instanceof AbstractCauldronBlock) {
            return true;
        }
        if (level.getBlockEntity(storedPos) != null && level.getCapability(Capabilities.FluidHandler.BLOCK, storedPos, (Object)Direction.UP) != null) {
            return true;
        }
        return CompatUtils.isBotaniaLoaded() && BotaniaCompat.isApothecary(storedPos, level);
    }

    public void createParticles(BlockPos from, BlockPos to) {
        if (this.level == null) {
            return;
        }
        EntityLerpedProjectile orb = new EntityLerpedProjectile(this.level, from, to, 20, 50, 255);
        this.level.addFreshEntity((Entity)orb);
    }

    public boolean setSendTo(BlockPos pos) {
        if (this.closeEnough(pos)) {
            this.toList.add(pos);
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean closeEnough(BlockPos pos) {
        return BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.worldPosition) <= this.getMaxDistance() && !pos.equals((Object)this.getBlockPos());
    }

    private double getMaxDistance() {
        return 30.0;
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.toList == null || this.toList.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{this.toList.size()}));
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.toList = new HashSet<BlockPos>();
        int counter = 0;
        while (NBTUtil.hasBlockPos((CompoundTag)tag, (String)("to_" + counter))) {
            BlockPos pos = NBTUtil.getNullablePos((CompoundTag)tag, (String)("to_" + counter));
            if (pos != null) {
                this.toList.add(pos);
            }
            ++counter;
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        int counter = 0;
        for (BlockPos p : this.toList) {
            NBTUtil.storeBlockPos((CompoundTag)tag, (String)("to_" + counter), (BlockPos)p);
            ++counter;
        }
    }
}

