/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.patchouli;

import alexthw.ars_elemental.recipe.ElementalArmorRecipe;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ElementalArmorProcessor
implements IComponentProcessor {
    private RecipeHolder<? extends ElementalArmorRecipe> holder;

    public void setup(Level level, IVariableProvider variables) {
        RecipeManager manager = level.getRecipeManager();
        String recipeID = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        try {
            this.holder = manager.byKey(ResourceLocation.tryParse((String)recipeID)).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.holder == null) {
            return IVariable.empty();
        }
        ElementalArmorRecipe recipe = (ElementalArmorRecipe)this.holder.value();
        return switch (key) {
            case "reagent" -> IVariable.wrapList((Iterable)Arrays.stream(recipe.reagent().getItems()).peek(i -> i.set((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)((ArmorPerkHolder)i.get((Supplier)DataComponentRegistry.ARMOR_PERKS)).setTier(2))).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
            case "recipe" -> IVariable.wrap((String)this.holder.id().toString(), (HolderLookup.Provider)level.registryAccess());
            case "tier" -> IVariable.wrap((String)recipe.getOutputComponent().getString(), (HolderLookup.Provider)level.registryAccess());
            case "output" -> IVariable.from((Object)recipe.result(), (HolderLookup.Provider)level.registryAccess());
            case "footer" -> IVariable.wrap((String)recipe.result().getItem().getDescriptionId(), (HolderLookup.Provider)level.registryAccess());
            default -> IVariable.empty();
        };
    }
}

