/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.gui.SimChamberContainer;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.tile.SimChamberTileEntity;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableText;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SimChamberScreen
extends PlaceboContainerScreen<SimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 230;
    private static final ResourceLocation BASE = HostileNetworks.loc("textures/gui/sim_chamber.png");
    private static final ResourceLocation PLAYER = HostileNetworks.loc("textures/gui/default_gui.png");
    private List<TickableText> body = new ArrayList<TickableText>(7);
    private SimChamberTileEntity.FailureState lastFailState = SimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = Component.literal((String)"ERROR").withStyle(ChatFormatting.OBFUSCATED);

    public SimChamberScreen(SimChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 232;
        this.imageHeight = 230;
    }

    protected void renderTooltip(GuiGraphics gfx, int pX, int pY) {
        if (this.isHovering(211, 48, 7, 87, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.translatable((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((SimChamberContainer)this.menu).getEnergyStored(), HostileConfig.simPowerCap}));
            DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
            if (cModel.isValid()) {
                txt.add(Component.translatable((String)"hostilenetworks.gui.cost", (Object[])new Object[]{cModel.getModel().simCost()}));
            }
            gfx.renderComponentTooltip(this.font, txt, pX, pY);
        } else if (this.isHovering(14, 48, 7, 87, pX, pY)) {
            DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
            if (cModel.isValid()) {
                ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(1);
                if (!cModel.getTier().isMax()) {
                    txt.add(Component.translatable((String)"hostilenetworks.gui.data", (Object[])new Object[]{cModel.getData() - cModel.getTierData(), cModel.getNextTierData() - cModel.getTierData()}));
                } else {
                    txt.add(Component.translatable((String)"hostilenetworks.gui.max_data").withStyle(ChatFormatting.RED));
                }
                gfx.renderComponentTooltip(this.font, txt, pX, pY);
            }
        } else {
            super.renderTooltip(gfx, pX, pY);
        }
    }

    protected void renderLabels(GuiGraphics gfx, int pX, int pY) {
        DataModelInstance cModel;
        int runtime = ((SimChamberContainer)this.menu).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.ceil((float)(100.0f * (float)(300 - runtime) / 300.0f)));
            gfx.drawString(this.font, rTime + "%", 184, 123, 6478079, true);
        }
        if ((cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0)).isValid()) {
            int xOff = 18;
            String msg = I18n.get((String)"hostilenetworks.gui.target", (Object[])new Object[0]);
            gfx.drawString(this.font, msg, xOff, 9, 0xFFFFFF);
            gfx.drawString(this.font, cModel.getModel().name(), xOff += this.font.width(msg), 9, 65472);
            xOff = 18;
            msg = I18n.get((String)"hostilenetworks.gui.tier", (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, msg, xOff, 9 + 9 + 3, 0xFFFFFF);
            xOff += this.font.width(msg);
            msg = I18n.get((String)("hostilenetworks.tier." + cModel.getTier().name()), (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, msg, xOff, 9 + 9 + 3, cModel.getTier().colorValue());
            xOff = 18;
            msg = I18n.get((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, msg, xOff, 9 + (9 + 3) * 2, 0xFFFFFF);
            xOff += this.font.width(msg);
            DecimalFormat fmt = new DecimalFormat("##.##%");
            msg = fmt.format(cModel.getAccuracy());
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, msg, xOff, 9 + (9 + 3) * 2, cModel.getTier().colorValue());
        }
        int left = 29;
        int top = 51;
        Objects.requireNonNull(this.font);
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.font, gfx, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 29;
                continue;
            }
            left += t.getWidth(this.font);
        }
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.blit(BASE, left + 8, top, 0.0f, 0.0f, 216, 141, 256, 256);
        gfx.blit(BASE, left - 14, top, 0.0f, 141.0f, 18, 18, 256, 256);
        int energyHeight = 87 - Mth.ceil((float)(87.0f * (float)((SimChamberContainer)this.menu).getEnergyStored() / (float)HostileConfig.simPowerCap));
        gfx.blit(BASE, left + 211, top + 48, 18.0f, 141.0f, 7, energyHeight, 256, 256);
        int dataHeight = 87;
        DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
        if (cModel.isValid()) {
            int data = cModel.getData();
            ModelTier tier = cModel.getTier();
            dataHeight = tier.isMax() ? 0 : 87 - Mth.ceil((float)(87.0f * (float)(data - cModel.getTierData()) / (float)(cModel.getNextTierData() - cModel.getTierData())));
        }
        gfx.blit(BASE, left + 14, top + 48, 18.0f, 141.0f, 7, dataHeight, 256, 256);
        gfx.blit(PLAYER, left + 28, top + 145, 0.0f, 0.0f, 176, 90, 256, 256);
    }

    public void containerTick() {
        if (((SimChamberContainer)this.menu).getFailState() != SimChamberTileEntity.FailureState.NONE) {
            SimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((SimChamberContainer)this.menu).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                String[] msg = I18n.get((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                if (this.lastFailState == SimChamberTileEntity.FailureState.INPUT) {
                    DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
                    Component name = ERROR;
                    if (cModel.isValid()) {
                        name = cModel.getModel().input().getItems()[0].getHoverName();
                    }
                    msg = I18n.get((String)this.lastFailState.getKey(), (Object[])new Object[]{name.getString()}).split("\\n");
                }
                for (String s : msg) {
                    this.body.add(new TickableText(s, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = 300 - ((SimChamberContainer)this.menu).getRuntime();
            float speed = 0.65f;
            this.body.clear();
            int iters = DataModelItem.getIters(((SimChamberContainer)this.menu).getSlot(0).getItem());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.get((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v" + HostileNetworks.VERSION, ChatFormatting.GOLD.getColor().intValue(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String key = "hostilenetworks.color_text." + (((SimChamberContainer)this.menu).didPredictionSucceed() ? "success" : "failed");
                txt = new TickableText(I18n.get((String)key, (Object[])new Object[0]), (((SimChamberContainer)this.menu).didPredictionSucceed() ? ChatFormatting.GOLD : ChatFormatting.RED).getColor().intValue(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((SimChamberContainer)this.menu).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

