/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.client.WrappedRTBuffer;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.gui.DeepLearnerContainer;
import dev.shadowsoffire.hostilenetworks.util.ReflectionThings;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableText;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DeepLearnerScreen
extends PlaceboContainerScreen<DeepLearnerContainer> {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    public static final ResourceLocation BASE = HostileNetworks.loc("textures/gui/deep_learner.png");
    public static final ResourceLocation PLAYER = HostileNetworks.loc("textures/gui/default_gui.png");
    public static final WidgetSprites LEFT_BUTTON = DeepLearnerScreen.makeSprites("widget/left", "widget/left_hovered");
    public static final WidgetSprites RIGHT_BUTTON = DeepLearnerScreen.makeSprites("widget/right", "widget/right_hovered");
    private List<TickableText> texts = new ArrayList<TickableText>();
    private TickableText stats = new TickableText(I18n.get((String)"hostilenetworks.gui.stats", (Object[])new Object[0]), 6478079);
    private final String[] statArray = new String[3];
    private int numModels = 0;
    private boolean emptyText = true;
    private DataModelInstance[] models = new DataModelInstance[4];
    private int spin = 65;
    private int selectedModel = 0;
    private ImageButton btnLeft;
    private ImageButton btnRight;
    private int variant = 0;
    private int ticksShown = 0;
    private static DecimalFormat fmt = new DecimalFormat("##.##%");

    public DeepLearnerScreen(DeepLearnerContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 338;
        this.imageHeight = 235;
        this.setupEmptyText();
        Arrays.fill(this.models, DataModelInstance.EMPTY);
        this.minecraft = Minecraft.getInstance();
        pMenu.setNotifyCallback(slotId -> {
            ItemStack stack = pMenu.getSlot((int)slotId).getItem();
            DataModelInstance old = this.models[slotId];
            this.models[slotId.intValue()] = new DataModelInstance(stack, (int)slotId);
            if (!old.isValid() && this.models[slotId].isValid()) {
                if (++this.numModels == 1) {
                    this.selectedModel = slotId;
                    this.setupModel(this.getCurrentModel());
                    this.emptyText = false;
                }
            } else if (old.isValid() && !this.models[slotId].isValid()) {
                --this.numModels;
                if (this.numModels > 0 && slotId == this.selectedModel) {
                    this.selectLeft();
                }
            } else if (slotId == this.selectedModel && this.models[this.selectedModel].isValid()) {
                this.setupModel(this.models[this.selectedModel]);
            }
        });
    }

    protected DataModelInstance getCurrentModel() {
        return this.models[this.selectedModel];
    }

    public void init() {
        super.init();
        this.btnLeft = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() - 27, this.getGuiTop() + 105, 24, 24, LEFT_BUTTON, btn -> this.selectLeft()));
        this.btnRight = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() - 1, this.getGuiTop() + 105, 24, 24, RIGHT_BUTTON, btn -> this.selectRight()));
    }

    public void selectLeft() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        DataModelInstance model = this.models[this.clamp(this.selectedModel - 1)];
        while (!model.isValid()) {
            model = this.models[this.clamp(this.selectedModel - 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    public void selectRight() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        DataModelInstance model = this.models[this.clamp(this.selectedModel + 1)];
        while (!model.isValid()) {
            model = this.models[this.clamp(this.selectedModel + 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    private int clamp(int idx) {
        if (idx == -1) {
            idx = 3;
        }
        if (idx == 4) {
            idx = 0;
        }
        this.selectedModel = idx;
        return this.selectedModel;
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.blit(BASE, left + 41, top, 0, 0, 256, 140);
        if (this.numModels > 0) {
            for (int i = 0; i < 3; ++i) {
                int n = left + 338 - 49 - this.stats.getWidth(this.font);
                Objects.requireNonNull(this.font);
                Objects.requireNonNull(this.font);
                gfx.blit(BASE, n, top + 8 + 9 + (9 + 2) * i, 0, 140 + 9 * i, 9, 9);
            }
            gfx.blit(BASE, left - 41, top, 9, 140, 75, 101);
            DataModelInstance model = this.getCurrentModel();
            if (model.isValid()) {
                Entity ent = model.getEntity((Level)this.minecraft.level, this.variant);
                if (ent instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)ent;
                    living.yBodyRot = this.spin % 360;
                }
                this.renderEntityInInventory(gfx, left - 4, top + 90, 40.0f, 0.0f, 0.0f, ent);
            }
            for (int i = 0; i < 3; ++i) {
                String string = this.statArray[i];
                int n = left + 338 - 36 - this.stats.getWidth(this.font);
                Objects.requireNonNull(this.font);
                Objects.requireNonNull(this.font);
                gfx.drawString(this.font, string, n, top + 9 + 9 + (9 + 2) * i, 0xFFFFFF);
            }
        }
        gfx.blit(PLAYER, left + 81, top + 145, 0, 0, 176, 90);
        if (this.numModels <= 1) {
            this.btnLeft.visible = false;
            this.btnRight.visible = false;
        } else {
            this.btnLeft.visible = true;
            this.btnRight.visible = true;
        }
    }

    protected void renderLabels(GuiGraphics gfx, int pX, int pY) {
        int left = 49;
        int top = 6;
        Objects.requireNonNull(this.font);
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.texts) {
            t.render(this.font, gfx, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 49;
                continue;
            }
            left += t.getWidth(this.font);
        }
        if (this.numModels > 0) {
            this.stats.render(this.font, gfx, 289 - this.stats.getWidth(this.font), top);
        }
    }

    public void containerTick() {
        int i;
        block5: {
            block4: {
                if (((DeepLearnerContainer)this.menu).hasModels()) break block4;
                if (this.emptyText) break block5;
                this.setupEmptyText();
                this.emptyText = true;
                break block5;
            }
            if (this.emptyText) {
                for (i = 0; i < 4; ++i) {
                    if (!this.models[i].isValid()) continue;
                    this.setupModel(this.models[i]);
                    this.selectedModel = i;
                    this.emptyText = false;
                    break;
                }
            }
        }
        for (i = 0; i < this.texts.size(); ++i) {
            TickableText txt = this.texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
        this.stats.tick();
        ++this.spin;
        if (++this.ticksShown % 80 == 0) {
            this.nextVariant();
        }
    }

    private void nextVariant() {
        DataModelInstance current = this.getCurrentModel();
        if (!current.isValid()) {
            return;
        }
        int variants = current.getModel().variants().size();
        if (variants == 0) {
            return;
        }
        this.variant = (this.variant + 1) % (variants + 1);
        Entity entity = current.getEntity((Level)this.minecraft.level, this.variant);
        if (this.variant == 0) {
            this.texts.set(1, new TickableText(entity.getType().getDescription().getString(), 0xFFFFFF, true, 2.0f).setTicks(9999));
        } else {
            this.texts.set(1, new TickableText(I18n.get((String)"hostilenetworks.gui.variant", (Object[])new Object[]{entity.getType().getDescription().getString()}), 65472, true, 2.0f).setTicks(9999));
        }
    }

    private void setupEmptyText() {
        this.resetText();
        for (int i = 0; i < 7; ++i) {
            this.addText(I18n.get((String)("hostilenetworks.gui.learner_empty." + i), (Object[])new Object[0]), i == 0 ? 6478079 : 0xFFFFFF);
        }
    }

    private void setupModel(DataModelInstance cache) {
        int i;
        if (!cache.isValid()) {
            return;
        }
        DataModel model = cache.getModel();
        this.ticksShown = 0;
        this.variant = 0;
        this.resetText();
        this.addText(I18n.get((String)"hostilenetworks.gui.name", (Object[])new Object[0]), 6478079);
        this.addText(cache.getEntity((Level)this.minecraft.level).getType().getDescription().getString(), 0xFFFFFF);
        this.addText(I18n.get((String)"hostilenetworks.gui.info", (Object[])new Object[0]), 6478079);
        String[] trivia = I18n.get((String)model.triviaKey(), (Object[])new Object[0]).split("\\n");
        for (i = 0; i < Math.min(4, trivia.length); ++i) {
            this.addText(trivia[i], 0xFFFFFF);
        }
        for (i = trivia.length; i < 5; ++i) {
            this.addText("", 0);
        }
        this.addText(I18n.get((String)"hostilenetworks.gui.tier", (Object[])new Object[0]), 0xFFFFFF, false);
        ModelTier tier = cache.getTier();
        ModelTier next = ModelTierRegistry.next(tier);
        this.addText(I18n.get((String)("hostilenetworks.tier." + tier.name()), (Object[])new Object[0]), tier.colorValue());
        this.addText(I18n.get((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]), 0xFFFFFF, false);
        this.addText(fmt.format(cache.getAccuracy()), tier.colorValue());
        if (!tier.isMax()) {
            if (HostileConfig.killModelUpgrade) {
                this.addText(I18n.get((String)"hostilenetworks.gui.next_tier", (Object[])new Object[0]), 0xFFFFFF, false);
                this.addText(I18n.get((String)("hostilenetworks.tier." + next.name()), (Object[])new Object[0]), next.colorValue(), false);
                this.addText(I18n.get((String)"hostilenetworks.gui.next_tier2", (Object[])new Object[]{cache.getKillsNeeded()}), 0xFFFFFF, false);
                this.addText(I18n.get((String)("hostilenetworks.gui.kill" + (cache.getKillsNeeded() > 1 ? "s" : "")), (Object[])new Object[0]), 0xFFFFFF);
            } else {
                this.addText(I18n.get((String)"hostilenetworks.gui.upgrade_disabled", (Object[])new Object[0]), 0xFFFFFF);
            }
        } else {
            this.addText(I18n.get((String)"hostilenetworks.gui.max_tier", (Object[])new Object[0]), ChatFormatting.RED.getColor());
        }
        Entity ent = cache.getEntity((Level)this.minecraft.level);
        if (ent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)ent;
            this.statArray[0] = String.valueOf((int)(living.getAttribute(Attributes.MAX_HEALTH).getBaseValue() / 2.0));
            this.statArray[1] = String.valueOf((int)(living.getAttribute(Attributes.ARMOR).getBaseValue() / 2.0));
            this.statArray[2] = String.valueOf(ReflectionThings.getBaseExperienceReward(living));
        } else {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.statArray[i2] = "\u00a7k99999";
            }
        }
    }

    private void addText(String msg, int color) {
        this.texts.add(new TickableText(msg, color, true, 2.0f));
    }

    private void addText(String msg, int color, boolean newline) {
        this.texts.add(new TickableText(msg, color, newline, 2.0f));
    }

    private void resetText() {
        this.texts.clear();
        this.stats.reset();
    }

    public void renderEntityInInventory(GuiGraphics gfx, float pPosX, float pPosY, float scale, float pMouseX, float pMouseY, Entity entity) {
        float f1 = (float)Math.atan(pMouseY / 40.0f);
        PoseStack pose = gfx.pose();
        pose.pushPose();
        DataModel model = this.getCurrentModel().getModel();
        pose.translate(pPosX, pPosY, 50.0f);
        pose.scale(scale *= model.display().scale(), scale, -scale);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(f1 * 20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        pose.mulPose(quaternion);
        pose.mulPose(Axis.YP.rotationDegrees(((float)this.spin + this.minecraft.getTimer().getGameTimeDeltaPartialTick(true)) * 2.25f % 360.0f));
        entity.setYRot(0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.yBodyRot = entity.getYRot();
            living.yHeadRot = entity.getYRot();
            living.yHeadRotO = entity.getYRot();
        }
        EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        entityrenderermanager.overrideCameraOrientation(quaternion1);
        entityrenderermanager.setRenderShadow(false);
        MultiBufferSource.BufferSource rtBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityrenderermanager.render(entity, (double)model.display().xOffset(), (double)model.display().yOffset(), (double)model.display().zOffset(), 0.0f, 1.0f, pose, (MultiBufferSource)new WrappedRTBuffer((MultiBufferSource)rtBuffer), 0xF000F0));
        rtBuffer.endBatch();
        entityrenderermanager.setRenderShadow(true);
        pose.popPose();
        Lighting.setupFor3DItems();
    }

    public static WidgetSprites makeSprites(String base, String hovered) {
        return new WidgetSprites(HostileNetworks.loc(base), HostileNetworks.loc(base), HostileNetworks.loc(hovered), HostileNetworks.loc(hovered));
    }
}

