/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.datagen.LootProvider;
import dev.shadowsoffire.hostilenetworks.net.OpenDeepLearnerPayload;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import net.minecraft.core.Holder;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hostilenetworks")
public class HostileNetworks {
    public static final String MODID = "hostilenetworks";
    public static final String VERSION = ((ModContainer)ModList.get().getModContainerById("hostilenetworks").get()).getModInfo().getVersion().toString();
    public static final Logger LOGGER = LogManager.getLogger((String)"hostilenetworks");
    public static Configuration cfg;

    public HostileNetworks(IEventBus bus) {
        bus.register((Object)this);
        cfg = HostileConfig.load();
        Hostile.bootstrap(bus);
        PayloadHelper.registerPayload((PayloadProvider)new HostileConfig.ConfigPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new OpenDeepLearnerPayload.Provider());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> TabFillingRegistry.register((ResourceKey)Hostile.Tabs.HNN_TAB.getKey(), (Holder[])new Holder[]{Hostile.Items.SIM_CHAMBER, Hostile.Items.LOOT_FABRICATOR, Hostile.Items.DEEP_LEARNER, Hostile.Items.BLANK_DATA_MODEL, Hostile.Items.PREDICTION_MATRIX, Hostile.Items.OVERWORLD_PREDICTION, Hostile.Items.NETHER_PREDICTION, Hostile.Items.END_PREDICTION, Hostile.Items.TWILIGHT_PREDICTION, Hostile.Items.DATA_MODEL, Hostile.Items.PREDICTION}));
        DataModelRegistry.INSTANCE.registerToBus();
        ModelTierRegistry.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void caps(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Hostile.TileEntities.LOOT_FABRICATOR, (be, side) -> be.getEnergy());
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Hostile.TileEntities.LOOT_FABRICATOR, (be, side) -> be.getInventory());
        e.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Hostile.TileEntities.SIM_CHAMBER, (be, side) -> be.getEnergy());
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Hostile.TileEntities.SIM_CHAMBER, (be, side) -> be.getInventory());
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        e.getGenerator().addProvider(true, (DataProvider)LootProvider.create(e.getGenerator().getPackOutput(), e.getLookupProvider()));
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

