/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.Sign;
import net.puffish.attributesmod.util.Signed;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Inventory.class})
public class PlayerInventoryMixin {
    @ModifyReturnValue(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")})
    private float injectAtGetBlockBreakingSpeed(float speed) {
        if (speed <= 1.0f) {
            return speed;
        }
        Inventory inventory = (Inventory)this;
        Player player = inventory.player;
        Item item = inventory.getSelected().getItem();
        ArrayList<Signed<AttributeInstance>> attributes = new ArrayList<Signed<AttributeInstance>>();
        if (item instanceof PickaxeItem) {
            attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.PICKAXE_SPEED)));
        }
        if (item instanceof AxeItem) {
            attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.AXE_SPEED)));
        }
        if (item instanceof ShovelItem) {
            attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.SHOVEL_SPEED)));
        }
        attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.MINING_SPEED)));
        return (float)AttributesMod.applyAttributeModifiers(speed, (Signed[])attributes.toArray(Signed[]::new));
    }
}

