/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.DamageKind;
import net.puffish.attributesmod.util.Sign;
import net.puffish.attributesmod.util.Signed;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin {
    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ArrayList<Signed<AttributeInstance>> attributes = new ArrayList<Signed<AttributeInstance>>();
            DamageKind kind = DamageKind.of(source);
            if (kind.isMagic()) {
                attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.MAGIC_DAMAGE)));
            }
            if (kind.isProjectile()) {
                attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.RANGED_DAMAGE)));
            }
            if (kind.isMelee()) {
                attributes.add(Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.MELEE_DAMAGE)));
            }
            damage = (float)AttributesMod.applyAttributeModifiers(damage, (Signed[])attributes.toArray(Signed[]::new));
        }
        return damage;
    }

    @WrapOperation(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F")})
    private float wrapOperationAtApplyArmorToDamage(LivingEntity entity, float damage, DamageSource source, float armor, float toughness, Operation<Float> operation) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            armor = Math.max(0.0f, (float)AttributesMod.applyAttributeModifiers(armor, Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.ARMOR_SHRED))));
            toughness = Math.max(0.0f, (float)AttributesMod.applyAttributeModifiers(toughness, Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.TOUGHNESS_SHRED))));
        }
        return ((Float)operation.call(new Object[]{entity, Float.valueOf(damage), source, Float.valueOf(armor), Float.valueOf(toughness)})).floatValue();
    }

    @WrapOperation(method={"getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterMagicAbsorb(FF)F")})
    private float wrapOperationAtModifyAppliedDamage(float damageDealt, float protection, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            protection = Math.max(0.0f, (float)AttributesMod.applyAttributeModifiers(protection, Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.PROTECTION_SHRED))));
        }
        return ((Float)original.call(new Object[]{Float.valueOf(damageDealt), Float.valueOf(protection)})).floatValue();
    }

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            amount = (float)AttributesMod.applyAttributeModifiers(amount, Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.HEALING)));
        }
        return amount;
    }

    @ModifyReturnValue(method={"getJumpPower()F"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return (float)AttributesMod.applyAttributeModifiers(jump, Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.JUMP)));
        }
        return jump;
    }

    @ModifyVariable(method={"calculateFallDamage(FF)I"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            reduction += ((float)AttributesMod.applyAttributeModifiers(1.0, Sign.POSITIVE.wrap(player.getAttribute(AttributesMod.JUMP))) - 1.0f) * 10.0f;
        }
        return reduction;
    }

    @ModifyReturnValue(method={"getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="TAIL")})
    private float injectAtModifyAppliedDamage(float damage, @Local(argsOnly=true) DamageSource source) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (damage < 1.1342745E38f) {
                ArrayList<Signed<AttributeInstance>> attributes = new ArrayList<Signed<AttributeInstance>>();
                attributes.add(Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.RESISTANCE)));
                DamageKind kind = DamageKind.of(source);
                if (kind.isMagic()) {
                    attributes.add(Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.MAGIC_RESISTANCE)));
                }
                if (kind.isProjectile()) {
                    attributes.add(Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.RANGED_RESISTANCE)));
                }
                if (kind.isMelee()) {
                    attributes.add(Sign.NEGATIVE.wrap(player.getAttribute(AttributesMod.MELEE_RESISTANCE)));
                }
                return Math.max(0.0f, (float)AttributesMod.applyAttributeModifiers(damage, (Signed[])attributes.toArray(Signed[]::new)));
            }
        }
        return damage;
    }
}

