/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.puffish.attributesmod.attribute.DynamicEntityAttribute;
import net.puffish.attributesmod.mixin.EntityAttributeInstanceInvoker;
import net.puffish.attributesmod.util.Platform;
import net.puffish.attributesmod.util.Signed;

public class AttributesMod {
    public static final String MOD_ID = "puffish_attributes";
    public static final ResourceLocation STAMINA_ID = AttributesMod.createAttributeIdentifier("player", "stamina");
    public static final Holder<Attribute> STAMINA = AttributesMod.registerAttribute(STAMINA_ID, AttributesMod.createClampedAttribute(STAMINA_ID, 4.0, 0.0, 1024.0).setSyncable(true));
    public static final ResourceLocation MAGIC_DAMAGE_ID = AttributesMod.createAttributeIdentifier("player", "magic_damage");
    public static final Holder<Attribute> MAGIC_DAMAGE = AttributesMod.registerAttribute(MAGIC_DAMAGE_ID, AttributesMod.createDynamicAttribute(MAGIC_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation MELEE_DAMAGE_ID = AttributesMod.createAttributeIdentifier("player", "melee_damage");
    public static final Holder<Attribute> MELEE_DAMAGE = AttributesMod.registerAttribute(MELEE_DAMAGE_ID, AttributesMod.createDynamicAttribute(MELEE_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation RANGED_DAMAGE_ID = AttributesMod.createAttributeIdentifier("player", "ranged_damage");
    public static final Holder<Attribute> RANGED_DAMAGE = AttributesMod.registerAttribute(RANGED_DAMAGE_ID, AttributesMod.createDynamicAttribute(RANGED_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation FORTUNE_ID = AttributesMod.createAttributeIdentifier("player", "fortune");
    public static final Holder<Attribute> FORTUNE = AttributesMod.registerAttribute(FORTUNE_ID, AttributesMod.createDynamicAttribute(FORTUNE_ID).setSyncable(true));
    public static final ResourceLocation HEALING_ID = AttributesMod.createAttributeIdentifier("player", "healing");
    public static final Holder<Attribute> HEALING = AttributesMod.registerAttribute(HEALING_ID, AttributesMod.createDynamicAttribute(HEALING_ID).setSyncable(true));
    public static final ResourceLocation JUMP_ID = AttributesMod.createAttributeIdentifier("player", "jump");
    public static final Holder<Attribute> JUMP = AttributesMod.registerAttribute(JUMP_ID, AttributesMod.createDynamicAttribute(JUMP_ID).setSyncable(true));
    public static final ResourceLocation RESISTANCE_ID = AttributesMod.createAttributeIdentifier("player", "resistance");
    public static final Holder<Attribute> RESISTANCE = AttributesMod.registerAttribute(RESISTANCE_ID, AttributesMod.createDynamicAttribute(RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MAGIC_RESISTANCE_ID = AttributesMod.createAttributeIdentifier("player", "magic_resistance");
    public static final Holder<Attribute> MAGIC_RESISTANCE = AttributesMod.registerAttribute(MAGIC_RESISTANCE_ID, AttributesMod.createDynamicAttribute(MAGIC_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MELEE_RESISTANCE_ID = AttributesMod.createAttributeIdentifier("player", "melee_resistance");
    public static final Holder<Attribute> MELEE_RESISTANCE = AttributesMod.registerAttribute(MELEE_RESISTANCE_ID, AttributesMod.createDynamicAttribute(MELEE_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation RANGED_RESISTANCE_ID = AttributesMod.createAttributeIdentifier("player", "ranged_resistance");
    public static final Holder<Attribute> RANGED_RESISTANCE = AttributesMod.registerAttribute(RANGED_RESISTANCE_ID, AttributesMod.createDynamicAttribute(RANGED_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MINING_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "mining_speed");
    public static final Holder<Attribute> MINING_SPEED = AttributesMod.registerAttribute(MINING_SPEED_ID, AttributesMod.createDynamicAttribute(MINING_SPEED_ID).setSyncable(true));
    public static final ResourceLocation PICKAXE_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "pickaxe_speed");
    public static final Holder<Attribute> PICKAXE_SPEED = AttributesMod.registerAttribute(PICKAXE_SPEED_ID, AttributesMod.createDynamicAttribute(PICKAXE_SPEED_ID).setSyncable(true));
    public static final ResourceLocation AXE_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "axe_speed");
    public static final Holder<Attribute> AXE_SPEED = AttributesMod.registerAttribute(AXE_SPEED_ID, AttributesMod.createDynamicAttribute(AXE_SPEED_ID).setSyncable(true));
    public static final ResourceLocation SHOVEL_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "shovel_speed");
    public static final Holder<Attribute> SHOVEL_SPEED = AttributesMod.registerAttribute(SHOVEL_SPEED_ID, AttributesMod.createDynamicAttribute(SHOVEL_SPEED_ID).setSyncable(true));
    public static final ResourceLocation SPRINTING_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "sprinting_speed");
    public static final Holder<Attribute> SPRINTING_SPEED = AttributesMod.registerAttribute(SPRINTING_SPEED_ID, AttributesMod.createDynamicAttribute(SPRINTING_SPEED_ID).setSyncable(true));
    public static final ResourceLocation KNOCKBACK_ID = AttributesMod.createAttributeIdentifier("player", "knockback");
    public static final Holder<Attribute> KNOCKBACK = AttributesMod.registerAttribute(KNOCKBACK_ID, AttributesMod.createDynamicAttribute(KNOCKBACK_ID).setSyncable(true));
    public static final ResourceLocation REPAIR_COST_ID = AttributesMod.createAttributeIdentifier("player", "repair_cost");
    public static final Holder<Attribute> REPAIR_COST = AttributesMod.registerAttribute(REPAIR_COST_ID, AttributesMod.createDynamicAttribute(REPAIR_COST_ID).setSyncable(true));
    public static final ResourceLocation ARMOR_SHRED_ID = AttributesMod.createAttributeIdentifier("player", "armor_shred");
    public static final Holder<Attribute> ARMOR_SHRED = AttributesMod.registerAttribute(ARMOR_SHRED_ID, AttributesMod.createDynamicAttribute(ARMOR_SHRED_ID).setSyncable(true));
    public static final ResourceLocation TOUGHNESS_SHRED_ID = AttributesMod.createAttributeIdentifier("player", "toughness_shred");
    public static final Holder<Attribute> TOUGHNESS_SHRED = AttributesMod.registerAttribute(TOUGHNESS_SHRED_ID, AttributesMod.createDynamicAttribute(TOUGHNESS_SHRED_ID).setSyncable(true));
    public static final ResourceLocation PROTECTION_SHRED_ID = AttributesMod.createAttributeIdentifier("player", "protection_shred");
    public static final Holder<Attribute> PROTECTION_SHRED = AttributesMod.registerAttribute(PROTECTION_SHRED_ID, AttributesMod.createDynamicAttribute(PROTECTION_SHRED_ID).setSyncable(true));
    public static final ResourceLocation NATURAL_REGENERATION_ID = AttributesMod.createAttributeIdentifier("player", "natural_regeneration");
    public static final Holder<Attribute> NATURAL_REGENERATION = AttributesMod.registerAttribute(NATURAL_REGENERATION_ID, AttributesMod.createDynamicAttribute(NATURAL_REGENERATION_ID).setSyncable(true));

    public static void setup() {
    }

    public static ResourceLocation createIdentifier(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ResourceLocation createAttributeIdentifier(String type, String name) {
        return AttributesMod.createIdentifier(type + "." + name);
    }

    public static Attribute createClampedAttribute(ResourceLocation id, double fallback, double min, double max) {
        return new RangedAttribute(id.toLanguageKey("attribute"), fallback, min, max);
    }

    public static Attribute createDynamicAttribute(ResourceLocation id) {
        return new DynamicEntityAttribute(id.toLanguageKey("attribute"));
    }

    public static Holder<Attribute> registerAttribute(ResourceLocation id, Attribute attribute) {
        return Platform.INSTANCE.registerReference(BuiltInRegistries.ATTRIBUTE, id, attribute);
    }

    @SafeVarargs
    public static double applyAttributeModifiers(double initial, Signed<AttributeInstance> ... attributes) {
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block13: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_VALUE)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        initial += modifier.amount();
                        continue block13;
                    }
                    case NEGATIVE: {
                        initial -= modifier.amount();
                        continue block13;
                    }
                }
                throw new IllegalStateException();
            }
        }
        double result = initial;
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block15: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result += initial * modifier.amount();
                        continue block15;
                    }
                    case NEGATIVE: {
                        result -= initial * modifier.amount();
                        continue block15;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block17: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result *= 1.0 + modifier.amount();
                        continue block17;
                    }
                    case NEGATIVE: {
                        result *= 1.0 - modifier.amount();
                        continue block17;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            result = ((Attribute)signedAttribute.value().getAttribute().value()).sanitizeValue(result);
        }
        return result;
    }
}

