/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import vectorwing.farmersdelight.common.Configuration;

public class VillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (!((Boolean)Configuration.GENERATE_VILLAGE_COMPOST_HEAPS.get()).booleanValue()) {
            return;
        }
        Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "farmersdelight:village/houses/plains_compost_pile", 5);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "farmersdelight:village/houses/snowy_compost_pile", 3);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "farmersdelight:village/houses/savanna_compost_pile", 4);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "farmersdelight:village/houses/desert_compost_pile", 3);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "farmersdelight:village/houses/taiga_compost_pile", 4);
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }
}

