/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeWrapper;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipe
implements Recipe<CuttingBoardRecipeWrapper> {
    public static final int MAX_RESULTS = 4;
    private final String group;
    private final Ingredient input;
    private final Ingredient tool;
    private final NonNullList<ChanceResult> results;
    private final Optional<SoundEvent> soundEvent;

    public CuttingBoardRecipe(String group, Ingredient input, Ingredient tool, NonNullList<ChanceResult> results, Optional<SoundEvent> soundEvent) {
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public boolean matches(CuttingBoardRecipeWrapper input, Level level) {
        return this.input.test(input.item()) && this.tool.test(input.tool());
    }

    public ItemStack assemble(CuttingBoardRecipeWrapper inv, HolderLookup.Provider provider) {
        return ((ChanceResult)this.results.getFirst()).stack().copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public String getGroup() {
        return this.group;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ((ChanceResult)this.results.getFirst()).stack();
    }

    public List<ItemStack> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(RandomSource rand, int fortuneLevel) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.rollOutput(rand, fortuneLevel);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public Optional<SoundEvent> getSoundEvent() {
        return this.soundEvent;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.CUTTING.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.CUTTING.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CuttingBoardRecipe that = (CuttingBoardRecipe)o;
        if (!this.getGroup().equals(that.getGroup())) {
            return false;
        }
        if (!this.input.equals((Object)that.input)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResults().equals(that.getResults())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.getGroup() != null ? this.getGroup().hashCode() : 0;
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResults().hashCode();
        result = 31 * result + this.soundEvent.map(Object::hashCode).orElse(0);
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<CuttingBoardRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, CuttingBoardRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<CuttingBoardRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(CuttingBoardRecipe::getGroup), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").flatXmap(ingredients -> {
            if (ingredients.isEmpty()) {
                return DataResult.error(() -> "No ingredients for cutting recipe");
            }
            if (ingredients.size() > 1) {
                return DataResult.error(() -> "Too many ingredients for cutting recipe! Please define only one ingredient");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.add((Object)((Ingredient)ingredients.get(0)));
            return DataResult.success((Object)((Ingredient)ingredients.get(0)));
        }, ingredient -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.add(ingredient);
            return DataResult.success((Object)nonNullList);
        }).forGetter(cuttingBoardRecipe -> cuttingBoardRecipe.input), (App)Ingredient.CODEC.fieldOf("tool").forGetter(CuttingBoardRecipe::getTool), (App)Codec.list(ChanceResult.CODEC).fieldOf("result").flatXmap(chanceResults -> {
            if (chanceResults.size() > 4) {
                return DataResult.error(() -> "Too many results for cutting recipe! The maximum quantity of unique results is 4");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(CuttingBoardRecipe::getRollableResults), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("sound").forGetter(CuttingBoardRecipe::getSoundEvent)).apply((Applicative)inst, CuttingBoardRecipe::new));

        public static CuttingBoardRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Optional holder;
            String groupIn = buffer.readUtf(Short.MAX_VALUE);
            Ingredient inputItemIn = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient toolIn = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readVarInt();
            NonNullList resultsIn = NonNullList.withSize((int)i, (Object)ChanceResult.EMPTY);
            resultsIn.replaceAll(ignored -> ChanceResult.read(buffer));
            Optional<SoundEvent> soundEventIn = Optional.empty();
            if (buffer.readBoolean() && (holder = BuiltInRegistries.SOUND_EVENT.getHolder(buffer.readResourceKey(Registries.SOUND_EVENT))).isPresent() && ((Holder.Reference)holder.get()).isBound()) {
                soundEventIn = Optional.of((SoundEvent)((Holder.Reference)holder.get()).value());
            }
            return new CuttingBoardRecipe(groupIn, inputItemIn, toolIn, (NonNullList<ChanceResult>)resultsIn, soundEventIn);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, CuttingBoardRecipe recipe) {
            buffer.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tool);
            buffer.writeVarInt(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            if (recipe.getSoundEvent().isPresent()) {
                Optional resourceKey = BuiltInRegistries.SOUND_EVENT.getResourceKey((Object)recipe.getSoundEvent().get());
                resourceKey.ifPresentOrElse(rk -> {
                    buffer.writeBoolean(true);
                    buffer.writeResourceKey(rk);
                }, () -> buffer.writeBoolean(false));
            } else {
                buffer.writeBoolean(false);
            }
        }

        public MapCodec<CuttingBoardRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CuttingBoardRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

