/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SkilletBlockEntity
extends SyncedBlockEntity
implements HeatableBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private int cookingTime;
    private int cookingTimeTotal;
    private ItemStack skilletStack = ItemStack.EMPTY;
    private int fireAspectLevel;
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);

    public SkilletBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.SKILLET.get(), pos, state);
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, SkilletBlockEntity skillet) {
        boolean isHeated = skillet.isHeated(level, pos);
        if (((Boolean)state.getValue((Property)SkilletBlock.WATERLOGGED)).booleanValue()) {
            if (!ItemUtils.isInventoryEmpty((IItemHandler)skillet.inventory)) {
                ItemUtils.dropItems(level, pos, (IItemHandler)skillet.inventory);
                skillet.inventoryChanged();
            }
        } else if (isHeated) {
            ItemStack cookingStack = skillet.getStoredStack();
            if (cookingStack.isEmpty()) {
                skillet.cookingTime = 0;
            } else {
                skillet.cookAndOutputItems(cookingStack, level);
            }
        } else if (skillet.cookingTime > 0) {
            skillet.cookingTime = Mth.clamp((int)(skillet.cookingTime - 2), (int)0, (int)skillet.cookingTimeTotal);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, SkilletBlockEntity skillet) {
        if (skillet.isHeated(level, pos) && skillet.hasStoredStack()) {
            double z;
            double y;
            double x;
            RandomSource random = level.random;
            if (random.nextFloat() < 0.2f) {
                x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)pos.getY() + 0.1;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionY = random.nextBoolean() ? 0.015 : 0.005;
                level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
            if (skillet.fireAspectLevel > 0 && random.nextFloat() < (float)skillet.fireAspectLevel * 0.05f) {
                x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)pos.getY() + 0.1;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionX = level.random.nextFloat() - 0.5f;
                double motionY = level.random.nextFloat() * 0.5f + 0.2f;
                double motionZ = level.random.nextFloat() - 0.5f;
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, x, y, z, motionX, motionY, motionZ);
            }
        }
    }

    private void cookAndOutputItems(ItemStack cookingStack, Level level) {
        Optional<RecipeHolder<CampfireCookingRecipe>> recipe;
        ++this.cookingTime;
        if (this.cookingTime >= this.cookingTimeTotal && (recipe = this.getMatchingRecipe(cookingStack)).isPresent()) {
            ItemStack resultStack = ((CampfireCookingRecipe)recipe.get().value()).assemble(new SingleRecipeInput(cookingStack), (HolderLookup.Provider)level.registryAccess());
            Direction direction = ((Direction)this.getBlockState().getValue((Property)SkilletBlock.FACING)).getClockWise();
            ItemUtils.spawnItemEntity(level, resultStack.copy(), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.3, (double)this.worldPosition.getZ() + 0.5, (float)direction.getStepX() * 0.08f, 0.25, (float)direction.getStepZ() * 0.08f);
            this.cookingTime = 0;
            this.inventory.extractItem(0, 1, false);
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        if (this.level != null) {
            return this.isHeated(this.level, this.worldPosition);
        }
        return false;
    }

    private Optional<RecipeHolder<CampfireCookingRecipe>> getMatchingRecipe(ItemStack stack) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.cookingTime = compound.getInt("CookTime");
        this.cookingTimeTotal = compound.getInt("CookTimeTotal");
        this.skilletStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("Skillet"));
        this.fireAspectLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)registries.holder(Enchantments.FIRE_ASPECT).get()), (ItemStack)this.skilletStack);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("CookTime", this.cookingTime);
        compound.putInt("CookTimeTotal", this.cookingTimeTotal);
        compound.put("Skillet", this.skilletStack.save(registries));
    }

    public ItemStack getSkilletAsItem() {
        return this.skilletStack;
    }

    public void setSkilletItem(ItemStack stack) {
        this.skilletStack = stack.copy();
        this.fireAspectLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)this.level.registryAccess().holderOrThrow(Enchantments.FIRE_ASPECT), (ItemStack)stack);
        this.inventoryChanged();
    }

    public ItemStack addItemToCook(ItemStack addedStack, Player player) {
        Optional<RecipeHolder<CampfireCookingRecipe>> recipe = this.getMatchingRecipe(addedStack);
        if (recipe.isPresent() && this.getStoredStack().isEmpty()) {
            if (((Boolean)this.getBlockState().getValue((Property)SkilletBlock.WATERLOGGED)).booleanValue()) {
                player.displayClientMessage((Component)TextUtils.getTranslation("block.skillet.underwater", new Object[0]), true);
                return addedStack;
            }
            boolean wasEmpty = this.getStoredStack().isEmpty();
            ItemStack remainderStack = this.inventory.insertItem(0, addedStack.copy(), false);
            if (!ItemStack.matches((ItemStack)remainderStack, (ItemStack)addedStack)) {
                this.cookingTimeTotal = SkilletBlock.getSkilletCookingTime(((CampfireCookingRecipe)recipe.get().value()).getCookingTime(), this.fireAspectLevel);
                this.cookingTime = 0;
                if (wasEmpty && this.level != null && this.isHeated(this.level, this.worldPosition)) {
                    this.level.playSound(null, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return remainderStack;
            }
        } else {
            player.displayClientMessage((Component)TextUtils.getTranslation("block.skillet.invalid_item", new Object[0]), true);
        }
        return addedStack;
    }

    public ItemStack removeItem() {
        return this.inventory.extractItem(0, this.getStoredStack().getMaxStackSize(), false);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().isEmpty();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                SkilletBlockEntity.this.inventoryChanged();
            }
        };
    }

    public void setRemoved() {
        super.setRemoved();
    }
}

