/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.base;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.machines.base.AbstractPylonContainer;
import net.permutated.pylons.util.ResourceUtil;
import net.permutated.pylons.util.TextureHolder;
import net.permutated.pylons.util.TranslationKey;

public abstract class AbstractPylonScreen<T extends AbstractPylonContainer>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation gui;
    protected final boolean usesEnergy;
    protected Button workButton;
    protected Button rangeButton;

    protected AbstractPylonScreen(T container, Inventory inventory, Component title) {
        this(container, inventory, title, false);
    }

    protected AbstractPylonScreen(T container, Inventory inv, Component name, boolean usesEnergy) {
        super(container, inv, name);
        this.usesEnergy = ConfigManager.SERVER.harvesterRequiresPower.getAsBoolean();
        this.gui = usesEnergy ? ResourceUtil.gui("pylon_energy") : ResourceUtil.gui("pylon");
        this.imageWidth = 176;
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.workButton = Button.builder((Component)((AbstractPylonContainer)this.menu).getWorkComponent(), ((AbstractPylonContainer)this.menu)::sendWorkPacket).pos(this.leftPos + 142, this.height / 2 - 80).size(26, 20).tooltip(this.workButtonTooltip()).build();
        this.rangeButton = Button.builder((Component)((AbstractPylonContainer)this.menu).getRangeComponent(), ((AbstractPylonContainer)this.menu)::sendRangePacket).pos(this.leftPos + 116, this.height / 2 - 80).size(26, 20).tooltip(this.rangeButtonTooltip()).build();
        this.addRenderableWidget((GuiEventListener)this.workButton);
        if (((AbstractPylonContainer)this.menu).shouldRenderRange()) {
            this.addRenderableWidget((GuiEventListener)this.rangeButton);
        }
        this.updateMessages();
    }

    protected Tooltip workButtonTooltip() {
        return Tooltip.create((Component)this.translate("toggleWork"));
    }

    protected Tooltip rangeButtonTooltip() {
        return Tooltip.create((Component)this.translate("workArea"));
    }

    public void updateMessages() {
        this.workButton.setMessage(((AbstractPylonContainer)this.menu).getWorkComponent());
        this.rangeButton.setMessage(((AbstractPylonContainer)this.menu).getRangeComponent());
    }

    protected void containerTick() {
        this.updateMessages();
        super.containerTick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.gui, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        if (this.usesEnergy) {
            float energyFraction = ((AbstractPylonContainer)this.menu).dataHolder.getEnergyFraction();
            TextureHolder energyHolder = new TextureHolder(8, 54, 0, 172, 160, 16);
            graphics.blit(this.gui, relX + energyHolder.progressOffsetX(), relY + energyHolder.progressOffsetY(), energyHolder.textureOffsetX(), energyHolder.textureOffsetY(), energyHolder.getWidthFraction(energyFraction), energyHolder.textureHeight());
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        String owner = ((AbstractPylonContainer)this.menu).getOwnerName();
        MutableComponent component = owner.equals("unknown") ? this.translate("noOwner").withStyle(ChatFormatting.RED) : this.translate("owner", owner);
        this.drawText(graphics, (Component)component, 30);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.usesEnergy && this.isHovering(8, 54, 160, 16, x, y)) {
            guiGraphics.renderComponentTooltip(this.font, List.of(this.translate("fluxBar"), this.translate("fluxData", ((AbstractPylonContainer)this.menu).dataHolder.getEnergy(), ((AbstractPylonContainer)this.menu).dataHolder.getMaxEnergy())), x, y);
        }
    }

    protected void drawText(GuiGraphics graphics, Component component, int yPos) {
        graphics.drawString(this.font, component, 8, yPos, 0x404040, false);
    }

    protected MutableComponent translate(String key) {
        return Component.translatable((String)TranslationKey.gui(key));
    }

    protected MutableComponent translate(String key, Object ... values) {
        return Component.translatable((String)TranslationKey.gui(key), (Object[])values);
    }
}

