/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.compat.harvest.HarvestCompat;
import net.permutated.pylons.compat.teams.TeamCompat;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonBlock;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.network.PacketButtonClicked;
import net.permutated.pylons.util.ChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pylons")
public class Pylons {
    public static final String MODID = "pylons";
    public static final Logger LOGGER = LogManager.getLogger();

    public Pylons(IEventBus modEventBus) {
        LOGGER.info("Registering mod: {}", (Object)MODID);
        ModRegistry.register(modEventBus);
        TeamCompat.init();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigManager.SERVER_SPEC);
        modEventBus.addListener(this::onCommonSetupEvent);
        modEventBus.addListener(this::onRegisterPayloadHandlersEvent);
        modEventBus.addListener(this::onRegisterCapabilitiesEvent);
        modEventBus.addListener(ChunkManager::onRegisterTicketControllersEvent);
        NeoForge.EVENT_BUS.addListener(PlayerFilterCard::onPlayerInteractEvent);
        NeoForge.EVENT_BUS.addListener(MobFilterCard::onPlayerInteractEvent);
        NeoForge.EVENT_BUS.addListener(Pylons::onBlockBreakEvent);
    }

    public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        event.enqueueWork(HarvestCompat::init);
    }

    public void onRegisterPayloadHandlersEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToServer(PacketButtonClicked.TYPE, PacketButtonClicked.STREAM_CODEC, PacketButtonClicked::handle);
    }

    public void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        AbstractPylonTile.registerCapabilities(event, ModRegistry.HARVESTER_PYLON_TILE.get());
    }

    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        BlockEntity tileEntity;
        if (event.getState().getBlock() instanceof AbstractPylonBlock && !AbstractPylonBlock.canAccessPylon(tileEntity = event.getLevel().getBlockEntity(event.getPos()), event.getPlayer())) {
            event.setCanceled(true);
        }
    }
}

