/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.permutated.pylons.components.EntityComponent;
import net.permutated.pylons.components.PlayerComponent;
import net.permutated.pylons.components.PotionComponent;
import net.permutated.pylons.item.LifelessFilterCard;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonBlock;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonContainer;
import net.permutated.pylons.machines.expulsion.ExpulsionPylonTile;
import net.permutated.pylons.machines.harvester.HarvesterPylonBlock;
import net.permutated.pylons.machines.harvester.HarvesterPylonContainer;
import net.permutated.pylons.machines.harvester.HarvesterPylonTile;
import net.permutated.pylons.machines.infusion.InfusionPylonBlock;
import net.permutated.pylons.machines.infusion.InfusionPylonContainer;
import net.permutated.pylons.machines.infusion.InfusionPylonTile;
import net.permutated.pylons.machines.interdiction.InterdictionPylonBlock;
import net.permutated.pylons.machines.interdiction.InterdictionPylonContainer;
import net.permutated.pylons.machines.interdiction.InterdictionPylonTile;
import net.permutated.pylons.recipe.HarvestingRecipe;
import net.permutated.pylons.recipe.HarvestingRegistry;
import net.permutated.pylons.util.ResourceUtil;
import net.permutated.pylons.util.TranslationKey;

public class ModRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"pylons");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"pylons");
    public static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((String)"pylons");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"pylons");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"pylons");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"pylons");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"pylons");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"pylons");
    public static final HarvestingRegistry HARVESTING_REGISTRY = new HarvestingRegistry();
    public static final Supplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)TranslationKey.tab())).icon(() -> PLAYER_FILTER.get().getDefaultInstance()).displayItems((parameters, output) -> ITEMS.getEntries().stream().map(Supplier::get).map(Item::getDefaultInstance).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static final Supplier<Item> PLAYER_FILTER = ITEMS.register("player_filter", PlayerFilterCard::new);
    public static final Supplier<Item> POTION_FILTER = ITEMS.register("potion_filter", PotionFilterCard::new);
    public static final Supplier<Item> MOB_FILTER = ITEMS.register("mob_filter", MobFilterCard::new);
    public static final Supplier<Item> LIFELESS_FILTER = ITEMS.register("lifeless_filter", LifelessFilterCard::new);
    public static final Supplier<DataComponentType<PlayerComponent>> PLAYER_COMPONENT = COMPONENTS.registerComponentType("player", builder -> builder.persistent(PlayerComponent.BASIC_CODEC));
    public static final Supplier<DataComponentType<PotionComponent>> POTION_COMPONENT = COMPONENTS.registerComponentType("potion", builder -> builder.persistent(PotionComponent.BASIC_CODEC));
    public static final Supplier<DataComponentType<EntityComponent>> ENTITY_COMPONENT = COMPONENTS.registerComponentType("entity", builder -> builder.persistent(EntityComponent.BASIC_CODEC));
    public static final DeferredBlock<Block> EXPULSION_PYLON = BLOCKS.register("expulsion_pylon", ExpulsionPylonBlock::new);
    public static final DeferredBlock<Block> INFUSION_PYLON = BLOCKS.register("infusion_pylon", InfusionPylonBlock::new);
    public static final DeferredBlock<Block> HARVESTER_PYLON = BLOCKS.register("harvester_pylon", HarvesterPylonBlock::new);
    public static final DeferredBlock<Block> INTERDICTION_PYLON = BLOCKS.register("interdiction_pylon", InterdictionPylonBlock::new);
    public static final Supplier<BlockItem> EXPULSION_PYLON_ITEM = ModRegistry.blockItem(EXPULSION_PYLON);
    public static final Supplier<BlockItem> INFUSION_PYLON_ITEM = ModRegistry.blockItem(INFUSION_PYLON);
    public static final Supplier<BlockItem> HARVESTER_PYLON_ITEM = ModRegistry.blockItem(HARVESTER_PYLON);
    public static final Supplier<BlockItem> INTERDICTION_PYLON_ITEM = ModRegistry.blockItem(INTERDICTION_PYLON);
    public static final Supplier<BlockEntityType<ExpulsionPylonTile>> EXPULSION_PYLON_TILE = ModRegistry.blockEntity(EXPULSION_PYLON, ExpulsionPylonTile::new);
    public static final Supplier<BlockEntityType<InfusionPylonTile>> INFUSION_PYLON_TILE = ModRegistry.blockEntity(INFUSION_PYLON, InfusionPylonTile::new);
    public static final Supplier<BlockEntityType<HarvesterPylonTile>> HARVESTER_PYLON_TILE = ModRegistry.blockEntity(HARVESTER_PYLON, HarvesterPylonTile::new);
    public static final Supplier<BlockEntityType<InterdictionPylonTile>> INTERDICTION_PYLON_TILE = ModRegistry.blockEntity(INTERDICTION_PYLON, InterdictionPylonTile::new);
    public static final Supplier<MenuType<ExpulsionPylonContainer>> EXPULSION_PYLON_CONTAINER = ModRegistry.container("expulsion_pylon", ExpulsionPylonContainer::new);
    public static final Supplier<MenuType<InfusionPylonContainer>> INFUSION_PYLON_CONTAINER = ModRegistry.container("infusion_pylon", InfusionPylonContainer::new);
    public static final Supplier<MenuType<HarvesterPylonContainer>> HARVESTER_PYLON_CONTAINER = ModRegistry.container("harvester_pylon", HarvesterPylonContainer::new);
    public static final Supplier<MenuType<InterdictionPylonContainer>> INTERDICTION_PYLON_CONTAINER = ModRegistry.container("interdiction_pylon", InterdictionPylonContainer::new);
    public static final Supplier<RecipeType<HarvestingRecipe>> HARVESTING_RECIPE_TYPE = RECIPE_TYPES.register("harvesting", () -> RecipeType.simple((ResourceLocation)ResourceUtil.prefix("harvesting")));
    public static final Supplier<HarvestingRecipe.Serializer> HARVESTING_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("harvesting", HarvestingRecipe.Serializer::new);
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static DeferredItem<BlockItem> blockItem(Holder<Block> holder) {
        return ITEMS.register(holder.unwrapKey().map(ResourceKey::location).map(ResourceLocation::getPath).orElseThrow(), () -> new BlockItem((Block)holder.value(), new Item.Properties()));
    }

    private static DeferredItem<Item> material(String path) {
        return ITEMS.register(path, () -> new Item(new Item.Properties()));
    }

    private static <T extends AbstractPylonTile> Supplier<BlockEntityType<T>> blockEntity(Holder<Block> holder, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return TILES.register(holder.unwrapKey().map(ResourceKey::location).map(ResourceLocation::getPath).orElseThrow(), () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)holder.value()}).build(EMPTY_PART));
    }

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IMenuTypeExtension.create((IContainerFactory)supplier));
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        COMPONENTS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
        CREATIVE_TABS.register(bus);
        RECIPE_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }
}

