/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block_network;

import com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoulNetwork
extends Network {
    public static ResourceLocation SOUL_NETWORK = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoingsouls", (String)"soul");
    private List<NetworkElement> queueNetworkElements = new ArrayList<NetworkElement>();
    private List<NetworkElement> soulLaserDrills = new ArrayList<NetworkElement>();

    public SoulNetwork(BlockPos originPos, String id) {
        super(originPos, id);
    }

    public void addElement(NetworkElement element) {
        this.queueNetworkElements.add(element);
    }

    public void removeElement(NetworkElement element) {
        BlockEntity tile = element.getLevel().getBlockEntity(element.getPos());
        if (tile instanceof SoulLaserBaseBlockEntity) {
            this.soulLaserDrills.remove(element);
        }
    }

    public void update(Level level) {
        super.update(level);
        for (NetworkElement element : this.queueNetworkElements) {
            BlockEntity tile = element.getLevel().getBlockEntity(element.getPos());
            if (!(tile instanceof SoulLaserBaseBlockEntity)) continue;
            this.soulLaserDrills.add(element);
        }
        this.queueNetworkElements.clear();
    }

    public void onMergedWith(Network mainNetwork) {
        if (mainNetwork instanceof SoulNetwork) {
            SoulNetwork soulNetwork = (SoulNetwork)mainNetwork;
        }
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        CompoundTag nbt = super.writeToNbt(tag);
        return nbt;
    }

    public ResourceLocation getType() {
        return SOUL_NETWORK;
    }

    public List<NetworkElement> getSoulLaserDrills() {
        return this.soulLaserDrills;
    }

    public static class Factory
    implements NetworkFactory {
        private static final Logger LOGGER = LogManager.getLogger(Factory.class);

        public Network create(BlockPos pos) {
            return new SoulNetwork(pos, NetworkFactory.randomString((Random)new Random(), (int)8));
        }

        public Network create(CompoundTag tag) {
            SoulNetwork network = new SoulNetwork(BlockPos.of((long)tag.getLong("origin")), tag.getString("id"));
            LOGGER.debug("Deserialized matter network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
            return network;
        }
    }
}

