/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block.tile;

import com.buuz135.industrialforegoingsouls.block_network.DefaultSoulNetworkElement;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class NetworkBlockEntity<T extends ActiveTile<T>>
extends ActiveTile<T>
implements ITickableBlockEntity<T> {
    private boolean unloaded;

    public NetworkBlockEntity(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
    }

    public void clearRemoved() {
        super.clearRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().submitAsync(() -> {
                NetworkManager networkManager = NetworkManager.get((Level)this.level);
                if (networkManager.getElement(this.worldPosition) == null) {
                    networkManager.addElement(this.createElement(this.level, this.worldPosition));
                }
            });
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        NetworkManager networkManager;
        NetworkElement pipe;
        super.setRemoved();
        if (!this.level.isClientSide && !this.unloaded && (pipe = (networkManager = NetworkManager.get((Level)this.level)).getElement(this.worldPosition)) != null) {
            networkManager.removeElement(this.worldPosition);
        }
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        return new DefaultSoulNetworkElement(level, pos);
    }

    public SoulNetwork getNetwork() {
        return (SoulNetwork)NetworkManager.get((Level)this.level).getElement(this.worldPosition).getNetwork();
    }
}

