/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block;

import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.block.SoulPipeBlock;
import com.buuz135.industrialforegoingsouls.block.tile.SoulSurgeBlockEntity;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoulSurgeBlock
extends BasicTileBlock<SoulSurgeBlockEntity>
implements INetworkDirectionalConnection,
SimpleWaterloggedBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.create((String)"enabled");
    public static final BooleanProperty TOP_CONN = BooleanProperty.create((String)"top");
    public static final BooleanProperty UP_CONN = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN_CONN = BooleanProperty.create((String)"down");
    public static final BooleanProperty EAST_CONN = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST_CONN = BooleanProperty.create((String)"west");
    public static VoxelShape NORTH = Stream.of(Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)11.0), Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0, (double)10.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)5.0), Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape EAST = Stream.of(Block.box((double)5.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), Block.box((double)6.0, (double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0), Block.box((double)11.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.box((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), Block.box((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape SOUTH = Stream.of(Block.box((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0, (double)14.0), Block.box((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape WEST = Stream.of(Block.box((double)2.0, (double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0), Block.box((double)3.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), Block.box((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.box((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape UP = Stream.of(Block.box((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape DOWN = Stream.of(Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLL_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();

    public SoulSurgeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).forceSolidOn(), SoulSurgeBlockEntity.class);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true))).setValue((Property)TOP_CONN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
        if (direction == Direction.UP) {
            return UP;
        }
        if (direction == Direction.DOWN) {
            return DOWN;
        }
        if (direction == Direction.EAST) {
            return EAST;
        }
        if (direction == Direction.WEST) {
            return WEST;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH;
        }
        return NORTH;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
        if (direction == Direction.UP) {
            return UP;
        }
        if (direction == Direction.DOWN) {
            return DOWN;
        }
        if (direction == Direction.EAST) {
            return EAST;
        }
        if (direction == Direction.WEST) {
            return WEST;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH;
        }
        return NORTH;
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new SoulSurgeBlockEntity(this, (BlockEntityType<?>)((BlockEntityType)IndustrialForegoingSouls.SOUL_SURGE_BLOCK.type().get()), pos, state);
    }

    public boolean canConnect(BlockState state, Direction direction) {
        Direction pointing = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
        if (pointing.getAxis().isVertical()) {
            if (direction == Direction.EAST) {
                return (Boolean)state.getValue((Property)EAST_CONN);
            }
            if (direction == Direction.WEST) {
                return (Boolean)state.getValue((Property)WEST_CONN);
            }
            if (direction == Direction.NORTH) {
                return (Boolean)state.getValue((Property)DOWN_CONN);
            }
            if (direction == Direction.SOUTH) {
                return (Boolean)state.getValue((Property)UP_CONN);
            }
        } else {
            FacingUtil.Sideness sideness = FacingUtil.getFacingRelative((Direction)pointing, (Direction)direction);
            if (sideness == FacingUtil.Sideness.LEFT) {
                return (Boolean)state.getValue((Property)EAST_CONN);
            }
            if (sideness == FacingUtil.Sideness.RIGHT) {
                return (Boolean)state.getValue((Property)WEST_CONN);
            }
            if (sideness == FacingUtil.Sideness.BOTTOM) {
                return (Boolean)state.getValue((Property)DOWN_CONN);
            }
            if (sideness == FacingUtil.Sideness.TOP) {
                return (Boolean)state.getValue((Property)UP_CONN);
            }
        }
        return state.getValue((Property)RotatableBlock.FACING_ALL) == direction;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState pipeBlockstate = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace()));
        boolean pipeConnection = pipeBlockstate.getBlock() instanceof SoulPipeBlock || pipeBlockstate.getBlock().equals(IndustrialForegoingSouls.SOUL_SURGE_BLOCK.block().get());
        boolean eastConnection = this.checkSurgeConnection(Direction.EAST, FacingUtil.Sideness.LEFT, context.getClickedFace(), context.getLevel(), context.getClickedPos());
        boolean westConnection = this.checkSurgeConnection(Direction.WEST, FacingUtil.Sideness.RIGHT, context.getClickedFace(), context.getLevel(), context.getClickedPos());
        boolean upConnection = this.checkSurgeConnection(Direction.SOUTH, FacingUtil.Sideness.TOP, context.getClickedFace(), context.getLevel(), context.getClickedPos());
        boolean downConnection = this.checkSurgeConnection(Direction.NORTH, FacingUtil.Sideness.BOTTOM, context.getClickedFace(), context.getLevel(), context.getClickedPos());
        BlockState state = this.defaultBlockState();
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        if (fluid.is(FluidTags.WATER) && fluid.getAmount() == 8) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)RotatableBlock.FACING_ALL, (Comparable)context.getClickedFace())).setValue((Property)TOP_CONN, (Comparable)Boolean.valueOf(pipeConnection))).setValue((Property)EAST_CONN, (Comparable)Boolean.valueOf(eastConnection))).setValue((Property)WEST_CONN, (Comparable)Boolean.valueOf(westConnection))).setValue((Property)UP_CONN, (Comparable)Boolean.valueOf(upConnection))).setValue((Property)DOWN_CONN, (Comparable)Boolean.valueOf(downConnection))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())) == false));
    }

    private boolean checkSurgeConnection(Direction direction, FacingUtil.Sideness sideness, Direction clickedFace, Level level, BlockPos clickedPos) {
        BlockState relativeBlockstate = level.getBlockState(clickedPos.relative(clickedFace.getAxis().isVertical() ? direction : FacingUtil.getFacingFromSide((Direction)clickedFace, (FacingUtil.Sideness)sideness)));
        return relativeBlockstate.getBlock() instanceof SoulPipeBlock || relativeBlockstate.getBlock().equals(IndustrialForegoingSouls.SOUL_SURGE_BLOCK.block().get());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, p_220069_6_);
        if (!level.isClientSide) {
            boolean hasSignal;
            boolean flag;
            Direction facing = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
            boolean needStateRefresh = false;
            Boolean originalPipeConnection = (Boolean)state.getValue((Property)TOP_CONN);
            BlockState pipeBlockstate = level.getBlockState(pos.relative(facing));
            boolean pipeConnection = pipeBlockstate.getBlock() instanceof SoulPipeBlock || pipeBlockstate.getBlock().equals(IndustrialForegoingSouls.SOUL_SURGE_BLOCK.block().get());
            state = (BlockState)state.setValue((Property)TOP_CONN, (Comparable)Boolean.valueOf(pipeConnection));
            if (originalPipeConnection != pipeConnection) {
                needStateRefresh = true;
            }
            boolean eastConnection = this.checkSurgeConnection(Direction.EAST, FacingUtil.Sideness.LEFT, facing, level, pos);
            Boolean originalConnection = (Boolean)state.getValue((Property)EAST_CONN);
            state = (BlockState)state.setValue((Property)EAST_CONN, (Comparable)Boolean.valueOf(eastConnection));
            if (eastConnection != originalConnection) {
                needStateRefresh = true;
            }
            boolean westConnection = this.checkSurgeConnection(Direction.WEST, FacingUtil.Sideness.RIGHT, facing, level, pos);
            originalConnection = (Boolean)state.getValue((Property)WEST_CONN);
            state = (BlockState)state.setValue((Property)WEST_CONN, (Comparable)Boolean.valueOf(westConnection));
            if (westConnection != originalConnection) {
                needStateRefresh = true;
            }
            boolean upConnection = this.checkSurgeConnection(Direction.SOUTH, FacingUtil.Sideness.TOP, facing, level, pos);
            originalConnection = (Boolean)state.getValue((Property)UP_CONN);
            state = (BlockState)state.setValue((Property)UP_CONN, (Comparable)Boolean.valueOf(upConnection));
            if (upConnection != originalConnection) {
                needStateRefresh = true;
            }
            boolean downConnection = this.checkSurgeConnection(Direction.NORTH, FacingUtil.Sideness.BOTTOM, facing, level, pos);
            originalConnection = (Boolean)state.getValue((Property)DOWN_CONN);
            state = (BlockState)state.setValue((Property)DOWN_CONN, (Comparable)Boolean.valueOf(downConnection));
            if (downConnection != originalConnection) {
                needStateRefresh = true;
            }
            if (needStateRefresh) {
                level.setBlock(pos, state, 2);
            }
            if ((flag = ((Boolean)state.getValue((Property)ENABLED)).booleanValue()) == (hasSignal = level.hasNeighborSignal(pos))) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(!hasSignal)), 2);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        if (RotatableBlock.RotationType.SIX_WAY.getProperties() != null) {
            stateBuilder.add((Property[])RotatableBlock.RotationType.SIX_WAY.getProperties());
        }
        stateBuilder.add(new Property[]{ENABLED});
        stateBuilder.add(new Property[]{TOP_CONN});
        stateBuilder.add(new Property[]{UP_CONN});
        stateBuilder.add(new Property[]{DOWN_CONN});
        stateBuilder.add(new Property[]{EAST_CONN});
        stateBuilder.add(new Property[]{WEST_CONN});
        stateBuilder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState p_56969_) {
        return (Boolean)p_56969_.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_56969_);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (RotatableBlock.RotationType.SIX_WAY.getProperties().length > 0) {
            return (BlockState)state.setValue((Property)RotatableBlock.RotationType.SIX_WAY.getProperties()[0], (Comparable)rot.rotate((Direction)state.getValue((Property)RotatableBlock.RotationType.SIX_WAY.getProperties()[0])));
        }
        return super.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (RotatableBlock.RotationType.SIX_WAY.getProperties().length > 0) {
            return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)RotatableBlock.RotationType.SIX_WAY.getProperties()[0])));
        }
        return super.mirror(state, mirrorIn);
    }
}

