/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block;

import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.block.SoulSurgeBlock;
import com.buuz135.industrialforegoingsouls.block.tile.SoulPipeBlockEntity;
import com.buuz135.industrialforegoingsouls.config.IFSoulsClient;
import com.google.common.collect.ImmutableMap;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class SoulPipeBlock
extends BasicTileBlock<SoulPipeBlockEntity>
implements INetworkDirectionalConnection,
SimpleWaterloggedBlock {
    public static final Map<Direction, EnumProperty<PipeState>> DIRECTIONS = new HashMap<Direction, EnumProperty<PipeState>>();
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)Block.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)Block.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLL_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public SoulPipeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).forceSolidOn(), SoulPipeBlockEntity.class);
        this.setItemGroup(IndustrialForegoingSouls.TAB);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new SoulPipeBlockEntity(this, (BlockEntityType<?>)((BlockEntityType)IndustrialForegoingSouls.SOUL_PIPE_BLOCK.type().get()), pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])DIRECTIONS.values().toArray(Property[]::new));
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private BlockState createState(Level world, BlockPos pos, BlockState curr) {
        BlockState state = this.defaultBlockState();
        FluidState fluid = world.getFluidState(pos);
        if (fluid.is(FluidTags.WATER) && fluid.getAmount() == 8) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            EnumProperty<PipeState> prop = DIRECTIONS.get(dir);
            PipeState type = this.getConnectionType(world, pos, dir, state);
            state = (BlockState)state.setValue(prop, (Comparable)((Object)type));
        }
        return state;
    }

    protected PipeState getConnectionType(Level world, BlockPos pos, Direction direction, BlockState state) {
        INetworkDirectionalConnection networkDirectionalConnection;
        BlockState relativeState = world.getBlockState(pos.relative(direction));
        if (relativeState.getBlock() instanceof SoulPipeBlock || relativeState.getBlock() instanceof SoulSurgeBlock || relativeState.getBlock().equals(Blocks.STONE_BRICKS)) {
            return PipeState.PIPE;
        }
        Block block = relativeState.getBlock();
        if (block instanceof INetworkDirectionalConnection && (networkDirectionalConnection = (INetworkDirectionalConnection)block).canConnect(relativeState, direction.getOpposite())) {
            return PipeState.BLOCK;
        }
        return PipeState.NO;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.createState(context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        NetworkElement pipe;
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.setBlockAndUpdate(pos, newState);
        }
        if (!worldIn.isClientSide && (pipe = NetworkManager.get((Level)worldIn).getElement(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(worldIn, pos);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getShape(worldIn, pos, context), SHAPE_CACHE, null);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getCollisionShape(worldIn, pos, context), COLL_SHAPE_CACHE, s -> {
            MutableObject newShape = new MutableObject((Object)Shapes.empty());
            s.forAllBoxes((x1, y1, z1, x2, y2, z2) -> newShape.setValue((Object)Shapes.join((VoxelShape)Shapes.create((double)x1, (double)y1, (double)z1, (double)x2, (double)(y2 + 0.1875), (double)z2), (VoxelShape)((VoxelShape)newShape.getValue()), (BooleanOp)BooleanOp.OR)));
            return ((VoxelShape)newShape.getValue()).optimize();
        });
    }

    private VoxelShape cacheAndGetShape(BlockState state, BlockGetter worldIn, BlockPos pos, Function<BlockState, VoxelShape> coverShapeSelector, Map<BlockState, VoxelShape> cache, Function<VoxelShape, VoxelShape> shapeModifier) {
        VoxelShape shape = cache.get(state);
        if (shape == null) {
            shape = CENTER_SHAPE;
            for (Map.Entry<Direction, EnumProperty<PipeState>> entry : DIRECTIONS.entrySet()) {
                if (state.getValue((Property)entry.getValue()) == PipeState.NO) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
            }
            if (shapeModifier != null) {
                shape = shapeModifier.apply(shape);
            }
            cache.put(state, shape);
        }
        return shape;
    }

    public boolean canConnect(BlockState state, Direction direction) {
        return true;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.values()) {
            boolean opositteConnected;
            boolean connected = state.getValue((Property)DIRECTIONS.get(direction)) != PipeState.NO;
            boolean bl = opositteConnected = state.getValue((Property)DIRECTIONS.get(direction.getOpposite())) != PipeState.NO;
            if (!(random.nextDouble() <= IFSoulsClient.SOUL_PIPES_PARTICLES) || !connected || !opositteConnected) continue;
            Vec3i vector = direction.getNormal();
            double velocity = 12.0;
            double border = 0.34;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (direction.getAxis() == Direction.Axis.X) {
                y += 0.5 + (random.nextBoolean() ? -border : border);
                x += 0.5;
                z += 0.5 + (random.nextBoolean() ? -border : border);
            } else if (direction.getAxis() == Direction.Axis.Z) {
                y += 0.5 + (random.nextBoolean() ? -border : border);
                x += 0.5 + (random.nextBoolean() ? -border : border);
                z += 0.5;
            } else {
                y += 0.5;
                x += 0.5 + (random.nextBoolean() ? -border : border);
                z += 0.5 + (random.nextBoolean() ? -border : border);
            }
            level.addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, (double)vector.getX() / velocity, (double)vector.getY() / velocity, (double)vector.getZ() / velocity);
        }
    }

    public FluidState getFluidState(BlockState p_56969_) {
        return (Boolean)p_56969_.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_56969_);
    }

    static {
        for (Direction value : Direction.values()) {
            DIRECTIONS.put(value, (EnumProperty<PipeState>)EnumProperty.create((String)value.getName().toLowerCase(Locale.ROOT), PipeState.class));
        }
    }

    public static enum PipeState implements StringRepresentable
    {
        NO,
        PIPE,
        BLOCK;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

