/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.network;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ClientBoundDamageNumberMessage(int entityID, float damageAmount, Holder<DamageType> damageType, boolean isCrit, float critMult) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundDamageNumberMessage> TYPE = Message.makeType((ResourceLocation)Dummmmmmy.res("s2c_damage_number"), ClientBoundDamageNumberMessage::of);

    public ClientBoundDamageNumberMessage(int id, float damage, @Nullable DamageSource source, @Nullable CritRecord critical) {
        this(id, damage, ClientBoundDamageNumberMessage.encodeDamage(source), critical != null, critical == null ? 0.0f : critical.getMultiplier());
    }

    public static ClientBoundDamageNumberMessage of(RegistryFriendlyByteBuf buf) {
        int entityID = buf.readInt();
        float damageAmount = buf.readFloat();
        Holder damageType = (Holder)DamageType.STREAM_CODEC.decode((Object)buf);
        boolean isCrit = buf.readBoolean();
        float critMult = isCrit ? buf.readFloat() : 0.0f;
        return new ClientBoundDamageNumberMessage(entityID, damageAmount, (Holder<DamageType>)damageType, isCrit, critMult);
    }

    public static Holder<DamageType> encodeDamage(@Nullable DamageSource source) {
        if (source == null) {
            return Dummmmmmy.TRUE_DAMAGE;
        }
        Holder damageType = source.typeHolder();
        return (Holder)Preconditions.checkNotNull((Object)damageType);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeFloat(this.damageAmount);
        DamageType.STREAM_CODEC.encode((Object)buf, this.damageType);
        buf.writeBoolean(this.isCrit);
        if (this.isCrit) {
            buf.writeFloat(this.critMult);
        }
    }

    public void handle(Message.Context context) {
        Entity entity = Minecraft.getInstance().level.getEntity(this.entityID);
        if (entity instanceof TargetDummyEntity) {
            TargetDummyEntity dummy = (TargetDummyEntity)entity;
            if (ClientConfigs.DAMAGE_NUMBERS.get().booleanValue()) {
                int i = dummy.getNextNumberPos();
                this.spawnNumber(entity, i);
            }
            if (ClientConfigs.HAY_PARTICLES.get().booleanValue()) {
                this.spawnHay(entity);
            }
        } else if (entity != null) {
            this.spawnNumber(entity, 0);
        }
    }

    private void spawnHay(Entity entity) {
        RandomSource random = entity.getRandom();
        int amount = (int)(1.0f + Mth.map((float)this.damageAmount, (float)0.0f, (float)40.0f, (float)0.0f, (float)10.0f));
        amount = Math.min(amount, 10);
        for (int i = 0; i < amount; ++i) {
            Vec3 pos = new Vec3(entity.getRandomX(0.5), entity.getY() + 0.75 + (double)random.nextFloat() * 0.85, entity.getRandomZ(0.5));
            Vec3 speed = ClientBoundDamageNumberMessage.getOutwardSpeed(pos.subtract(entity.position()), random);
            entity.level().addParticle((ParticleOptions)Dummmmmmy.HAY_PARTICLE.get(), pos.x, pos.y, pos.z, speed.x, (double)random.nextFloat() * 0.04, speed.z);
        }
    }

    public static Vec3 getOutwardSpeed(Vec3 position, RandomSource random) {
        Vec3 direction = position.normalize();
        float randomLen = 0.02f + random.nextFloat() * 0.04f;
        float angleVariation = (float)(random.nextGaussian() * (double)0.3f);
        float sin = Mth.sin((float)angleVariation);
        float cos = Mth.cos((float)angleVariation);
        double newX = direction.x * (double)cos - direction.z * (double)sin;
        double newY = direction.x * (double)sin + direction.z * (double)cos;
        return new Vec3(newX * (double)randomLen, 0.0, newY * (double)randomLen);
    }

    private void spawnNumber(Entity entity, int animationPos) {
        Holder<DamageType> type = this.damageType;
        float mult = 0.0f;
        CritMode critMode = ClientConfigs.CRIT_MODE.get();
        if (critMode != CritMode.OFF && this.isCrit) {
            type = Dummmmmmy.CRITICAL_DAMAGE;
            if (critMode == CritMode.COLOR_AND_MULTIPLIER) {
                mult = this.critMult;
            }
        }
        double z = CritMode.encodeIntFloatToDouble(animationPos, mult);
        int color = ClientConfigs.getDamageColor(type);
        entity.level().addParticle((ParticleOptions)Dummmmmmy.NUMBER_PARTICLE.get(), entity.getX(), entity.getY() + 1.0, entity.getZ(), (double)this.damageAmount, (double)color, z);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

