/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.DummyMobType;
import net.mehvahdjukaar.dummmmmmy.configs.CommonConfigs;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundDamageNumberMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundUpdateAnimationMessage;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetDummyEntity
extends Mob {
    private static final int SHIELD_COOLDOWN = 100;
    private static final int HEALTH_RECHARGE_TIME = 200;
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BOSS = SynchedEntityData.defineId(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int lastTickActuallyDamaged;
    private float totalDamageTakenInCombat;
    private float totalHealingTakenInCombat;
    private final List<CritRecord> critRecordsThisTick = new ArrayList<CritRecord>();
    private DummyMobType mobType = DummyMobType.UNDEFINED;
    private DamageSource currentDamageSource = null;
    private boolean unbreakable = false;
    private final PlayersTracker playersTracker = new PlayersTracker();
    private int healthRechargeTimer = 0;
    private float lastHealth;
    private float prevAnimationPosition = 0.0f;
    private float animationPosition;
    private int damageNumberPos = 0;
    private float shakeAmount = 0.0f;
    private float prevShakeAmount = 0.0f;
    private int shieldCooldown = 0;

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setCanPickUpLoot(false);
        Arrays.fill(this.armorDropChances, 1.1f);
        this.playersTracker.showHealthBar(false);
    }

    public TargetDummyEntity(Level world) {
        this(Dummmmmmy.TARGET_DUMMY.get(), world);
    }

    public float getShake(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevShakeAmount, (float)this.shakeAmount);
    }

    public float getAnimationPosition(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevAnimationPosition, (float)this.animationPosition);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    public boolean isBoss() {
        return (Boolean)this.entityData.get(BOSS);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (dataAccessor == BOSS) {
            this.playersTracker.showHealthBar(this.isBoss());
        }
    }

    public void setBoss(boolean boss) {
        this.entityData.set(BOSS, (Object)boss);
        this.playersTracker.showHealthBar(boss);
    }

    public boolean canScare() {
        return this.mobType == DummyMobType.SCARECROW;
    }

    public boolean canAttract() {
        return this.mobType == DummyMobType.DECOY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        super.setItemSlot(slot, stack);
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.get(stack);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARED, (Object)false);
        builder.define(BOSS, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.isSheared());
        tag.putInt("HealthRechargeTimer", this.healthRechargeTimer);
        if (this.unbreakable) {
            tag.putBoolean("Unbreakable", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        this.healthRechargeTimer = tag.getInt("HealthRechargeTimer");
        if (tag.contains("Unbreakable")) {
            this.unbreakable = tag.getBoolean("Unbreakable");
        }
        this.mobType = DummyMobType.get(this.getItemBySlot(EquipmentSlot.HEAD));
        this.setBoss(this.getItemBySlot(EquipmentSlot.OFFHAND).getItem() instanceof BannerItem);
        this.lastHealth = this.getHealth();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        boolean success = false;
        if (!player.isSpectator() && player.getAbilities().mayBuild) {
            ItemStack itemstack = player.getItemInHand(hand);
            EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(itemstack);
            Item item = itemstack.getItem();
            if (DummyMobType.get(itemstack) != DummyMobType.UNDEFINED || ForgeHelper.canEquipItem((LivingEntity)this, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                equipmentSlot = EquipmentSlot.HEAD;
            }
            Level level = player.level();
            if (itemstack.isEmpty() && hand == InteractionHand.MAIN_HAND) {
                equipmentSlot = this.getClickedSlot(vec);
                if (equipmentSlot == null) {
                    equipmentSlot = this.hasItemInSlot(EquipmentSlot.MAINHAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                }
                if (this.hasItemInSlot(equipmentSlot)) {
                    if (level.isClientSide) {
                        return InteractionResult.CONSUME;
                    }
                    this.swapItem(player, equipmentSlot, ItemStack.EMPTY, hand);
                    success = true;
                }
            } else if (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                if (level.isClientSide) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, equipmentSlot, itemstack, hand);
                success = true;
            } else if (itemstack.getItem() instanceof ShieldItem) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 1.0f, 1.0f);
                if (level.isClientSide) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, EquipmentSlot.MAINHAND, itemstack, hand);
                success = true;
            } else if (item instanceof ShearsItem) {
                if (!this.isSheared()) {
                    player.playSound(SoundEvents.SNOW_GOLEM_SHEAR, 1.0f, 1.0f);
                    if (level.isClientSide) {
                        return InteractionResult.CONSUME;
                    }
                    this.setSheared(true);
                    return InteractionResult.SUCCESS;
                }
            } else if (item instanceof BannerItem) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 1.0f, 1.0f);
                if (level.isClientSide) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, EquipmentSlot.OFFHAND, itemstack, hand);
                this.setBoss(true);
                return InteractionResult.SUCCESS;
            }
            if (success) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void swapItem(Player player, EquipmentSlot slot, ItemStack armor, InteractionHand hand) {
        ItemStack oldArmor = this.getItemBySlot(slot);
        player.setItemInHand(hand, oldArmor.copy());
        this.setItemSlotAndDropWhenKilled(slot, armor);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.setBoss(false);
    }

    @Nullable
    private EquipmentSlot getClickedSlot(Vec3 vec3) {
        EquipmentSlot equipmentSlot = null;
        double d0 = vec3.y;
        EquipmentSlot slot = EquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.hasItemInSlot(slot)) {
            equipmentSlot = EquipmentSlot.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
            equipmentSlot = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
            equipmentSlot = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            equipmentSlot = EquipmentSlot.HEAD;
        }
        return equipmentSlot;
    }

    public void dropEquipment() {
        this.dropPreservedEquipment();
        this.spawnAtLocation(this.getPickResult(), 1.0f);
    }

    public Set<EquipmentSlot> dropPreservedEquipment(Predicate<ItemStack> predicate) {
        HashSet<EquipmentSlot> set = new HashSet<EquipmentSlot>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            if (itemStack.isEmpty()) continue;
            if (!predicate.test(itemStack)) {
                set.add(equipmentSlot);
                continue;
            }
            double d = this.getEquipmentDropChance(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            this.spawnAtLocation(itemStack, 1.0f);
        }
        return set;
    }

    public void dismantle(boolean drops) {
        Level level = this.level();
        if (!level.isClientSide && this.isAlive()) {
            if (drops) {
                this.dropEquipment();
            }
            this.playSound(this.getDeathSound(), 1.0f, 1.0f);
            ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent((Holder)GameEvent.ENTITY_DIE);
        }
    }

    private void setRecharging() {
        this.healthRechargeTimer = 200;
        CombatTracker tracker = this.getCombatTracker();
        tracker.entries.clear();
        this.playersTracker.finishFight();
        this.level().broadcastEntityEvent((Entity)this, (byte)32);
    }

    public float getRechargingAnimation(float partialTicks) {
        return Math.max(0.0f, Mth.lerp((float)partialTicks, (float)this.healthRechargeTimer, (float)(this.healthRechargeTimer - 1)) / 200.0f);
    }

    public boolean isRecharging() {
        return this.healthRechargeTimer > 0;
    }

    public boolean hasInfiniteHealth() {
        return !this.isBoss() || !this.playersTracker.hasPlayers();
    }

    @NotNull
    public ItemStack getPickResult() {
        ItemStack itemStack = new ItemStack((ItemLike)Dummmmmmy.DUMMY_ITEM.get());
        if (this.hasCustomName()) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return itemStack;
    }

    public void kill() {
        this.dismantle(true);
    }

    public boolean isBlocking() {
        return this.shieldCooldown == 0 && !this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    protected void blockUsingShield(LivingEntity attacker) {
        super.blockUsingShield(attacker);
        if (attacker.canDisableShield()) {
            this.disableShield();
        } else {
            this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
        }
    }

    private void disableShield() {
        this.shieldCooldown = 100;
        this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
        this.level().broadcastEntityEvent((Entity)this, (byte)30);
    }

    public void handleEntityEvent(byte id) {
        if (id == 30) {
            this.shieldCooldown = 100;
        }
        if (id == 32) {
            this.healthRechargeTimer = 200;
        }
        super.handleEntityEvent(id);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isRecharging() || super.isInvulnerableTo(source) || source == this.damageSources().drown() || source == this.damageSources().inWall();
    }

    public boolean hurt(DamageSource source, float damage) {
        CritRecord critRecord;
        if (source == this.damageSources().fellOutOfWorld()) {
            this.remove(Entity.RemovalReason.KILLED);
            return true;
        }
        if (source.getDirectEntity() instanceof WitherBoss || source.getEntity() instanceof WitherBoss) {
            this.dismantle(true);
            return true;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.playersTracker.track(sp);
            }
            if (player.isShiftKeyDown() && player.getMainHandItem().isEmpty() && !this.unbreakable && player.getAbilities().mayBuild) {
                this.dismantle(!player.isCreative());
                return false;
            }
        }
        if (this.level().isClientSide) {
            return false;
        }
        DamageSource old = this.currentDamageSource;
        this.currentDamageSource = source;
        if (!this.critRecordsThisTick.isEmpty() && (critRecord = this.critRecordsThisTick.get(this.critRecordsThisTick.size() - 1)).canCompleteWith(source)) {
            critRecord.addSource(source);
        }
        boolean result = super.hurt(source, damage);
        this.currentDamageSource = old;
        this.hurtTime = 0;
        return result;
    }

    public void setHealth(float newHealth) {
        if (newHealth == this.getMaxHealth()) {
            super.setHealth(newHealth);
        } else {
            Level level = this.level();
            if (level.isClientSide) {
                return;
            }
            float damage = this.getHealth() - newHealth;
            DamageSource actualSource = this.getActualDamageSource(damage);
            if (actualSource != null || damage < 0.0f) {
                this.onActuallyDamagedOrTrueDamageDetected(damage, actualSource);
            }
            this.lastTickActuallyDamaged = this.tickCount;
            if (!this.hasInfiniteHealth()) {
                this.doSetHealth(newHealth);
                if (newHealth <= 0.0f) {
                    this.setRecharging();
                }
            }
        }
    }

    private void doSetHealth(float newHealth) {
        super.setHealth(newHealth);
        this.lastHealth = this.getHealth();
        this.playersTracker.updateHealth();
    }

    @Nullable
    private DamageSource getActualDamageSource(float damage) {
        DamageSource actualSource = null;
        if (PlatHelper.getPlatform().isForge()) {
            CombatEntry currentCombatEntry = this.getLastEntry();
            if (currentCombatEntry != null && this.getCombatTracker().lastDamageTime == this.tickCount) {
                actualSource = currentCombatEntry.source();
                if ((double)Math.abs(damage - currentCombatEntry.damage()) > 1.0E-4) {
                    boolean bl = false;
                }
            }
        } else {
            actualSource = this.currentDamageSource;
        }
        return actualSource;
    }

    public boolean isDeadOrDying() {
        return false;
    }

    private void onActuallyDamagedOrTrueDamageDetected(float damage, @Nullable DamageSource actualSource) {
        if (this.isRecharging()) {
            return;
        }
        if (damage < 0.0f) {
            this.playersTracker.getPlayers().forEach(this.playersTracker::track);
        }
        this.showDamageAndAnimationsToClients(damage, actualSource);
        if (damage < 0.0f) {
            this.totalHealingTakenInCombat -= damage;
        } else {
            this.totalDamageTakenInCombat += damage;
        }
        this.updateTargetBlock(damage);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            float xp;
            ServerLevel sl = (ServerLevel)level;
            if (damage > 0.0f && (xp = CommonConfigs.DROP_XP.get().floatValue() * damage) > 0.0f) {
                ExperienceOrb.award((ServerLevel)sl, (Vec3)this.position().add(0.0, 0.5, 0.0), (int)Mth.floor((float)xp));
            }
        }
    }

    @Nullable
    public CombatEntry getLastEntry() {
        CombatTracker tracker = this.getCombatTracker();
        if (tracker.entries.isEmpty()) {
            return null;
        }
        return (CombatEntry)tracker.entries.get(tracker.entries.size() - 1);
    }

    private void showDamageAndAnimationsToClients(float damage, @Nullable DamageSource source) {
        if (this.lastTickActuallyDamaged != this.tickCount) {
            this.animationPosition = 0.0f;
        }
        if (damage > 0.0f) {
            this.animationPosition = Math.min(this.animationPosition + damage, 60.0f);
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientBoundUpdateAnimationMessage(this.getId(), this.animationPosition));
        }
        if (this.playersTracker.hasPlayers()) {
            CritRecord critRec = null;
            for (int j = this.critRecordsThisTick.size() - 1; j >= 0; --j) {
                CritRecord c = this.critRecordsThisTick.get(j);
                if (!c.matches(source)) continue;
                critRec = c;
                break;
            }
            for (ServerPlayer p : this.playersTracker.getPlayers()) {
                NetworkHelper.sendToClientPlayer((ServerPlayer)p, (CustomPacketPayload)new ClientBoundDamageNumberMessage(this.getId(), damage, source, critRec));
            }
            if (critRec != null) {
                this.critRecordsThisTick.remove(critRec);
            }
        }
    }

    private void updateTargetBlock(float damage) {
        Level level;
        BlockPos pos = this.getOnPos();
        BlockState state = this.getBlockStateOn();
        if (state.getBlock() instanceof TargetBlock && !(level = this.level()).getBlockTicks().hasScheduledTick(pos, (Object)state.getBlock())) {
            int power = (int)Mth.clamp((float)(damage / this.getHealth() * 15.0f), (float)1.0f, (float)15.0f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(power)), 3);
            level.scheduleTick(pos, state.getBlock(), 20);
        }
    }

    protected void updateControlFlags() {
    }

    protected Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(this.getEyeHeight() - 1.0f), 0.0);
    }

    public void aiStep() {
        super.aiStep();
    }

    public void tick() {
        if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        }
        this.critRecordsThisTick.clear();
        Level level = this.level();
        BlockPos onPos = this.getOnPos();
        float health = this.getHealth();
        if (!level.isClientSide) {
            float trueDamage;
            if (this.lastTickActuallyDamaged + 1 == this.tickCount && !level.isClientSide && (trueDamage = this.lastHealth - health) > 0.0f) {
                if (this.hasInfiniteHealth()) {
                    this.heal(trueDamage);
                }
                this.onActuallyDamagedOrTrueDamageDetected(trueDamage, null);
            }
            if (level.getGameTime() % 20L == 0L && level.isEmptyBlock(onPos)) {
                this.dismantle(true);
                return;
            }
        }
        if (this.healthRechargeTimer != 0) {
            --this.healthRechargeTimer;
            this.doSetHealth(health + this.getMaxHealth() / 200.0f);
            if (this.healthRechargeTimer == 0) {
                this.playersTracker.clear();
                this.totalHealingTakenInCombat = 0.0f;
                this.totalDamageTakenInCombat = 0.0f;
            }
        }
        this.setNoGravity(true);
        BlockState onState = level.getBlockState(onPos);
        onState.getBlock().stepOn(level, onPos, onState, (Entity)this);
        super.tick();
        if (level.isClientSide) {
            this.hurtTime = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevAnimationPosition = this.animationPosition;
            if (this.animationPosition > 0.0f) {
                this.shakeAmount += 1.0f;
                this.animationPosition -= 0.8f;
                if (this.animationPosition <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.animationPosition = 0.0f;
                }
            }
        } else {
            this.displayCombatMessages();
        }
    }

    private void displayCombatMessages() {
        CombatTracker tracker = this.getCombatTracker();
        if (tracker.inCombat) {
            float combatDuration = tracker.getCombatDuration();
            this.playersTracker.update(combatDuration, this.totalDamageTakenInCombat, this.totalHealingTakenInCombat);
        } else {
            this.totalDamageTakenInCombat = 0.0f;
            if (!this.playersTracker.hasPlayers()) {
                this.totalHealingTakenInCombat = 0.0f;
            }
        }
    }

    public void setDeltaMovement(Vec3 motionIn) {
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected boolean isImmobile() {
        return true;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected void markHurt() {
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @NotNull
    public SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM) || this.mobType.isInvertedHealAndHarm();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        if ((effectInstance.is(MobEffects.REGENERATION) || effectInstance.is(MobEffects.POISON)) && this.mobType.ignoresPoisonAndRegen()) {
            return false;
        }
        return super.canBeAffected(effectInstance);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.playersTracker.healthBar.setName(this.getDisplayName());
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.playersTracker.unTrack(serverPlayer);
    }

    @NotNull
    public DummyMobType getMobType() {
        return this.mobType;
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, (double)CommonConfigs.BOSS_HEALTH.get().intValue()).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FLYING_SPEED, 0.0);
    }

    public void updateAnimation(float shake) {
        this.animationPosition = shake;
    }

    public void moist(Entity attacker, float critModifier) {
        this.critRecordsThisTick.add(new CritRecord(attacker, critModifier));
    }

    public int getNextNumberPos() {
        return this.damageNumberPos++;
    }

    private void showDpsMessageTo(ServerPlayer player, float combatDuration, float dps, float hps, boolean outOfCompat) {
        boolean showMessage;
        CommonConfigs.DpsMode dpsMode = CommonConfigs.DYNAMIC_DPS.get();
        if (dpsMode != CommonConfigs.DpsMode.OFF && combatDuration > 0.0f && (showMessage = dpsMode == CommonConfigs.DpsMode.DYNAMIC ? this.lastTickActuallyDamaged + 1 == this.tickCount : outOfCompat) && player.distanceTo((Entity)this) < 64.0f) {
            MutableComponent message;
            MutableComponent dpsMessage = Component.translatable((String)"message.dummmmmmy.dps", (Object[])new Object[]{Dummmmmmy.DF2.format(dps)});
            MutableComponent hpsMessage = Component.translatable((String)"message.dummmmmmy.hps", (Object[])new Object[]{Dummmmmmy.DF2.format(hps)});
            if (dps > 0.0f && hps > 0.0f) {
                message = Component.translatable((String)"message.dummmmmmy.double", (Object[])new Object[]{this.getDisplayName(), dpsMessage, hpsMessage});
            } else if (dps > 0.0f) {
                message = Component.translatable((String)"message.dummmmmmy.single", (Object[])new Object[]{this.getDisplayName(), dpsMessage});
            } else if (hps > 0.0f) {
                message = Component.translatable((String)"message.dummmmmmy.single", (Object[])new Object[]{this.getDisplayName(), hpsMessage});
            } else {
                return;
            }
            player.displayClientMessage((Component)message, true);
        }
    }

    private class PlayersTracker {
        private final Map<ServerPlayer, Integer> currentlyAttacking = new HashMap<ServerPlayer, Integer>();
        private final ServerBossEvent healthBar = new ServerBossEvent(TargetDummyEntity.this.getDisplayName(), CommonConfigs.BOSS_HEALTH_COLOR.get(), BossEvent.BossBarOverlay.NOTCHED_12);

        private PlayersTracker() {
        }

        public void showHealthBar(boolean on) {
            this.healthBar.setVisible(on);
            if (!on) {
                this.healthBar.removeAllPlayers();
            }
        }

        public void updateHealth() {
            this.healthBar.setProgress(TargetDummyEntity.this.getHealth() / TargetDummyEntity.this.getMaxHealth());
        }

        public void track(ServerPlayer serverPlayer) {
            this.currentlyAttacking.put(serverPlayer, 300);
            this.healthBar.addPlayer(serverPlayer);
        }

        public void unTrack(ServerPlayer serverPlayer) {
            this.currentlyAttacking.remove(serverPlayer);
            if (!TargetDummyEntity.this.isRecharging()) {
                this.healthBar.removePlayer(serverPlayer);
            }
        }

        public void update(float combatDuration, float totalDamageTakenInCombat, float totalHealingTakenInCombat) {
            ArrayList<ServerPlayer> removedPlayers = new ArrayList<ServerPlayer>();
            float seconds = combatDuration / 20.0f + 1.0f;
            float dps = totalDamageTakenInCombat / seconds;
            float hps = totalHealingTakenInCombat / seconds;
            for (Map.Entry<ServerPlayer, Integer> e : this.currentlyAttacking.entrySet()) {
                ServerPlayer p = e.getKey();
                int timer = e.getValue() - 1;
                this.currentlyAttacking.replace(p, timer);
                boolean outOfCombat = false;
                if (timer <= 0) {
                    removedPlayers.add(p);
                    outOfCombat = true;
                }
                TargetDummyEntity.this.showDpsMessageTo(p, combatDuration, dps, hps, outOfCombat);
            }
            removedPlayers.forEach(this::unTrack);
        }

        public boolean hasPlayers() {
            return !this.currentlyAttacking.isEmpty();
        }

        public Collection<ServerPlayer> getPlayers() {
            return this.currentlyAttacking.keySet();
        }

        public void clear() {
            this.currentlyAttacking.clear();
            this.healthBar.removeAllPlayers();
        }

        public void finishFight() {
            this.currentlyAttacking.replaceAll((p, i) -> 0);
        }
    }
}

