/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0 J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u001bJ\"\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)2\u0006\u0010'\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J4\u00101\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u0002H50402\"\u0004\b\u0000\u001052\u0014\u00106\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H50%0+R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/OtherUtil;", "", "<init>", "()V", "modResource", "Lnet/minecraft/resources/ResourceLocation;", "path", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/ItemLike;", "getItemStack", "(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/item/ItemStack;", "entityUuidMap", "", "Ljava/util/UUID;", "Lnet/minecraft/world/entity/LivingEntity;", "getNearbyEntityFromUuid", "uuid", "searchAroundEntity", "getUuidOrNull", "Lnet/minecraft/nbt/CompoundTag;", "key", "getEntityType", "Lnet/minecraft/world/entity/EntityType;", "resourceLocation", "getLookedAtEntity", "Lnet/minecraft/world/entity/Entity;", "livingEntity", "getPotionContents", "Lnet/minecraft/world/item/alchemy/PotionContents;", "getPotion", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "getPotionStack", "potion", "getEnchantmentRegistry", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "entity", "getEnchantHolder", "Lnet/minecraft/core/Holder$Reference;", "enchantment", "Lnet/minecraft/resources/ResourceKey;", "componentList", "Lnet/minecraft/network/chat/MutableComponent;", "components", "", "Lnet/minecraft/network/chat/Component;", "tagKeyStreamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "Lnet/minecraft/tags/TagKey;", "T", "registry", "geneticsresequenced-1.21.1"})
public final class OtherUtil {
    @NotNull
    public static final OtherUtil INSTANCE = new OtherUtil();
    @NotNull
    private static final Map<UUID, LivingEntity> entityUuidMap = new LinkedHashMap();

    private OtherUtil() {
    }

    @NotNull
    public final ResourceLocation modResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"geneticsresequenced", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public final ItemStack getItemStack(@NotNull ItemLike $this$itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$itemStack, (String)"<this>");
        ItemStack itemStack = $this$itemStack.asItem().getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    @Nullable
    public final LivingEntity getNearbyEntityFromUuid(@NotNull UUID uuid, @NotNull LivingEntity searchAroundEntity) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)searchAroundEntity, (String)"searchAroundEntity");
        LivingEntity mappedValue = entityUuidMap.get(uuid);
        if (mappedValue != null) {
            return mappedValue;
        }
        List nearbyEntities = searchAroundEntity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, searchAroundEntity, searchAroundEntity.getBoundingBox().inflate(50.0));
        for (LivingEntity entity : nearbyEntities) {
            if (!Intrinsics.areEqual((Object)entity.getUUID(), (Object)uuid)) continue;
            entityUuidMap.put(uuid, entity);
            return entity;
        }
        return null;
    }

    @Nullable
    public final UUID getUuidOrNull(@NotNull CompoundTag $this$getUuidOrNull, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getUuidOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!$this$getUuidOrNull.hasUUID(key)) {
            return null;
        }
        return $this$getUuidOrNull.getUUID(key);
    }

    @NotNull
    public final EntityType<?> getEntityType(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Object object = BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EntityType entityType = (EntityType)object;
        if (entityType == EntityType.PIG && !Intrinsics.areEqual((Object)resourceLocation, (Object)BuiltInRegistries.ENTITY_TYPE.getDefaultKey())) {
            throw new IllegalArgumentException("Unknown entity type: " + resourceLocation);
        }
        return entityType;
    }

    @Nullable
    public final Entity getLookedAtEntity(@NotNull LivingEntity livingEntity) {
        EntityHitResult entityHitResult;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        double reach = livingEntity.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        EntityHitResult entityHitResult2 = entityHitResult = ProjectileUtil.getEntityHitResult((Entity)((Entity)livingEntity), (Vec3)livingEntity.getEyePosition(), (Vec3)livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale(reach)), (AABB)livingEntity.getBoundingBox().inflate(reach), OtherUtil::getLookedAtEntity$lambda$0, (double)reach);
        return entityHitResult2 != null ? entityHitResult2.getEntity() : null;
    }

    @Nullable
    public final PotionContents getPotionContents(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
    }

    @Nullable
    public final Holder<Potion> getPotion(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Object object = this.getPotionContents(itemStack);
        return object != null && (object = object.potion()) != null ? (Holder)OptionalsKt.getOrNull((Optional)object) : null;
    }

    @NotNull
    public final ItemStack getPotionStack(@NotNull Holder<Potion> potion) {
        Intrinsics.checkNotNullParameter(potion, (String)"potion");
        ItemStack itemStack = PotionContents.createItemStack((Item)Items.POTION, potion);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createItemStack(...)");
        return itemStack;
    }

    @NotNull
    public final Registry<Enchantment> getEnchantmentRegistry(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Registry registry = entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public final Holder.Reference<Enchantment> getEnchantHolder(@NotNull Entity entity, @NotNull ResourceKey<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        Holder.Reference reference = this.getEnchantmentRegistry(entity).getHolderOrThrow(enchantment);
        Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"getHolderOrThrow(...)");
        return reference;
    }

    @NotNull
    public final MutableComponent componentList(@NotNull List<? extends Component> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        MutableComponent mutableComponent = Component.empty();
        for (Component component : components) {
            mutableComponent.append("\u2022 ").append(component);
            if (Intrinsics.areEqual((Object)component, (Object)CollectionsKt.last(components))) continue;
            mutableComponent.append("\n");
        }
        Intrinsics.checkNotNull((Object)mutableComponent);
        return mutableComponent;
    }

    @NotNull
    public final <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(@NotNull ResourceKey<? extends Registry<T>> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        StreamCodec streamCodec = ResourceLocation.STREAM_CODEC.map(arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$2(arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$1(registry, arg_0), arg_0), arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$4(OtherUtil::tagKeyStreamCodec$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"map(...)");
        return streamCodec;
    }

    private static final boolean getLookedAtEntity$lambda$0(Entity it) {
        return true;
    }

    private static final TagKey tagKeyStreamCodec$lambda$1(ResourceKey $registry, ResourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)$registry, (String)"$registry");
        return TagKey.create((ResourceKey)$registry, (ResourceLocation)it);
    }

    private static final TagKey tagKeyStreamCodec$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TagKey)$tmp0.invoke(p0);
    }

    private static final ResourceLocation tagKeyStreamCodec$lambda$3(TagKey it) {
        return it.location();
    }

    private static final ResourceLocation tagKeyStreamCodec$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResourceLocation)$tmp0.invoke(p0);
    }
}

