/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import com.google.common.collect.HashMultimap;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0002R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/ModScheduler;", "", "<init>", "()V", "onServerTick", "", "event", "Lnet/neoforged/neoforge/event/tick/ServerTickEvent$Post;", "value", "", "currentTick", "getCurrentTick", "()I", "setCurrentTick", "(I)V", "upcomingTasks", "Lcom/google/common/collect/HashMultimap;", "Ljava/lang/Runnable;", "scheduleTaskInTicks", "ticksInFuture", "runnable", "handleScheduledTasks", "tick", "geneticsresequenced-1.21.1"})
public final class ModScheduler {
    @NotNull
    public static final ModScheduler INSTANCE = new ModScheduler();
    private static int currentTick;
    @NotNull
    private static final HashMultimap<Integer, Runnable> upcomingTasks;

    private ModScheduler() {
    }

    @SubscribeEvent
    public final void onServerTick(@NotNull ServerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = currentTick;
        this.setCurrentTick(n + 1);
    }

    public final int getCurrentTick() {
        return currentTick;
    }

    public final void setCurrentTick(int value) {
        currentTick = value;
        this.handleScheduledTasks(value);
    }

    public final void scheduleTaskInTicks(int ticksInFuture, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (ticksInFuture > 0) {
            upcomingTasks.put((Object)(currentTick + ticksInFuture), (Object)runnable);
        } else {
            runnable.run();
        }
    }

    private final void handleScheduledTasks(int tick) {
        if (!upcomingTasks.containsKey((Object)tick)) {
            return;
        }
        Iterator tasks = upcomingTasks.get((Object)tick).iterator();
        while (tasks.hasNext()) {
            try {
                ((Runnable)tasks.next()).run();
            }
            catch (Exception e) {
                GeneticsResequenced.Companion.getLOGGER().error(e.toString());
            }
            tasks.remove();
        }
    }

    static {
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        upcomingTasks = hashMultimap;
    }
}

