/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.ClickGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.ModScheduler;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00112\b\b\u0002\u0010%\u001a\u00020\u001dR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/ClientUtil;", "", "<init>", "()V", "localPlayer", "Lnet/minecraft/client/player/LocalPlayer;", "getLocalPlayer", "()Lnet/minecraft/client/player/LocalPlayer;", "localRegistryAccess", "Lnet/minecraft/core/RegistryAccess;", "getLocalRegistryAccess", "()Lnet/minecraft/core/RegistryAccess;", "localLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "getLocalLevel", "()Lnet/minecraft/client/multiplayer/ClientLevel;", "playerIsCreative", "", "options", "Lnet/minecraft/client/Options;", "getOptions", "()Lnet/minecraft/client/Options;", "removedSkinLayers", "", "Lnet/minecraft/world/entity/player/PlayerModelPart;", "shearPlayerSkin", "", "addSkinLayersBack", "value", "", "amountTryingToChangeLanguage", "setAmountTryingToChangeLanguage", "(I)V", "nonCringeLanguage", "", "handleCringe", "wasAdded", "countdownSeconds", "geneticsresequenced-1.21.1"})
public final class ClientUtil {
    @NotNull
    public static final ClientUtil INSTANCE = new ClientUtil();
    @NotNull
    private static Set<? extends PlayerModelPart> removedSkinLayers = SetsKt.emptySet();
    private static int amountTryingToChangeLanguage;
    @Nullable
    private static String nonCringeLanguage;

    private ClientUtil() {
    }

    @Nullable
    public final LocalPlayer getLocalPlayer() {
        return Minecraft.getInstance().player;
    }

    @Nullable
    public final RegistryAccess getLocalRegistryAccess() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return clientLevel != null ? clientLevel.registryAccess() : null;
    }

    @Nullable
    public final ClientLevel getLocalLevel() {
        return Minecraft.getInstance().level;
    }

    public final boolean playerIsCreative() {
        LocalPlayer localPlayer = this.getLocalPlayer();
        return localPlayer != null ? localPlayer.isCreative() : false;
    }

    private final Options getOptions() {
        Options options = Minecraft.getInstance().options;
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"options");
        return options;
    }

    public final void shearPlayerSkin() {
        Set set = this.getOptions().modelParts;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"modelParts");
        Set enabledModelParts = CollectionsKt.toMutableSet((Iterable)set);
        if (!((Boolean)ClientConfig.Companion.getWoolyRemovesCape().get()).booleanValue()) {
            enabledModelParts.remove(PlayerModelPart.CAPE);
        }
        for (PlayerModelPart part : enabledModelParts) {
            this.getOptions().toggleModelPart(part, false);
        }
        removedSkinLayers = enabledModelParts;
        GeneticsResequenced.Companion.getLOGGER().info("Sheared layers off player skin: " + CollectionsKt.joinToString$default((Iterable)removedSkinLayers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        Function0 addLayersBackTask = ClientUtil::shearPlayerSkin$lambda$0;
        ClickGenes.INSTANCE.getRecentlySheered().getCooldownEndedTasks().add((Function0<Unit>)addLayersBackTask);
    }

    public final void addSkinLayersBack() {
        if (removedSkinLayers.isEmpty()) {
            return;
        }
        for (PlayerModelPart playerModelPart : removedSkinLayers) {
            this.getOptions().toggleModelPart(playerModelPart, true);
        }
        GeneticsResequenced.Companion.getLOGGER().info("Added layers back to player skin: " + CollectionsKt.joinToString$default((Iterable)removedSkinLayers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        removedSkinLayers = SetsKt.emptySet();
    }

    private final void setAmountTryingToChangeLanguage(int value) {
        amountTryingToChangeLanguage = RangesKt.coerceAtLeast((int)value, (int)0);
    }

    public final void handleCringe(boolean wasAdded, int countdownSeconds) {
        Holder.Reference<Gene> cringe2;
        RegistryAccess access = this.getLocalRegistryAccess();
        if (access != null && Gene.Companion.isDisabled((Holder<Gene>)((Holder)(cringe2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getCRINGE(), (HolderLookup.Provider)access))))) {
            return;
        }
        if (((Boolean)ClientConfig.Companion.getDisableCringeLangChange().get()).booleanValue()) {
            GeneticsResequenced.Companion.getLOGGER().info("Cringe language-changing is disabled in the config!");
            return;
        }
        LanguageManager languageManager = Minecraft.getInstance().getLanguageManager();
        String currentLanguage = languageManager.getSelected();
        String lolcat = "lol_us";
        if (wasAdded) {
            Intrinsics.checkNotNull((Object)currentLanguage);
            if (!StringsKt.startsWith$default((String)currentLanguage, (String)"en_", (boolean)false, (int)2, null)) {
                GeneticsResequenced.Companion.getLOGGER().warn("Cringe language-changing is only available in English!");
                return;
            }
            nonCringeLanguage = currentLanguage;
            languageManager.setSelected(lolcat);
            GeneticsResequenced.Companion.getLOGGER().info("Changed language to cringe!");
        } else {
            if (!Intrinsics.areEqual((Object)languageManager.getSelected(), (Object)lolcat)) {
                return;
            }
            if (nonCringeLanguage == null && Intrinsics.areEqual((Object)languageManager.getSelected(), (Object)lolcat)) {
                GeneticsResequenced.Companion.getLOGGER().warn("Tried to remove cringe language, but no non-cringe language was saved!");
                return;
            }
            String string = nonCringeLanguage;
            if (string == null) {
                string = "en_us";
            }
            languageManager.setSelected(string);
            nonCringeLanguage = null;
            GeneticsResequenced.Companion.getLOGGER().info("Changed language back to non-cringe!");
        }
        ModScheduler.INSTANCE.scheduleTaskInTicks(1, () -> ClientUtil.handleCringe$lambda$2(wasAdded, countdownSeconds));
        for (int secondsLeft = countdownSeconds; secondsLeft > 0; --secondsLeft) {
            int scheduleIn = 20 * (countdownSeconds - secondsLeft);
            if (scheduleIn == 0) continue;
            int secondsLeftFinal = secondsLeft;
            ModScheduler.INSTANCE.scheduleTaskInTicks(scheduleIn, () -> ClientUtil.handleCringe$lambda$3(secondsLeftFinal));
        }
        int n = amountTryingToChangeLanguage;
        this.setAmountTryingToChangeLanguage(n + 1);
        ModScheduler.INSTANCE.scheduleTaskInTicks(20 * countdownSeconds, ClientUtil::handleCringe$lambda$5);
    }

    public static /* synthetic */ void handleCringe$default(ClientUtil clientUtil, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        clientUtil.handleCringe(bl, n);
    }

    private static final Unit shearPlayerSkin$lambda$0() {
        INSTANCE.addSkinLayersBack();
        return Unit.INSTANCE;
    }

    private static final void handleCringe$sendSystemMessage(Component message) {
        block0: {
            LocalPlayer localPlayer = INSTANCE.getLocalPlayer();
            if (localPlayer == null) break block0;
            localPlayer.sendSystemMessage(message);
        }
    }

    private static final Style handleCringe$lambda$2$lambda$1(Style it) {
        return it.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.tooltip", new Object[0])));
    }

    private static final void handleCringe$lambda$2(boolean $wasAdded, int $countdownSeconds) {
        MutableComponent mutableComponent;
        if ($wasAdded) {
            Object[] objectArray = new Object[]{$countdownSeconds};
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.add", objectArray);
        } else {
            Object[] objectArray = new Object[]{$countdownSeconds};
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.remove", objectArray);
        }
        MutableComponent component = mutableComponent.withStyle(ClientUtil::handleCringe$lambda$2$lambda$1);
        Intrinsics.checkNotNull((Object)component);
        ClientUtil.handleCringe$sendSystemMessage((Component)component);
    }

    private static final void handleCringe$lambda$3(int $secondsLeftFinal) {
        block0: {
            LocalPlayer localPlayer = INSTANCE.getLocalPlayer();
            if (localPlayer == null) break block0;
            localPlayer.displayClientMessage((Component)Component.literal((String)($secondsLeftFinal + "...")), true);
        }
    }

    private static final Style handleCringe$lambda$5$lambda$4(Style it) {
        return it.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.tooltip", new Object[0])));
    }

    private static final void handleCringe$lambda$5() {
        MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.resources.reloading", new Object[0]).withStyle(ClientUtil::handleCringe$lambda$5$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        ClientUtil.handleCringe$sendSystemMessage((Component)mutableComponent);
        if (amountTryingToChangeLanguage == 1) {
            Minecraft.getInstance().reloadResourcePacks();
            int n = amountTryingToChangeLanguage;
            INSTANCE.setAmountTryingToChangeLanguage(n + -1);
        } else {
            GeneticsResequenced.Companion.getLOGGER().warn("Tried to reload resources, but it would have caused a concurrency error!");
        }
    }
}

