/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.serialization.MapCodec;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModPotionTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.PotionTagIngredient;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "<init>", "()V", "cellIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/item/crafting/Ingredient;", "potionIngredient", "ingredients", "", "getIngredients", "()Ljava/util/List;", "matches", "", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Serializer", "Companion", "geneticsresequenced-1.21.1"})
public final class SetPotionEntityRecipe
extends AbstractIncubatorRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Ingredient cellIngredient;
    private final Ingredient potionIngredient;
    @NotNull
    private final List<Ingredient> ingredients;
    @NotNull
    private static final SetPotionEntityRecipe INSTANCE = new SetPotionEntityRecipe();

    private SetPotionEntityRecipe() {
        Object[] objectArray = new ItemLike[]{ModItems.INSTANCE.getCELL().get()};
        this.cellIngredient = Ingredient.of((ItemLike[])objectArray);
        this.potionIngredient = new PotionTagIngredient(ModPotionTagsProvider.Companion.getCAN_HAVE_ENTITY()).toVanilla();
        objectArray = new Ingredient[]{this.cellIngredient, this.potionIngredient};
        this.ingredients = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack cellStack = input.getTopItem();
        ItemStack potionStack = input.getBottomItem();
        if (!this.cellIngredient.test(cellStack)) {
            return false;
        }
        if (!this.potionIngredient.test(potionStack)) {
            return false;
        }
        return EntityDnaItem.Companion.hasEntity(cellStack);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack topItem = input.getTopItem();
        ItemStack bottomItem = input.getBottomItem();
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(topItem);
        if (entityType == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EntityType<?> ingredientEntity = entityType;
        ItemStack output = bottomItem.copy();
        Intrinsics.checkNotNull((Object)output);
        EntityDnaItem.Companion.setEntityType(output, ingredientEntity);
        return output;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getSET_POTION_ENTITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = ModRecipeTypes.INSTANCE.getSET_POTION_ENTITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe$Companion;", "", "<init>", "()V", "INSTANCE", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe;", "getINSTANCE", "()Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SetPotionEntityRecipe getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<SetPotionEntityRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<SetPotionEntityRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, SetPotionEntityRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<SetPotionEntityRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SetPotionEntityRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            MapCodec mapCodec = MapCodec.unit((Object)Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"unit(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.unit((Object)Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"unit(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/SetPotionEntityRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<SetPotionEntityRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, SetPotionEntityRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

