/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeTypes;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002-.B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\f\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\f\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "topSlotIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "idealGeneRk", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "geneChance", "", "needsMutationPotion", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/resources/ResourceKey;FZ)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getTopSlotIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getIdealGeneRk", "()Lnet/minecraft/resources/ResourceKey;", "getGeneChance", "()F", "getNeedsMutationPotion", "()Z", "bottomSlotIngredient", "ingredients", "", "getIngredients", "()Ljava/util/List;", "matches", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getFailure", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Serializer", "Companion", "geneticsresequenced-1.21.1"})
public final class GmoRecipe
extends AbstractIncubatorRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Ingredient topSlotIngredient;
    @NotNull
    private final ResourceKey<Gene> idealGeneRk;
    private final float geneChance;
    private final boolean needsMutationPotion;
    @NotNull
    private final Ingredient bottomSlotIngredient;
    @NotNull
    private final List<Ingredient> ingredients;

    public GmoRecipe(@NotNull EntityType<?> entityType, @NotNull Ingredient topSlotIngredient, @NotNull ResourceKey<Gene> idealGeneRk, float geneChance, boolean needsMutationPotion) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)topSlotIngredient, (String)"topSlotIngredient");
        Intrinsics.checkNotNullParameter(idealGeneRk, (String)"idealGeneRk");
        this.entityType = entityType;
        this.topSlotIngredient = topSlotIngredient;
        this.idealGeneRk = idealGeneRk;
        this.geneChance = geneChance;
        this.needsMutationPotion = needsMutationPotion;
        ItemStack potionStack = OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)(this.needsMutationPotion ? ModPotions.INSTANCE.getMUTATION() : ModPotions.INSTANCE.getCELL_GROWTH())));
        EntityDnaItem.Companion.setEntityType(potionStack, this.entityType);
        this.bottomSlotIngredient = DataComponentIngredient.of((boolean)false, (ItemStack)potionStack);
        Object[] objectArray = new Ingredient[]{this.topSlotIngredient, this.bottomSlotIngredient};
        this.ingredients = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final Ingredient getTopSlotIngredient() {
        return this.topSlotIngredient;
    }

    @NotNull
    public final ResourceKey<Gene> getIdealGeneRk() {
        return this.idealGeneRk;
    }

    public final float getGeneChance() {
        return this.geneChance;
    }

    public final boolean getNeedsMutationPotion() {
        return this.needsMutationPotion;
    }

    @Override
    @NotNull
    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack topSlotStack = input.getTopItem();
        ItemStack bottomSlotStack = input.getBottomItem();
        if (input.isHighTemp()) {
            return false;
        }
        if (!this.topSlotIngredient.test(topSlotStack)) {
            return false;
        }
        return this.bottomSlotIngredient.test(bottomSlotStack);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return this.getResultItem(lookup);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack output = OtherUtil.INSTANCE.getItemStack((ItemLike)ModItems.INSTANCE.getGMO_CELL());
        GmoCell.Companion.setDetails(output, this.entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(this.idealGeneRk, lookup)));
        return output;
    }

    @NotNull
    public final ItemStack getFailure(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack output = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)output);
        GmoCell.Companion.setDetails(output, this.entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getBASIC(), lookup)));
        return output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getGMO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = ModRecipeTypes.INSTANCE.getGMO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe$Companion;", "", "<init>", "()V", "getGmoRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "level", "Lnet/minecraft/world/level/Level;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "isValidIngredient", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getGmoRecipe", "incubatorRecipeInput", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "topStack", "bottomStack", "isHighTemp", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nGmoRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GmoRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1611#2,9:178\n1863#2:187\n1864#2:189\n1620#2:190\n1755#2,2:191\n1755#2,3:193\n1757#2:196\n1#3:188\n*S KotlinDebug\n*F\n+ 1 GmoRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe$Companion\n*L\n155#1:178,9\n155#1:187\n155#1:189\n155#1:190\n159#1:191,2\n160#1:193,3\n159#1:196\n155#1:188\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<RecipeHolder<GmoRecipe>> getGmoRecipes(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            RecipeManager recipeManager = level.getRecipeManager();
            Intrinsics.checkNotNull((Object)recipeManager);
            return this.getGmoRecipes(recipeManager);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RecipeHolder<GmoRecipe>> getGmoRecipes(@NotNull RecipeManager recipeManager) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List<RecipeHolder<AbstractIncubatorRecipe>> incubatorRecipes = AbstractIncubatorRecipe.Companion.getIncubatorRecipes(recipeManager);
            Iterable $this$mapNotNull$iv = incubatorRecipes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecipeHolder it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                RecipeHolder it = (RecipeHolder)element$iv$iv;
                boolean bl2 = false;
                if ((it.value() instanceof GmoRecipe ? (it instanceof RecipeHolder ? it : null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final boolean isValidIngredient(@NotNull Level level, @NotNull ItemStack itemStack) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                Iterable $this$any$iv = this.getGmoRecipes(level);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            RecipeHolder recipeHolder = (RecipeHolder)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = ((GmoRecipe)recipeHolder.value()).getIngredients();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Ingredient ingredient = (Ingredient)element$iv2;
                                    boolean bl4 = false;
                                    if (!ingredient.test(itemStack)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public final GmoRecipe getGmoRecipe(@NotNull Level level, @NotNull IncubatorRecipeInput incubatorRecipeInput) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)incubatorRecipeInput, (String)"incubatorRecipeInput");
                Iterable iterable = this.getGmoRecipes(level);
                for (Object t : iterable) {
                    RecipeHolder recipeHolder = (RecipeHolder)t;
                    boolean bl = false;
                    if (!((GmoRecipe)recipeHolder.value()).matches(incubatorRecipeInput, level)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            RecipeHolder recipeHolder = v0;
            return recipeHolder != null ? (GmoRecipe)recipeHolder.value() : null;
        }

        @Nullable
        public final GmoRecipe getGmoRecipe(@NotNull Level level, @NotNull ItemStack topStack, @NotNull ItemStack bottomStack, boolean isHighTemp) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)topStack, (String)"topStack");
            Intrinsics.checkNotNullParameter((Object)bottomStack, (String)"bottomStack");
            return this.getGmoRecipe(level, new IncubatorRecipeInput(topStack, bottomStack, isHighTemp));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<GmoRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<GmoRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, GmoRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<GmoRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, GmoRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final EntityType CODEC$lambda$5$lambda$0(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (EntityType)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient CODEC$lambda$5$lambda$1(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ResourceKey CODEC$lambda$5$lambda$2(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Float CODEC$lambda$5$lambda$3(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Float)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$5$lambda$4(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$5(RecordCodecBuilder.Instance instance) {
            return instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity_type").forGetter(arg_0 -> Serializer.CODEC$lambda$5$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(arg_0 -> Serializer.CODEC$lambda$5$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()).fieldOf("ideal_gene").forGetter(arg_0 -> Serializer.CODEC$lambda$5$lambda$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.FLOAT.optionalFieldOf("gene_chance", (Object)Float.valueOf(1.0f)).forGetter(arg_0 -> Serializer.CODEC$lambda$5$lambda$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("needs_mutation_potion", (Object)false).forGetter(arg_0 -> Serializer.CODEC$lambda$5$lambda$4((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)instance, GmoRecipe::new);
        }

        private static final EntityType STREAM_CODEC$lambda$6(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (EntityType)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient STREAM_CODEC$lambda$7(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ResourceKey STREAM_CODEC$lambda$8(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Float STREAM_CODEC$lambda$9(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Float)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean STREAM_CODEC$lambda$10(KProperty1 $tmp0, GmoRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$5);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), arg_0 -> Serializer.STREAM_CODEC$lambda$6((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$7((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ResourceKey.streamCodec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()), arg_0 -> Serializer.STREAM_CODEC$lambda$8((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.FLOAT, arg_0 -> Serializer.STREAM_CODEC$lambda$9((KProperty1)Companion.STREAM_CODEC.4.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> Serializer.STREAM_CODEC$lambda$10((KProperty1)Companion.STREAM_CODEC.5.INSTANCE, arg_0), GmoRecipe::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<GmoRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, GmoRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

