/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.BasicIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002\"#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "topSlotIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "bottomSlotIngredient", "outputStack", "Lnet/minecraft/world/item/ItemStack;", "isLowTemp", "", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;Z)V", "getTopSlotIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getBottomSlotIngredient", "getOutputStack", "()Lnet/minecraft/world/item/ItemStack;", "()Z", "ingredients", "", "getIngredients", "()Ljava/util/List;", "matches", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Serializer", "Companion", "geneticsresequenced-1.21.1"})
public final class BasicIncubatorRecipe
extends AbstractIncubatorRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ingredient topSlotIngredient;
    @NotNull
    private final Ingredient bottomSlotIngredient;
    @NotNull
    private final ItemStack outputStack;
    private final boolean isLowTemp;
    @NotNull
    private final List<Ingredient> ingredients;

    public BasicIncubatorRecipe(@NotNull Ingredient topSlotIngredient, @NotNull Ingredient bottomSlotIngredient, @NotNull ItemStack outputStack, boolean isLowTemp) {
        Intrinsics.checkNotNullParameter((Object)topSlotIngredient, (String)"topSlotIngredient");
        Intrinsics.checkNotNullParameter((Object)bottomSlotIngredient, (String)"bottomSlotIngredient");
        Intrinsics.checkNotNullParameter((Object)outputStack, (String)"outputStack");
        this.topSlotIngredient = topSlotIngredient;
        this.bottomSlotIngredient = bottomSlotIngredient;
        this.outputStack = outputStack;
        this.isLowTemp = isLowTemp;
        Object[] objectArray = new Ingredient[]{this.topSlotIngredient, this.bottomSlotIngredient};
        this.ingredients = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Ingredient getTopSlotIngredient() {
        return this.topSlotIngredient;
    }

    @NotNull
    public final Ingredient getBottomSlotIngredient() {
        return this.bottomSlotIngredient;
    }

    @NotNull
    public final ItemStack getOutputStack() {
        return this.outputStack;
    }

    public final boolean isLowTemp() {
        return this.isLowTemp;
    }

    @Override
    @NotNull
    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack topItem = input.getTopItem();
        ItemStack bottomItem = input.getBottomItem();
        return this.isLowTemp == input.isLowTemp() && this.topSlotIngredient.test(topItem) && this.bottomSlotIngredient.test(bottomItem);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return this.getResultItem(lookup);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return this.outputStack;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getBASIC_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = ModRecipeTypes.INSTANCE.getBASIC_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe$Companion;", "", "<init>", "()V", "getBasicRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nBasicIncubatorRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicIncubatorRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1611#2,9:103\n1863#2:112\n1864#2:114\n1620#2:115\n1#3:113\n*S KotlinDebug\n*F\n+ 1 BasicIncubatorRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe$Companion\n*L\n98#1:103,9\n98#1:112\n98#1:114\n98#1:115\n98#1:113\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RecipeHolder<BasicIncubatorRecipe>> getBasicRecipes(@NotNull RecipeManager recipeManager) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List<RecipeHolder<AbstractIncubatorRecipe>> incubatorRecipes = AbstractIncubatorRecipe.Companion.getIncubatorRecipes(recipeManager);
            Iterable $this$mapNotNull$iv = incubatorRecipes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecipeHolder it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                RecipeHolder it = (RecipeHolder)element$iv$iv;
                boolean bl2 = false;
                if ((it.value() instanceof BasicIncubatorRecipe ? (it instanceof RecipeHolder ? it : null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<BasicIncubatorRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<BasicIncubatorRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, BasicIncubatorRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<BasicIncubatorRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BasicIncubatorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final Ingredient CODEC$lambda$4$lambda$0(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient CODEC$lambda$4$lambda$1(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ItemStack CODEC$lambda$4$lambda$2(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ItemStack)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$4$lambda$3(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$4(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("top_slot").forGetter(arg_0 -> Serializer.CODEC$lambda$4$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("bottom_slot").forGetter(arg_0 -> Serializer.CODEC$lambda$4$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)ItemStack.CODEC.fieldOf("output").forGetter(arg_0 -> Serializer.CODEC$lambda$4$lambda$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.BOOL.fieldOf("is_low_temperature").forGetter(arg_0 -> Serializer.CODEC$lambda$4$lambda$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0))).apply((Applicative)instance, BasicIncubatorRecipe::new);
        }

        private static final Ingredient STREAM_CODEC$lambda$5(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient STREAM_CODEC$lambda$6(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ItemStack STREAM_CODEC$lambda$7(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ItemStack)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean STREAM_CODEC$lambda$8(KProperty1 $tmp0, BasicIncubatorRecipe p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$4);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$5((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$6((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ItemStack.STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$7((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> Serializer.STREAM_CODEC$lambda$8((KProperty1)Companion.STREAM_CODEC.4.INSTANCE, arg_0), BasicIncubatorRecipe::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/BasicIncubatorRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<BasicIncubatorRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, BasicIncubatorRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

