/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.packet.ModPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.GeneChangedPacket;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket;", "Ldev/aaronhowser/mods/geneticsresequenced/packet/ModPacket;", "entityId", "", "geneRl", "Lnet/minecraft/resources/ResourceLocation;", "wasAdded", "", "<init>", "(ILnet/minecraft/resources/ResourceLocation;Z)V", "getEntityId", "()I", "getGeneRl", "()Lnet/minecraft/resources/ResourceLocation;", "getWasAdded", "()Z", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "receiveMessage", "", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGeneChangedPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneChangedPacket.kt\ndev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class GeneChangedPacket
implements ModPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int entityId;
    @NotNull
    private final ResourceLocation geneRl;
    private final boolean wasAdded;
    @NotNull
    private static final CustomPacketPayload.Type<GeneChangedPacket> TYPE = new CustomPacketPayload.Type(OtherUtil.INSTANCE.modResource("gene_changed"));
    @NotNull
    private static final StreamCodec<ByteBuf, GeneChangedPacket> STREAM_CODEC;

    public GeneChangedPacket(int entityId, @NotNull ResourceLocation geneRl, boolean wasAdded) {
        Intrinsics.checkNotNullParameter((Object)geneRl, (String)"geneRl");
        this.entityId = entityId;
        this.geneRl = geneRl;
        this.wasAdded = wasAdded;
    }

    public final int getEntityId() {
        return this.entityId;
    }

    @NotNull
    public final ResourceLocation getGeneRl() {
        return this.geneRl;
    }

    public final boolean getWasAdded() {
        return this.wasAdded;
    }

    @NotNull
    public CustomPacketPayload.Type<GeneChangedPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context.flow() == PacketFlow.CLIENTBOUND)) {
            boolean $i$a$-require-GeneChangedPacket$receiveMessage$22 = false;
            String $i$a$-require-GeneChangedPacket$receiveMessage$22 = "Received GeneChangedPacket on wrong side!";
            throw new IllegalArgumentException($i$a$-require-GeneChangedPacket$receiveMessage$22.toString());
        }
        Entity entity = context.player().level().getEntity(this.entityId);
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
        Intrinsics.checkNotNull((Object)registryAccess);
        Holder.Reference<Gene> reference = ModGenes.INSTANCE.fromResourceLocation((HolderLookup.Provider)registryAccess, this.geneRl);
        if (reference == null) {
            throw new IllegalStateException("Received GeneChangedPacket with invalid gene id!");
        }
        Holder.Reference<Gene> geneHolder = reference;
        boolean bl = this.wasAdded ? GenesData.Companion.addGene(entity2, (Holder<Gene>)((Holder)geneHolder)) : GenesData.Companion.removeGene(entity2, (Holder<Gene>)((Holder)geneHolder));
        if (Gene.Companion.isGene((Holder<Gene>)((Holder)geneHolder), ModGenes.INSTANCE.getCRINGE())) {
            ClientUtil.handleCringe$default(ClientUtil.INSTANCE, this.wasAdded, 0, 2, null);
        }
        ((Gene)geneHolder.value()).setAttributeModifiers(entity2, this.wasAdded);
    }

    public final int component1() {
        return this.entityId;
    }

    @NotNull
    public final ResourceLocation component2() {
        return this.geneRl;
    }

    public final boolean component3() {
        return this.wasAdded;
    }

    @NotNull
    public final GeneChangedPacket copy(int entityId, @NotNull ResourceLocation geneRl, boolean wasAdded) {
        Intrinsics.checkNotNullParameter((Object)geneRl, (String)"geneRl");
        return new GeneChangedPacket(entityId, geneRl, wasAdded);
    }

    public static /* synthetic */ GeneChangedPacket copy$default(GeneChangedPacket geneChangedPacket, int n, ResourceLocation resourceLocation, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = geneChangedPacket.entityId;
        }
        if ((n2 & 2) != 0) {
            resourceLocation = geneChangedPacket.geneRl;
        }
        if ((n2 & 4) != 0) {
            bl = geneChangedPacket.wasAdded;
        }
        return geneChangedPacket.copy(n, resourceLocation, bl);
    }

    @NotNull
    public String toString() {
        return "GeneChangedPacket(entityId=" + this.entityId + ", geneRl=" + this.geneRl + ", wasAdded=" + this.wasAdded + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.entityId);
        result = result * 31 + this.geneRl.hashCode();
        result = result * 31 + Boolean.hashCode(this.wasAdded);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneChangedPacket)) {
            return false;
        }
        GeneChangedPacket geneChangedPacket = (GeneChangedPacket)other;
        if (this.entityId != geneChangedPacket.entityId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.geneRl, (Object)geneChangedPacket.geneRl)) {
            return false;
        }
        return this.wasAdded == geneChangedPacket.wasAdded;
    }

    private static final Integer STREAM_CODEC$lambda$1(KProperty1 $tmp0, GeneChangedPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResourceLocation STREAM_CODEC$lambda$2(KProperty1 $tmp0, GeneChangedPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean STREAM_CODEC$lambda$3(KProperty1 $tmp0, GeneChangedPacket p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ResourceLocation.STREAM_CODEC, arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), GeneChangedPacket::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket$Companion;", "", "<init>", "()V", "TYPE", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket;", "getTYPE", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<GeneChangedPacket> getTYPE() {
            return TYPE;
        }

        @NotNull
        public final StreamCodec<ByteBuf, GeneChangedPacket> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

