/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.packet;

import dev.aaronhowser.mods.geneticsresequenced.packet.ModPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.client_to_server.FireballPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.client_to_server.TeleportPlayerPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.GeneChangedPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.NarratorPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.ShearedPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/packet/ModPacketHandler;", "", "<init>", "()V", "registerPayloads", "", "event", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "messageNearbyPlayers", "packet", "Ldev/aaronhowser/mods/geneticsresequenced/packet/ModPacket;", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "origin", "Lnet/minecraft/world/phys/Vec3;", "radius", "", "messagePlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "messageAllPlayers", "messageServer", "geneticsresequenced-1.21.1"})
public final class ModPacketHandler {
    @NotNull
    public static final ModPacketHandler INSTANCE = new ModPacketHandler();

    private ModPacketHandler() {
    }

    public final void registerPayloads(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(GeneChangedPacket.Companion.getTYPE(), GeneChangedPacket.Companion.getSTREAM_CODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ModPacketHandler::registerPayloads$lambda$0, ModPacketHandler::registerPayloads$lambda$1));
        registrar.playToClient(NarratorPacket.Companion.getTYPE(), NarratorPacket.Companion.getSTREAM_CODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ModPacketHandler::registerPayloads$lambda$2, ModPacketHandler::registerPayloads$lambda$3));
        registrar.playToClient(ShearedPacket.Companion.getTYPE(), ShearedPacket.Companion.getSTREAM_CODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ModPacketHandler::registerPayloads$lambda$4, ModPacketHandler::registerPayloads$lambda$5));
        registrar.playToServer(FireballPacket.Companion.getTYPE(), FireballPacket.Companion.getSTREAM_CODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ModPacketHandler::registerPayloads$lambda$6, ModPacketHandler::registerPayloads$lambda$7));
        registrar.playToServer(TeleportPlayerPacket.Companion.getTYPE(), TeleportPlayerPacket.Companion.getSTREAM_CODEC(), (IPayloadHandler)new DirectionalPayloadHandler(ModPacketHandler::registerPayloads$lambda$8, ModPacketHandler::registerPayloads$lambda$9));
    }

    public final void messageNearbyPlayers(@NotNull ModPacket packet, @NotNull ServerLevel serverLevel, @NotNull Vec3 origin, double radius) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        for (ServerPlayer player : serverLevel.players()) {
            double distance = player.distanceToSqr(origin.x(), origin.y(), origin.z());
            if (!(distance < radius * radius)) continue;
            Intrinsics.checkNotNull((Object)player);
            this.messagePlayer(player, packet);
        }
    }

    public final void messagePlayer(@NotNull ServerPlayer player, @NotNull ModPacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void messageAllPlayers(@NotNull ModPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void messageServer(@NotNull ModPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static final void registerPayloads$lambda$0(GeneChangedPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$1(GeneChangedPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$2(NarratorPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$3(NarratorPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$4(ShearedPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$5(ShearedPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$6(FireballPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$7(FireballPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$8(TeleportPlayerPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }

    private static final void registerPayloads$lambda$9(TeleportPlayerPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveMessage(context);
    }
}

