/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGeneCheckerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneCheckerItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1557#2:49\n1628#2,3:50\n*S KotlinDebug\n*F\n+ 1 GeneCheckerItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem\n*L\n33#1:49\n33#1:50,3\n*E\n"})
public final class GeneCheckerItem
extends Item {
    public GeneCheckerItem() {
        super(new Item.Properties().stacksTo(1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            MutableComponent mutableComponent;
            LivingEntity targetEntity;
            Set<Holder<Gene>> targetGeneHolders;
            Entity entity = OtherUtil.INSTANCE.getLookedAtEntity((LivingEntity)player);
            LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity == null) {
                livingEntity = (LivingEntity)player;
            }
            if ((targetGeneHolders = GenesData.Companion.getGeneHolders(targetEntity = livingEntity)).isEmpty()) {
                if (Intrinsics.areEqual((Object)targetEntity, (Object)player)) {
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.no_genes", new Object[0]);
                } else {
                    Object[] objectArray = new Object[]{targetEntity.getName()};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.no_genes", objectArray);
                }
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] objectArray = (Object[])targetGeneHolders;
                OtherUtil otherUtil = OtherUtil.INSTANCE;
                boolean $i$f$map = false;
                void var11_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Holder holder = (Holder)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Gene.Companion.getNameComponent((Holder<Gene>)it));
                }
                MutableComponent genesComponent = otherUtil.componentList((List)destination$iv$iv);
                if (Intrinsics.areEqual((Object)targetEntity, (Object)player)) {
                    objectArray = new Object[]{genesComponent};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.list", objectArray);
                } else {
                    objectArray = new Object[]{targetEntity.getName(), genesComponent};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.list", objectArray);
                }
            }
            MutableComponent component = mutableComponent;
            player.sendSystemMessage((Component)component);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)usedStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }
}

