/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pInteractionTarget", "Lnet/minecraft/world/entity/LivingEntity;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEntityDnaItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityDnaItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n774#2:134\n865#2,2:135\n*S KotlinDebug\n*F\n+ 1 EntityDnaItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem\n*L\n35#1:134\n35#1:135,2\n*E\n"})
public class EntityDnaItem
extends Item {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Set<EntityType<? extends LivingEntity>> includeTheseEntityTypes;
    @NotNull
    private static final Set<EntityType<?>> validEntityTypes;

    public EntityDnaItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pInteractionTarget, (String)"pInteractionTarget");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        if (!pPlayer.isCreative()) {
            InteractionResult interactionResult = super.interactLivingEntity(pStack, pPlayer, pInteractionTarget, pUsedHand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
            return interactionResult;
        }
        ItemStack newStack = pStack.copy();
        Intrinsics.checkNotNull((Object)newStack);
        EntityType entityType = pInteractionTarget.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        boolean setWorked = Companion.setEntityType(newStack, entityType);
        if (!setWorked) {
            pPlayer.displayClientMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cant_set_entity", new Object[0]), true);
            return InteractionResult.PASS;
        }
        pPlayer.setItemInHand(pUsedHand, newStack);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        MutableComponent component;
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        EntityType<?> entityType = Companion.getEntityType(pStack);
        if (entityType != null) {
            Object[] objectArray = new Object[]{entityType.getDescription()};
            component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.dna_item.filled", objectArray).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNull((Object)component);
            v0 = pTooltipComponents.add((Component)component);
        } else {
            component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.dna_item.empty", new Object[0]).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNull((Object)component);
            v0 = pTooltipComponents.add((Component)component);
        }
        try {
            if (ClientUtil.INSTANCE.playerIsCreative()) {
                component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.dna_item.creative", new Object[0]).withStyle(ChatFormatting.GRAY);
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
        catch (Exception e) {
            GeneticsResequenced.Companion.getLOGGER().error("EntityDnaItem isCreative check failed", (Throwable)e);
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new EntityType[]{EntityType.PLAYER, EntityType.IRON_GOLEM, EntityType.SNOW_GOLEM, EntityType.VILLAGER};
        includeTheseEntityTypes = SetsKt.mutableSetOf((Object[])objectArray);
        DefaultedRegistry defaultedRegistry = BuiltInRegistries.ENTITY_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"ENTITY_TYPE");
        Iterable $this$filter$iv = (Iterable)defaultedRegistry;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EntityType it = (EntityType)element$iv$iv;
            boolean bl = false;
            if (!(it.getCategory() != MobCategory.MISC || CollectionsKt.contains((Iterable)includeTheseEntityTypes, (Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        validEntityTypes = CollectionsKt.toMutableSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0012\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0013\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0006J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010R?\u0010\u0004\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem$Companion;", "", "<init>", "()V", "includeTheseEntityTypes", "", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/LivingEntity;", "kotlin.jvm.PlatformType", "getIncludeTheseEntityTypes", "()Ljava/util/Set;", "validEntityTypes", "getValidEntityTypes", "setEntityType", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "entityType", "getOrganicStack", "getCell", "hasEntity", "getEntityType", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<EntityType<? extends LivingEntity>> getIncludeTheseEntityTypes() {
            return includeTheseEntityTypes;
        }

        @NotNull
        public final Set<EntityType<?>> getValidEntityTypes() {
            return validEntityTypes;
        }

        public final boolean setEntityType(@NotNull ItemStack itemStack, @NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            if (!this.getValidEntityTypes().contains(entityType)) {
                return false;
            }
            itemStack.set((Supplier)ModDataComponents.INSTANCE.getENTITY_TYPE_COMPONENT(), entityType);
            return true;
        }

        @NotNull
        public final ItemStack getOrganicStack(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            ItemStack itemStack = ModItems.INSTANCE.getORGANIC_MATTER().toStack();
            Intrinsics.checkNotNull((Object)itemStack);
            this.setEntityType(itemStack, entityType);
            return itemStack;
        }

        @NotNull
        public final ItemStack getCell(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            ItemStack itemStack = ModItems.INSTANCE.getCELL().toStack();
            Intrinsics.checkNotNull((Object)itemStack);
            this.setEntityType(itemStack, entityType);
            return itemStack;
        }

        public final boolean hasEntity(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return itemStack.has((Supplier)ModDataComponents.INSTANCE.getENTITY_TYPE_COMPONENT());
        }

        @Nullable
        public final EntityType<?> getEntityType(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return (EntityType)itemStack.get((Supplier)ModDataComponents.INSTANCE.getENTITY_TYPE_COMPONENT());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

