/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem;", "Ldev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem;", "<init>", "()V", "appendHoverText", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "showNoGeneTooltips", "Companion", "geneticsresequenced-1.21.1"})
public final class DnaHelixItem
extends EntityDnaItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        Holder<Gene> geneHolder = Companion.getGeneHolder(pStack);
        if (geneHolder == null) {
            this.showNoGeneTooltips(pStack, pTooltipComponents);
        } else {
            Object[] objectArray = new Object[]{Gene.Companion.getNameComponent(geneHolder)};
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
        }
    }

    private final void showNoGeneTooltips(ItemStack pStack, List<Component> pTooltipComponents) {
        Object[] objectArray = new Object[]{Gene.Companion.getUnknownGeneComponent()};
        MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        pTooltipComponents.add((Component)mutableComponent);
        EntityType<?> entity = EntityDnaItem.Companion.getEntityType(pStack);
        if (entity != null) {
            Object[] objectArray2 = new Object[]{entity.getDescription()};
            MutableComponent mutableComponent2 = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.helix_entity", objectArray2).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent2);
        }
        try {
            boolean isCreative = ClientUtil.INSTANCE.playerIsCreative();
            if (isCreative) {
                MutableComponent component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.dna_item.creative", new Object[0]).withStyle(ChatFormatting.GRAY);
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
        catch (Exception e) {
            GeneticsResequenced.Companion.getLOGGER().error("DnaHelixItem isCreative check failed", (Throwable)e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\r\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion;", "", "<init>", "()V", "hasGene", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getGeneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "setGeneHolder", "geneHolder", "getHelixStack", "geneRk", "Lnet/minecraft/resources/ResourceKey;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getAllHelices", "", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nDnaHelixItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnaHelixItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1557#2:110\n1628#2,3:111\n*S KotlinDebug\n*F\n+ 1 DnaHelixItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion\n*L\n49#1:110\n49#1:111,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return itemStack.has((Supplier)ModDataComponents.INSTANCE.getGENE_COMPONENT());
        }

        @Nullable
        public final Holder<Gene> getGeneHolder(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return (Holder)itemStack.get((Supplier)ModDataComponents.INSTANCE.getGENE_COMPONENT());
        }

        @NotNull
        public final ItemStack setGeneHolder(@NotNull ItemStack itemStack, @NotNull Holder<Gene> geneHolder) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            itemStack.set((Supplier)ModDataComponents.INSTANCE.getGENE_COMPONENT(), geneHolder);
            return itemStack;
        }

        @NotNull
        public final ItemStack getHelixStack(@NotNull ResourceKey<Gene> geneRk, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter(geneRk, (String)"geneRk");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return this.getHelixStack((Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(geneRk, registries)));
        }

        @NotNull
        public final ItemStack getHelixStack(@NotNull Holder<Gene> geneHolder) {
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            ItemStack itemStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
            Intrinsics.checkNotNull((Object)itemStack);
            this.setGeneHolder(itemStack, geneHolder);
            return itemStack;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllHelices(@NotNull HolderLookup.Provider registries) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Iterable $this$map$iv = ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, registries, true, false, 4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void geneHolder;
                Holder holder = (Holder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getHelixStack((Holder<Gene>)geneHolder));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

