/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.block.AntiFieldBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.BioluminescenceBlock;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.item.AntiFieldOrbItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0 H\u0002J\u001c\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\nR4\u0010\u0012\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R,\u0010\u001b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0013\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes;", "", "<init>", "()V", "handleBioluminescence", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "handlePhotosynthesis", "handleNoHunger", "Lnet/minecraft/world/entity/player/Player;", "isDeathGene", "", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "handleTickingGenes", "handleDeathGenes", "virusDamageKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "kotlin.jvm.PlatformType", "Lnet/minecraft/resources/ResourceKey;", "virusDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "mapOfGeneToInferiorGenes", "", "", "handlePotionGenes", "potionGenes", "", "handlePotionGeneRemoved", "removedGene", "recentlyMeated2", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "handleMeaty2", "recentlyLaidEgg", "handleLayEgg", "handleMobSight", "handleItemMagnet", "player", "itemMagnetBlacklistTooltip", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "handleXpMagnet", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTickGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1557#2:350\n1628#2,3:351\n808#2,11:355\n1863#2,2:366\n1#3:354\n*S KotlinDebug\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n*L\n196#1:350\n196#1:351,3\n265#1:355,11\n275#1:366,2\n*E\n"})
public final class TickGenes {
    @NotNull
    public static final TickGenes INSTANCE = new TickGenes();
    private static final ResourceKey<DamageType> virusDamageKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("virus"));
    @NotNull
    private static final Map<ResourceKey<Gene>, List<ResourceKey<Gene>>> mapOfGeneToInferiorGenes;
    @NotNull
    private static final GeneCooldown recentlyMeated2;
    @NotNull
    private static final GeneCooldown recentlyLaidEgg;

    private TickGenes() {
    }

    public final void handleBioluminescence(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getBIOLUMINESCENCE();
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> bioluminescence2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)bioluminescence2))) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getBioluminescenceCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        Level level = entity.level();
        if (level.getBrightness(LightLayer.BLOCK, entity.blockPosition()) > 8) {
            return;
        }
        if (!GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getBIOLUMINESCENCE())) {
            return;
        }
        BlockState headBlock = level.getBlockState(entity.blockPosition().above());
        if (!headBlock.isAir()) {
            return;
        }
        level.setBlockAndUpdate(entity.blockPosition().above(), ((BioluminescenceBlock)((Object)ModBlocks.INSTANCE.getBIOLUMINESCENCE_BLOCK().get())).defaultBlockState());
    }

    public final void handlePhotosynthesis(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getPHOTOSYNTHESIS();
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> photosynthesis2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)photosynthesis2))) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getPhotosynthesisCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getPHOTOSYNTHESIS())) {
            return;
        }
        FoodData foodData = ((Player)entity).getFoodData();
        if (!foodData.needsFood()) {
            return;
        }
        boolean inDirectSunlight = entity.level().canSeeSky(entity.blockPosition());
        boolean isDay = entity.level().isDay();
        if (!inDirectSunlight || !isDay) {
            return;
        }
        Object object2 = ServerConfig.Companion.getPhotosynthesisHungerAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        foodData.eat(((Number)object2).intValue(), (float)((Number)ServerConfig.Companion.getPhotosynthesisSaturationAmount().get()).doubleValue());
    }

    public final void handleNoHunger(@NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getNO_HUNGER();
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> noHunger2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)noHunger2))) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getNoHungerCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((LivingEntity)entity, ModGenes.INSTANCE.getNO_HUNGER())) {
            return;
        }
        FoodData foodData = entity.getFoodData();
        int n2 = foodData.getFoodLevel();
        Object object2 = ServerConfig.Companion.getNoHungerMinimum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int n3 = ((Number)object2).intValue();
        foodData.setFoodLevel(Math.max(n2, n3));
    }

    private final boolean isDeathGene(Holder<Gene> geneHolder) {
        return Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getBLACK_DEATH()) ? true : (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getGREEN_DEATH()) ? true : (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getGRAY_DEATH()) ? true : (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getUN_UNDEATH()) ? true : Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getWHITE_DEATH()))));
    }

    public final void handleTickingGenes(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getPassivesCheckCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!(entity instanceof Mob) && !(entity instanceof Player)) {
            return;
        }
        Set<Holder<Gene>> geneHolders = GenesData.Companion.getGeneHolders(entity);
        List potionGenes = new ArrayList();
        for (Holder<Gene> geneHolder : geneHolders) {
            if (Gene.Companion.isDisabled(geneHolder)) continue;
            if (((Gene)geneHolder.value()).getPotion() != null) {
                potionGenes.add(geneHolder);
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getWATER_BREATHING())) {
                entity.setAirSupply(entity.getMaxAirSupply());
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getFLAMBE())) {
                entity.setRemainingFireTicks(((Number)ServerConfig.Companion.getPassivesCheckCooldown().get()).intValue() * 2 * 20);
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getLAY_EGG())) {
                this.handleLayEgg(entity);
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getMEATY_TWO())) {
                this.handleMeaty2(entity);
                continue;
            }
            if (!this.isDeathGene(geneHolder)) continue;
            this.handleDeathGenes(entity, geneHolder);
        }
        this.handlePotionGenes(entity, potionGenes);
    }

    private final void handleDeathGenes(LivingEntity entity, Holder<Gene> geneHolder) {
        Function1 function1;
        if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getBLACK_DEATH())) {
            Level level = entity.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            entity.hurt(this.virusDamageSource(level), entity.getMaxHealth() * (float)1000);
            entity.kill();
            if (entity.isAlive()) {
                DamageSources damageSources = entity.level().damageSources();
                entity.hurt(damageSources.fellOutOfWorld(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.magic(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.wither(), entity.getMaxHealth() * (float)1000);
                if (entity.isAlive()) {
                    entity.remove(Entity.RemovalReason.KILLED);
                }
            }
        }
        if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getGREEN_DEATH())) {
            function1 = TickGenes::handleDeathGenes$lambda$0;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getUN_UNDEATH())) {
            function1 = TickGenes::handleDeathGenes$lambda$1;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getGRAY_DEATH())) {
            function1 = TickGenes::handleDeathGenes$lambda$2;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.INSTANCE.getWHITE_DEATH())) {
            function1 = TickGenes::handleDeathGenes$lambda$3;
        } else {
            return;
        }
        Function1 entityPredicate = function1;
        if (!((Boolean)entityPredicate.invoke((Object)entity)).booleanValue()) {
            return;
        }
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        entity.hurt(this.virusDamageSource(level), Math.max(entity.getHealth() / (float)2, 2.0f));
    }

    private final DamageSource virusDamageSource(Level level) {
        DamageSource damageSource = level.damageSources().source(virusDamageKey);
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
        return damageSource;
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePotionGenes(LivingEntity entity, List<Holder<Gene>> potionGenes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (potionGenes.isEmpty()) {
            return;
        }
        List genesToSkip = new ArrayList();
        for (Holder geneHolder : CollectionsKt.toList((Iterable)potionGenes)) {
            List<ResourceKey<Gene>> redundantGenes;
            if (mapOfGeneToInferiorGenes.get(geneHolder.getKey()) == null) continue;
            boolean bl = false;
            genesToSkip.addAll((Collection)redundantGenes);
        }
        Iterator<Holder<Gene>> iterator = genesToSkip;
        List<Holder<Gene>> list = potionGenes;
        boolean $i$f$map = false;
        void var6_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceKey resourceKey = (ResourceKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RegistryAccess registryAccess = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            collection.add(ModGenes.INSTANCE.getHolderOrThrow((ResourceKey<Gene>)it, (HolderLookup.Provider)registryAccess));
        }
        list.removeAll((List)destination$iv$iv);
        for (Holder<Gene> geneHolder : potionGenes) {
            MobEffectInstance potion;
            if (((Gene)geneHolder.value()).getPotion() == null) continue;
            entity.removeEffect(potion.getEffect());
            entity.addEffect(potion);
        }
    }

    public final void handlePotionGeneRemoved(@NotNull LivingEntity entity, @NotNull Holder<Gene> removedGene) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(removedGene, (String)"removedGene");
        MobEffectInstance mobEffectInstance = ((Gene)removedGene.value()).getPotion();
        if (mobEffectInstance == null) {
            return;
        }
        MobEffectInstance potion = mobEffectInstance;
        entity.removeEffect(potion.getEffect());
    }

    private final void handleMeaty2(LivingEntity entity) {
        Object v1;
        block2: {
            boolean newlyMeated = recentlyMeated2.add(entity);
            if (!newlyMeated) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck2 = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity meatEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.COOKED_PORKCHOP, 1 + luck2));
        entity.level().addFreshEntity((Entity)meatEntity);
    }

    private final void handleLayEgg(LivingEntity entity) {
        Object v1;
        block2: {
            boolean hasNotRecentlyLainEgg = recentlyLaidEgg.add(entity);
            if (!hasNotRecentlyLainEgg) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck2 = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity eggEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.EGG, 1 + luck2));
        entity.level().addFreshEntity((Entity)eggEntity);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleMobSight(@NotNull Player entity) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMOB_SIGHT();
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> mobSight2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)mobSight2))) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getMobSightCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((LivingEntity)entity, ModGenes.INSTANCE.getMOB_SIGHT())) {
            return;
        }
        AABB aABB = entity.getBoundingBox();
        Object object2 = ServerConfig.Companion.getMobSightRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        AABB searchArea = aABB.inflate(((Number)object2).doubleValue());
        List list = entity.level().getEntities((Entity)entity, searchArea);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Mob)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nearbyLivingEntities = (List)destination$iv$iv;
        MobEffectInstance glowingEffect = new MobEffectInstance(MobEffects.GLOWING, Math.max(((Number)ServerConfig.Companion.getMobSightCooldown().get()).intValue() * 4, 600), 0, false, false);
        Iterable $this$forEach$iv = nearbyLivingEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            it.addEffect(glowingEffect);
        }
    }

    public final void handleItemMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getITEM_MAGNET();
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> itemMagnet = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)itemMagnet))) {
            return;
        }
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getItemMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getITEM_MAGNET())) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object2 = ServerConfig.Companion.getItemMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, aABB.inflate(((Number)object2).doubleValue()));
        for (ItemEntity itemEntity : nearbyItems) {
            if (itemEntity.getItem().getCount() <= 0 || Intrinsics.areEqual((Object)itemEntity.getOwner(), (Object)player) && itemEntity.getAge() < 60 || itemEntity.getItem().is(ModItemTagsProvider.Companion.getMAGNET_ITEM_BLACKLIST())) continue;
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = itemEntity.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            itemEntity.playerTouch(player);
        }
    }

    public final void itemMagnetBlacklistTooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Boolean)ClientConfig.Companion.getItemMagnetBlacklistTooltip().get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (!GenesData.Companion.hasGene((LivingEntity)player2, ModGenes.INSTANCE.getITEM_MAGNET())) {
            return;
        }
        ItemStack item = event.getItemStack();
        if (!item.is(ModItemTagsProvider.Companion.getMAGNET_ITEM_BLACKLIST())) {
            return;
        }
        MutableComponent component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.item_magnet_blacklist", new Object[0]).withStyle(ChatFormatting.DARK_GRAY);
        event.getToolTip().add(component);
    }

    public final void handleXpMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getXP_MAGNET();
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> xpMagnet = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)xpMagnet))) {
            return;
        }
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getXpMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getXP_MAGNET())) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object2 = ServerConfig.Companion.getXpMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List nearbyXpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, aABB.inflate(((Number)object2).doubleValue()));
        for (ExperienceOrb xpOrb : nearbyXpOrbs) {
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = xpOrb.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            xpOrb.playerTouch(player);
            player.takeXpDelay = 1;
        }
    }

    private static final boolean handleDeathGenes$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof Creeper;
    }

    private static final boolean handleDeathGenes$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().is(EntityTypeTags.UNDEAD);
    }

    private static final boolean handleDeathGenes$lambda$2(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AgeableMob || it instanceof Zombie || it instanceof Piglin;
    }

    private static final boolean handleDeathGenes$lambda$3(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().getCategory() == MobCategory.MONSTER;
    }

    static {
        Pair[] pairArray = new Pair[9];
        Object[] objectArray = new ResourceKey[]{ModGenes.INSTANCE.getSPEED(), ModGenes.INSTANCE.getSPEED_TWO()};
        pairArray[0] = TuplesKt.to(ModGenes.INSTANCE.getSPEED_FOUR(), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[1] = TuplesKt.to(ModGenes.INSTANCE.getSPEED_TWO(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getSPEED()));
        pairArray[2] = TuplesKt.to(ModGenes.INSTANCE.getREGENERATION_FOUR(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getREGENERATION()));
        pairArray[3] = TuplesKt.to(ModGenes.INSTANCE.getHASTE_TWO(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getHASTE()));
        pairArray[4] = TuplesKt.to(ModGenes.INSTANCE.getRESISTANCE_TWO(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getRESISTANCE()));
        pairArray[5] = TuplesKt.to(ModGenes.INSTANCE.getSTRENGTH_TWO(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getSTRENGTH()));
        pairArray[6] = TuplesKt.to(ModGenes.INSTANCE.getPOISON_FOUR(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getPOISON()));
        pairArray[7] = TuplesKt.to(ModGenes.INSTANCE.getSLOWNESS_FOUR(), (Object)CollectionsKt.listOf(ModGenes.INSTANCE.getSLOWNESS()));
        objectArray = new ResourceKey[]{ModGenes.INSTANCE.getSLOWNESS(), ModGenes.INSTANCE.getSLOWNESS_FOUR()};
        pairArray[8] = TuplesKt.to(ModGenes.INSTANCE.getSLOWNESS_SIX(), (Object)CollectionsKt.listOf((Object[])objectArray));
        mapOfGeneToInferiorGenes = MapsKt.mapOf((Pair[])pairArray);
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMEATY_TWO();
        Object object = ServerConfig.Companion.getMeaty2Cooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        recentlyMeated2 = new GeneCooldown(resourceKey, ((Number)object).intValue(), false);
        ResourceKey<Gene> resourceKey2 = ModGenes.INSTANCE.getLAY_EGG();
        Object object2 = ServerConfig.Companion.getEggCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        recentlyLaidEgg = new GeneCooldown(resourceKey2, ((Number)object2).intValue(), false);
    }
}

