/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModEffects;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/DamageGenes;", "", "<init>", "()V", "handleNoFallDamage", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "handleWitherProof", "handleFireProof", "handlePoisonProof", "handleDragonHealth", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "handleJohnny", "handleWitherHit", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "handleThorns", "handleClaws", "handleChilling", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDamageGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DamageGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/DamageGenes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class DamageGenes {
    @NotNull
    public static final DamageGenes INSTANCE = new DamageGenes();

    private DamageGenes() {
    }

    public final void handleNoFallDamage(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getNO_FALL_DAMAGE();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> noFallDamage2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)noFallDamage2))) {
            return;
        }
        if (!event.getSource().is(DamageTypes.FALL)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getNO_FALL_DAMAGE())) {
            event.setAmount(0.0f);
        }
    }

    public final void handleWitherProof(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getWITHER_PROOF();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> witherProof2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)witherProof2))) {
            return;
        }
        if (!event.getSource().is(DamageTypes.WITHER)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getWITHER_PROOF())) {
            entity.removeEffect(MobEffects.WITHER);
            event.setAmount(0.0f);
        }
    }

    public final void handleFireProof(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getFIRE_PROOF();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> fireProof2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)fireProof2))) {
            return;
        }
        if (!event.getSource().is(DamageTypes.IN_FIRE) && !event.getSource().is(DamageTypes.ON_FIRE)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getFIRE_PROOF())) {
            entity.clearFire();
            event.setAmount(0.0f);
        }
    }

    public final void handlePoisonProof(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getPOISON_IMMUNITY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> poisonImmunity2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)poisonImmunity2))) {
            return;
        }
        if (!event.getSource().is(NeoForgeMod.POISON_DAMAGE)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getPOISON_IMMUNITY())) {
            entity.removeEffect(MobEffects.POISON);
            event.setAmount(0.0f);
        }
    }

    public final void handleDragonHealth(@NotNull LivingDamageEvent.Pre event) {
        Object v4;
        LivingEntity entity;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getENDER_DRAGON_HEALTH();
            RegistryAccess registryAccess = event.getEntity().registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Holder.Reference<Gene> enderDragonHealth2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
            if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)enderDragonHealth2))) {
                return;
            }
            if (event.getContainer().getNewDamage() == 0.0f) {
                return;
            }
            entity = event.getEntity();
            if (entity.level().isClientSide) {
                return;
            }
            Intrinsics.checkNotNull((Object)entity);
            if (!GenesData.Companion.hasGene(entity, ModGenes.INSTANCE.getENDER_DRAGON_HEALTH())) {
                return;
            }
            Iterable iterable = entity.getHandSlots();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
            List items = CollectionsKt.toMutableList((Iterable)iterable);
            if (entity instanceof Player) {
                Collection collection = items;
                NonNullList nonNullList = ((Player)entity).getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)nonNullList));
            }
            Iterable iterable2 = items;
            for (Object t : iterable2) {
                ItemStack it = (ItemStack)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getItem(), ModItems.INSTANCE.getDRAGON_HEALTH_CRYSTAL())) continue;
                v4 = t;
                break block8;
            }
            v4 = null;
        }
        ItemStack itemStack = v4;
        if (itemStack == null) {
            return;
        }
        ItemStack healthCrystal = itemStack;
        int amountDamaged = Mth.ceil((float)event.getContainer().getNewDamage());
        int crystalDurabilityRemaining = healthCrystal.getMaxDamage() - healthCrystal.getDamageValue();
        int amountToBlock = Math.min(amountDamaged, crystalDurabilityRemaining);
        healthCrystal.hurtAndBreak(amountToBlock, entity, entity.getEquipmentSlotForItem(healthCrystal));
        DamageContainer damageContainer = event.getContainer();
        damageContainer.setNewDamage(damageContainer.getNewDamage() - (float)amountToBlock);
        if (event.getContainer().getNewDamage() < 0.0f) {
            event.getContainer().setNewDamage(0.0f);
        }
    }

    public final void handleJohnny(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getJOHNNY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> johnny2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)johnny2))) {
            return;
        }
        Entity entity = event.getContainer().getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!GenesData.Companion.hasGene(attacker, ModGenes.INSTANCE.getJOHNNY())) {
            return;
        }
        boolean weaponIsAxe = attacker.getMainHandItem().getItem() instanceof AxeItem;
        if (!weaponIsAxe) {
            return;
        }
        entity = event.getContainer();
        entity.setNewDamage(entity.getNewDamage() * (float)((Number)ServerConfig.Companion.getJohnnyAttackMultiplier().get()).doubleValue());
    }

    public final void handleWitherHit(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getWITHER_HIT();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> witherHit2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)witherHit2))) {
            return;
        }
        if (!event.getSource().isDirect()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (Intrinsics.areEqual((Object)attacker, (Object)victim)) {
            return;
        }
        if (!GenesData.Companion.hasGene(attacker, ModGenes.INSTANCE.getWITHER_HIT())) {
            return;
        }
        MobEffectInstance witherEffect = new MobEffectInstance(MobEffects.WITHER, 100);
        victim.addEffect(witherEffect);
    }

    public final void handleThorns(@NotNull LivingDamageEvent.Post event) {
        boolean targetChestplateMissingOrLeather;
        LivingEntity livingEntity;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getTHORNS();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> thorns2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)thorns2))) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity2 = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity2 == null) {
            return;
        }
        LivingEntity attacker = livingEntity2;
        LivingEntity livingEntity3 = event.getEntity();
        Mob mob = livingEntity3 instanceof Mob ? (Mob)livingEntity3 : null;
        if (mob != null) {
            livingEntity = (LivingEntity)mob;
        } else {
            LivingEntity livingEntity4 = event.getEntity();
            Player player = livingEntity4 instanceof Player ? (Player)livingEntity4 : null;
            if (player != null) {
                livingEntity = (LivingEntity)player;
            } else {
                return;
            }
        }
        LivingEntity target = livingEntity;
        if (Intrinsics.areEqual((Object)target, (Object)attacker)) {
            return;
        }
        ItemStack chestPlate = target.getItemBySlot(EquipmentSlot.CHEST);
        boolean bl = targetChestplateMissingOrLeather = chestPlate.isEmpty() || chestPlate.is(Items.LEATHER_CHESTPLATE);
        if (!targetChestplateMissingOrLeather) {
            return;
        }
        if (!GenesData.Companion.hasGene(target, ModGenes.INSTANCE.getTHORNS())) {
            return;
        }
        if (Random.Default.nextDouble() > ((Number)ServerConfig.Companion.getThornsChance().get()).doubleValue()) {
            return;
        }
        DamageSource thornsDamageSource = target.level().damageSources().thorns((Entity)target);
        attacker.hurt(thornsDamageSource, (float)((Number)ServerConfig.Companion.getThornsDamage().get()).doubleValue());
        if (target instanceof Player) {
            ((Player)target).causeFoodExhaustion((float)((Number)ServerConfig.Companion.getThornsHungerDrain().get()).doubleValue());
        }
    }

    public final void handleClaws(@NotNull LivingDamageEvent.Post event) {
        int n;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getCLAWS();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> claws2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)claws2))) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!attacker.getMainHandItem().isEmpty()) {
            return;
        }
        ResourceKey<Gene> resourceKey2 = ModGenes.INSTANCE.getCLAWS_TWO();
        RegistryAccess registryAccess2 = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess2, (String)"registryAccess(...)");
        Holder.Reference<Gene> clawsTwo = ModGenes.INSTANCE.getHolderOrThrow(resourceKey2, (HolderLookup.Provider)registryAccess2);
        if (!Gene.Companion.isDisabled((Holder<Gene>)((Holder)clawsTwo)) && GenesData.Companion.hasGene(attacker, ModGenes.INSTANCE.getCLAWS_TWO())) {
            n = 2;
        } else if (GenesData.Companion.hasGene(attacker, ModGenes.INSTANCE.getCLAWS())) {
            n = 1;
        } else {
            return;
        }
        int clawsLevel = n;
        double chanceOfHappening = ((Number)ServerConfig.Companion.getClawsChance().get()).doubleValue() * (double)clawsLevel;
        if (Random.Default.nextDouble() > chanceOfHappening) {
            return;
        }
        event.getEntity().addEffect(new MobEffectInstance((Holder)ModEffects.INSTANCE.getBLEED(), 100, 0, false, true, true), (Entity)attacker);
    }

    public final void handleChilling(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getCHILLING();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> chilling2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)chilling2))) {
            return;
        }
        if (!event.getSource().isDirect()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!GenesData.Companion.hasGene(attacker, ModGenes.INSTANCE.getCHILLING())) {
            return;
        }
        if (Random.Default.nextDouble() > ((Number)ServerConfig.Companion.getChillChance().get()).doubleValue()) {
            return;
        }
        LivingEntity target = event.getEntity();
        target.setTicksFrozen(((Number)ServerConfig.Companion.getChillDuration().get()).intValue());
    }
}

