/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.advancement.AdvancementTriggers;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.packet.ModPacketHandler;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.ShearedPacket;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/ClickGenes;", "", "<init>", "()V", "recentlySheered", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "getRecentlySheered", "()Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "handleWooly", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$EntityInteract;", "recentlyMeated", "getRecentlyMeated", "handleMeaty", "recentlyMilked", "getRecentlyMilked", "handleMilky", "milkyItem", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickItem;", "woolyItem", "meatyItem", "shootFireball", "eatGrass", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "cureCringe", "handleInfinityGetProjectile", "Lnet/neoforged/neoforge/event/entity/living/LivingGetProjectileEvent;", "handleInfinityArrow", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "geneticsresequenced-1.21.1"})
public final class ClickGenes {
    @NotNull
    public static final ClickGenes INSTANCE = new ClickGenes();
    @NotNull
    private static final GeneCooldown recentlySheered;
    @NotNull
    private static final GeneCooldown recentlyMeated;
    @NotNull
    private static final GeneCooldown recentlyMilked;

    private ClickGenes() {
    }

    @NotNull
    public final GeneCooldown getRecentlySheered() {
        return recentlySheered;
    }

    public final void handleWooly(@NotNull PlayerInteractEvent.EntityInteract event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getWOOLY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> wooly2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)wooly2))) {
            return;
        }
        Entity entity = event.getTarget();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        Player clicker = event.getEntity();
        if (target.level().isClientSide) {
            return;
        }
        entity = target;
        if (entity instanceof Sheep || entity instanceof MushroomCow) {
            return;
        }
        if (!GenesData.Companion.hasGene(target, ModGenes.INSTANCE.getWOOLY())) {
            return;
        }
        boolean clickedWithShears = event.getItemStack().is(Tags.Items.TOOLS_SHEAR);
        if (!clickedWithShears) {
            return;
        }
        boolean newlySheared = recentlySheered.add(target);
        if (!newlySheared) {
            clicker.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.wooly.recent", new Object[0]));
            return;
        }
        ItemStack woolItemStack = new ItemStack((ItemLike)Blocks.WHITE_WOOL);
        ItemEntity woolEntity = new ItemEntity(event.getLevel(), target.getEyePosition().x, target.getEyePosition().y, target.getEyePosition().z, woolItemStack);
        event.getLevel().addFreshEntity((Entity)woolEntity);
        woolEntity.setDeltaMovement(Random.Default.nextDouble(-0.05, 0.05), Random.Default.nextDouble(0.05, 0.1), Random.Default.nextDouble(-0.05, 0.05));
        event.getItemStack().hurtAndBreak(1, (LivingEntity)clicker, clicker.getEquipmentSlotForItem(event.getItemStack()));
        event.getLevel().playSound(null, (Entity)target, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (target instanceof ServerPlayer) {
            ModPacketHandler.INSTANCE.messagePlayer((ServerPlayer)target, new ShearedPacket(true));
        }
    }

    @NotNull
    public final GeneCooldown getRecentlyMeated() {
        return recentlyMeated;
    }

    public final void handleMeaty(@NotNull PlayerInteractEvent.EntityInteract event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMEATY();
        RegistryAccess registryAccess = event.getLevel().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> meaty2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)meaty2))) {
            return;
        }
        Entity entity = event.getTarget();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        Player clicker = event.getEntity();
        if (target.level().isClientSide) {
            return;
        }
        if (!GenesData.Companion.hasGene(target, ModGenes.INSTANCE.getMEATY())) {
            return;
        }
        boolean clickedWithShears = event.getItemStack().is(Tags.Items.TOOLS_SHEAR);
        if (!clickedWithShears) {
            return;
        }
        boolean newlyMeated = recentlyMeated.add(target);
        if (!newlyMeated) {
            clicker.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.meaty.recent", new Object[0]));
            return;
        }
        ItemEntity porkEntity = new ItemEntity(event.getLevel(), target.getEyePosition().x, target.getEyePosition().y, target.getEyePosition().z, new ItemStack((ItemLike)Items.PORKCHOP));
        event.getLevel().addFreshEntity((Entity)porkEntity);
        porkEntity.setDeltaMovement(Random.Default.nextDouble(-0.05, 0.05), Random.Default.nextDouble(0.05, 0.1), Random.Default.nextDouble(-0.05, 0.05));
        event.getItemStack().hurtAndBreak(1, (LivingEntity)clicker, clicker.getEquipmentSlotForItem(event.getItemStack()));
        event.getLevel().playSound(null, (Entity)target, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @NotNull
    public final GeneCooldown getRecentlyMilked() {
        return recentlyMilked;
    }

    public final void handleMilky(@NotNull PlayerInteractEvent.EntityInteract event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMILKY();
        RegistryAccess registryAccess = event.getLevel().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> milky2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)milky2))) {
            return;
        }
        Entity entity = event.getTarget();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        if (target.level().isClientSide) {
            return;
        }
        LivingEntity livingEntity2 = target;
        if (livingEntity2 instanceof Cow || livingEntity2 instanceof Goat) {
            return;
        }
        if (!GenesData.Companion.hasGene(target, ModGenes.INSTANCE.getMILKY())) {
            return;
        }
        boolean clickedWithBucket = event.getItemStack().is(Items.BUCKET);
        if (!clickedWithBucket) {
            return;
        }
        boolean newlyMilked = recentlyMilked.add(target);
        Player clicker = event.getEntity();
        if (!newlyMilked) {
            clicker.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.milk.recent", new Object[0]));
            return;
        }
        target.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.milk.milked", new Object[0]));
        event.getItemStack().shrink(1);
        clicker.addItem(new ItemStack((ItemLike)Items.MILK_BUCKET));
        SoundEvent sound = target instanceof Player && Random.Default.nextFloat() < 0.05f ? SoundEvents.GOAT_SCREAMING_MILK : (Random.Default.nextBoolean() ? SoundEvents.COW_MILK : SoundEvents.GOAT_MILK);
        event.getLevel().playSound(null, (Entity)target, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (target instanceof ServerPlayer) {
            AdvancementTriggers.INSTANCE.getMilkedAdvancement((ServerPlayer)target);
        }
    }

    public final void milkyItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMILKY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> milky2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)milky2))) {
            return;
        }
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!player.isCrouching()) {
            return;
        }
        boolean clickedWithBucket = event.getItemStack().is(Items.BUCKET);
        if (!clickedWithBucket) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getMILKY())) {
            return;
        }
        boolean newlyMilked = recentlyMilked.add((LivingEntity)player);
        if (!newlyMilked) {
            return;
        }
        event.getItemStack().shrink(1);
        player.addItem(new ItemStack((ItemLike)Items.MILK_BUCKET));
        SoundEvent sound = Random.Default.nextFloat() < 0.05f ? SoundEvents.GOAT_SCREAMING_MILK : (Random.Default.nextBoolean() ? SoundEvents.COW_MILK : SoundEvents.GOAT_MILK);
        event.getLevel().playSound(null, (Entity)player, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (player instanceof ServerPlayer) {
            AdvancementTriggers.INSTANCE.getMilkedAdvancement((ServerPlayer)player);
        }
    }

    public final void woolyItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getWOOLY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> wooly2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)wooly2))) {
            return;
        }
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!player.isCrouching()) {
            return;
        }
        boolean clickedWithShears = event.getItemStack().is(Tags.Items.TOOLS_SHEAR);
        if (!clickedWithShears) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getWOOLY())) {
            return;
        }
        boolean newlySheared = recentlySheered.add((LivingEntity)player);
        if (!newlySheared) {
            return;
        }
        ItemStack woolItemStack = new ItemStack((ItemLike)Blocks.WHITE_WOOL);
        ItemEntity woolEntity = new ItemEntity(event.getLevel(), player.getEyePosition().x, player.getEyePosition().y, player.getEyePosition().z, woolItemStack);
        event.getLevel().addFreshEntity((Entity)woolEntity);
        woolEntity.setDeltaMovement(Random.Default.nextDouble(-0.05, 0.05), Random.Default.nextDouble(0.05, 0.1), Random.Default.nextDouble(-0.05, 0.05));
        event.getItemStack().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(event.getItemStack()));
        event.getLevel().playSound(null, (Entity)player, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
        ModPacketHandler.INSTANCE.messagePlayer((ServerPlayer)player, new ShearedPacket(true));
    }

    public final void meatyItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getMEATY();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> meaty2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)meaty2))) {
            return;
        }
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!player.isCrouching()) {
            return;
        }
        boolean clickedWithShears = event.getItemStack().is(Tags.Items.TOOLS_SHEAR);
        if (!clickedWithShears) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getMEATY())) {
            return;
        }
        boolean newlyMeated = recentlyMeated.add((LivingEntity)player);
        if (!newlyMeated) {
            player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.meaty.recent", new Object[0]));
            return;
        }
        ItemEntity porkEntity = new ItemEntity(event.getLevel(), player.getEyePosition().x, player.getEyePosition().y, player.getEyePosition().z, new ItemStack((ItemLike)Items.PORKCHOP));
        event.getLevel().addFreshEntity((Entity)porkEntity);
        porkEntity.setDeltaMovement(Random.Default.nextDouble(-0.05, 0.05), Random.Default.nextDouble(0.05, 0.1), Random.Default.nextDouble(-0.05, 0.05));
        event.getItemStack().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(event.getItemStack()));
        event.getLevel().playSound(null, (Entity)player, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public final void shootFireball(@NotNull PlayerInteractEvent.RightClickItem event) {
        SmallFireball smallFireball;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getSHOOT_FIREBALLS();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> shootFireballs2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)shootFireballs2))) {
            return;
        }
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getSHOOT_FIREBALLS())) {
            return;
        }
        if (!player.isCrouching()) {
            return;
        }
        if (!event.getItemStack().is(ModItemTagsProvider.Companion.getACTIVATES_SHOOT_FIREBALL_GENE())) {
            return;
        }
        Vec3 lookVec = player.getLookAngle();
        SmallFireball $this$shootFireball_u24lambda_u240 = smallFireball = new SmallFireball(event.getLevel(), (LivingEntity)player, lookVec);
        boolean bl = false;
        $this$shootFireball_u24lambda_u240.setPos($this$shootFireball_u24lambda_u240.getX(), player.getEyeY(), $this$shootFireball_u24lambda_u240.getZ());
        SmallFireball fireball = smallFireball;
        event.getLevel().addFreshEntity((Entity)fireball);
        event.getLevel().playSound(null, (Entity)player, SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.isCreative()) {
            event.getItemStack().shrink(1);
        }
    }

    public final void eatGrass(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Block block;
        boolean isHungry;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getEAT_GRASS();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> eatGrass2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)eatGrass2))) {
            return;
        }
        if (!event.getItemStack().isEmpty()) {
            return;
        }
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getEAT_GRASS())) {
            return;
        }
        boolean bl = isHungry = player.getFoodData().getFoodLevel() < 20;
        if (!isHungry) {
            return;
        }
        Block block2 = event.getLevel().getBlockState(event.getPos()).getBlock();
        Block block3 = block2;
        if (Intrinsics.areEqual((Object)block3, (Object)Blocks.GRASS_BLOCK) || Intrinsics.areEqual((Object)block3, (Object)Blocks.MYCELIUM)) {
            block = Blocks.DIRT;
        } else if (Intrinsics.areEqual((Object)block3, (Object)Blocks.WARPED_NYLIUM) || Intrinsics.areEqual((Object)block3, (Object)Blocks.CRIMSON_NYLIUM)) {
            block = Blocks.NETHERRACK;
        } else {
            return;
        }
        Block blockAfter = block;
        event.getLevel().setBlockAndUpdate(event.getPos(), blockAfter.defaultBlockState());
        player.getFoodData().eat(1, 0.1f);
        event.getLevel().playSound(null, player.blockPosition(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f);
        event.getLevel().playSound(null, event.getPos(), SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (recentlySheered.contains((Object)player.getUUID())) {
            recentlySheered.remove((Object)player.getUUID());
            GeneCooldown.Companion.tellCooldownEnded((LivingEntity)player, ModGenes.INSTANCE.getWOOLY());
        }
    }

    public final void cureCringe(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getLevel().getBlockState(event.getPos()).getBlock(), (Object)Blocks.GRASS_BLOCK)) {
            return;
        }
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getCRINGE())) {
            return;
        }
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getCRINGE();
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> cringe2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        GenesData.Companion.removeGene((LivingEntity)player, (Holder<Gene>)((Holder)cringe2));
        if (!player.level().isClientSide) {
            player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.cringe.cured", new Object[0]));
        }
    }

    public final void handleInfinityGetProjectile(@NotNull LivingGetProjectileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Player player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getINFINITY();
        RegistryAccess registryAccess = player2.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> infinity2 = ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)infinity2))) {
            return;
        }
        if (!GenesData.Companion.hasGene((LivingEntity)player2, ModGenes.INSTANCE.getINFINITY())) {
            return;
        }
        if (!event.getProjectileItemStack().isEmpty()) {
            return;
        }
        Item item = event.getProjectileWeaponItemStack().getItem();
        ProjectileWeaponItem projectileWeaponItem = item instanceof ProjectileWeaponItem ? (ProjectileWeaponItem)item : null;
        if (projectileWeaponItem == null) {
            return;
        }
        ProjectileWeaponItem weapon = projectileWeaponItem;
        ItemStack defaultAmmo = weapon.getDefaultCreativeAmmo(player2, event.getProjectileItemStack());
        defaultAmmo.set((Supplier)ModDataComponents.INSTANCE.getIS_INFINITY_ARROW(), (Object)true);
        event.setProjectileItemStack(defaultAmmo);
    }

    public final void handleInfinityArrow(@NotNull EntityJoinLevelEvent event) {
        boolean isInfinity;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Arrow arrow = entity instanceof Arrow ? (Arrow)entity : null;
        if (arrow == null) {
            return;
        }
        Arrow arrow2 = arrow;
        if (arrow2.level().isClientSide) {
            return;
        }
        ItemStack arrowStack = arrow2.getPickupItemStackOrigin();
        Boolean bl = (Boolean)arrowStack.get((Supplier)ModDataComponents.INSTANCE.getIS_INFINITY_ARROW());
        boolean bl2 = isInfinity = bl != null ? bl : false;
        if (!isInfinity) {
            return;
        }
        arrow2.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    static {
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getWOOLY();
        Object object = ServerConfig.Companion.getWoolyCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        recentlySheered = new GeneCooldown(resourceKey, ((Number)object).intValue(), false, 4, null);
        ResourceKey<Gene> resourceKey2 = ModGenes.INSTANCE.getMEATY();
        Object object2 = ServerConfig.Companion.getMeatyCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        recentlyMeated = new GeneCooldown(resourceKey2, ((Number)object2).intValue(), false, 4, null);
        ResourceKey<Gene> resourceKey3 = ModGenes.INSTANCE.getMILKY();
        Object object3 = ServerConfig.Companion.getMilkyCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        recentlyMilked = new GeneCooldown(resourceKey3, ((Number)object3).intValue(), false, 4, null);
    }
}

