/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.gene.ModGeneProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModGeneTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty1;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u0000 72\u00020\u0001:\u0003567BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0016\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000e0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 J\u0012\u0010!\u001a\u00020\u001b2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006J\b\u0010#\u001a\u0004\u0018\u00010$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001bJ\b\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u0019\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000e0\bH\u00c6\u0003Ja\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000e0\bH\u00c6\u0001J\u0013\u00102\u001a\u00020\u001b2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00068"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "", "dnaPointsRequired", "", "allowedEntities", "Lnet/minecraft/core/HolderSet;", "Lnet/minecraft/world/entity/EntityType;", "potionDetails", "Ljava/util/Optional;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$PotionDetails;", "attributeModifiers", "", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$AttributeEntry;", "scaresEntitiesWithTag", "Lnet/minecraft/tags/TagKey;", "<init>", "(ILnet/minecraft/core/HolderSet;Ljava/util/Optional;Ljava/util/List;Ljava/util/Optional;)V", "getDnaPointsRequired", "()I", "getAllowedEntities", "()Lnet/minecraft/core/HolderSet;", "getPotionDetails", "()Ljava/util/Optional;", "getAttributeModifiers", "()Ljava/util/List;", "getScaresEntitiesWithTag", "allowsMobs", "", "getAllowsMobs", "()Z", "canEntityHave", "entity", "Lnet/minecraft/world/entity/Entity;", "canEntityTypeHave", "entityType", "getPotion", "Lnet/minecraft/world/effect/MobEffectInstance;", "setAttributeModifiers", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "isAdding", "toString", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "AttributeEntry", "PotionDetails", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gene.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/Gene\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1755#2,3:312\n1557#2:315\n1628#2,3:316\n*S KotlinDebug\n*F\n+ 1 Gene.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/Gene\n*L\n111#1:312,3\n118#1:315\n118#1:316,3\n*E\n"})
public final class Gene {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int dnaPointsRequired;
    @NotNull
    private final HolderSet<EntityType<?>> allowedEntities;
    @NotNull
    private final Optional<PotionDetails> potionDetails;
    @NotNull
    private final List<AttributeEntry> attributeModifiers;
    @NotNull
    private final Optional<TagKey<EntityType<?>>> scaresEntitiesWithTag;
    private final boolean allowsMobs;
    @NotNull
    private static final MutableComponent unknownGeneComponent = ModLanguageProvider.Companion.toComponent("gene.geneticsresequenced.unknown", new Object[0]);
    @NotNull
    private static final AnyHolderSet<EntityType<?>> defaultAllowedEntities = new AnyHolderSet(BuiltInRegistries.ENTITY_TYPE.asLookup());
    @NotNull
    private static final Codec<Gene> DIRECT_CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, Gene> DIRECT_STREAM_CODEC;
    @NotNull
    private static final Codec<Holder<Gene>> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Gene>> STREAM_CODEC;
    @NotNull
    private static final Codec<HolderSet<Gene>> HOLDER_SET_CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, HolderSet<Gene>> HOLDER_SET_STREAM_CODEC;

    /*
     * WARNING - void declaration
     */
    public Gene(int dnaPointsRequired, @NotNull HolderSet<EntityType<?>> allowedEntities, @NotNull Optional<PotionDetails> potionDetails, @NotNull List<AttributeEntry> attributeModifiers, @NotNull Optional<TagKey<EntityType<?>>> scaresEntitiesWithTag) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(allowedEntities, (String)"allowedEntities");
            Intrinsics.checkNotNullParameter(potionDetails, (String)"potionDetails");
            Intrinsics.checkNotNullParameter(attributeModifiers, (String)"attributeModifiers");
            Intrinsics.checkNotNullParameter(scaresEntitiesWithTag, (String)"scaresEntitiesWithTag");
            this.dnaPointsRequired = dnaPointsRequired;
            this.allowedEntities = allowedEntities;
            this.potionDetails = potionDetails;
            this.attributeModifiers = attributeModifiers;
            this.scaresEntitiesWithTag = scaresEntitiesWithTag;
            Iterable iterable = (Iterable)this.allowedEntities;
            Gene gene = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Holder it = (Holder)element$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it.value(), (Object)EntityType.PLAYER))) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        gene.allowsMobs = bl = bl2;
    }

    public final int getDnaPointsRequired() {
        return this.dnaPointsRequired;
    }

    @NotNull
    public final HolderSet<EntityType<?>> getAllowedEntities() {
        return this.allowedEntities;
    }

    @NotNull
    public final Optional<PotionDetails> getPotionDetails() {
        return this.potionDetails;
    }

    @NotNull
    public final List<AttributeEntry> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    @NotNull
    public final Optional<TagKey<EntityType<?>>> getScaresEntitiesWithTag() {
        return this.scaresEntitiesWithTag;
    }

    public final boolean getAllowsMobs() {
        return this.allowsMobs;
    }

    public final boolean canEntityHave(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        return this.canEntityTypeHave(entityType);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEntityTypeHave(@NotNull EntityType<?> entityType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Iterable $this$map$iv = (Iterable)this.allowedEntities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Holder holder = (Holder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((EntityType)it.value());
        }
        return ((List)destination$iv$iv).contains(entityType);
    }

    @Nullable
    public final MobEffectInstance getPotion() {
        PotionDetails potionDetails = (PotionDetails)OptionalsKt.getOrNull(this.potionDetails);
        if (potionDetails == null) {
            return null;
        }
        PotionDetails potionDetails2 = potionDetails;
        return new MobEffectInstance(potionDetails2.getEffect(), potionDetails2.getDuration(), potionDetails2.getLevel() - 1, true, false, potionDetails2.getShowIcon());
    }

    public final void setAttributeModifiers(@NotNull LivingEntity livingEntity, boolean isAdding) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        for (AttributeEntry attributeEntry : this.attributeModifiers) {
            Holder<Attribute> attribute = attributeEntry.component1();
            AttributeModifier modifier = attributeEntry.component2();
            AttributeInstance attributeInstance = livingEntity.getAttribute(attribute);
            if (attributeInstance == null) {
                livingEntity.sendSystemMessage((Component)Component.literal((String)("A Gene tried to modify an attribute " + attribute.getKey() + " that you don't have!")));
                GeneticsResequenced.Companion.getLOGGER().error("A Gene tried to modify an attribute " + attribute.getKey() + " that entity " + livingEntity.getName() + " does not have!");
                continue;
            }
            if (isAdding) {
                if (attributeInstance.hasModifier(modifier.id())) continue;
                attributeInstance.addPermanentModifier(modifier);
                continue;
            }
            if (!attributeInstance.hasModifier(modifier.id())) continue;
            attributeInstance.removeModifier(modifier);
        }
    }

    @NotNull
    public String toString() {
        HolderSet<EntityType<?>> holderSet;
        String string = "Gene{" + "dnaPointsRequired=" + this.dnaPointsRequired + ", allowedEntities=" + (Intrinsics.areEqual(holderSet = this.allowedEntities, defaultAllowedEntities) ? "any" : (Intrinsics.areEqual(holderSet, ModGeneProvider.Companion.getNoEntities()) ? "none" : (Intrinsics.areEqual(holderSet, ModGeneProvider.Companion.getOnlyPlayers()) ? "players" : this.allowedEntities))) + ", potionDetails=" + this.potionDetails + ", attributeModifiers=" + this.attributeModifiers + ", scaresEntitiesWithTag=" + this.scaresEntitiesWithTag + "}";
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int component1() {
        return this.dnaPointsRequired;
    }

    @NotNull
    public final HolderSet<EntityType<?>> component2() {
        return this.allowedEntities;
    }

    @NotNull
    public final Optional<PotionDetails> component3() {
        return this.potionDetails;
    }

    @NotNull
    public final List<AttributeEntry> component4() {
        return this.attributeModifiers;
    }

    @NotNull
    public final Optional<TagKey<EntityType<?>>> component5() {
        return this.scaresEntitiesWithTag;
    }

    @NotNull
    public final Gene copy(int dnaPointsRequired, @NotNull HolderSet<EntityType<?>> allowedEntities, @NotNull Optional<PotionDetails> potionDetails, @NotNull List<AttributeEntry> attributeModifiers, @NotNull Optional<TagKey<EntityType<?>>> scaresEntitiesWithTag) {
        Intrinsics.checkNotNullParameter(allowedEntities, (String)"allowedEntities");
        Intrinsics.checkNotNullParameter(potionDetails, (String)"potionDetails");
        Intrinsics.checkNotNullParameter(attributeModifiers, (String)"attributeModifiers");
        Intrinsics.checkNotNullParameter(scaresEntitiesWithTag, (String)"scaresEntitiesWithTag");
        return new Gene(dnaPointsRequired, allowedEntities, potionDetails, attributeModifiers, scaresEntitiesWithTag);
    }

    public static /* synthetic */ Gene copy$default(Gene gene, int n, HolderSet holderSet, Optional optional, List list, Optional optional2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = gene.dnaPointsRequired;
        }
        if ((n2 & 2) != 0) {
            holderSet = gene.allowedEntities;
        }
        if ((n2 & 4) != 0) {
            optional = gene.potionDetails;
        }
        if ((n2 & 8) != 0) {
            list = gene.attributeModifiers;
        }
        if ((n2 & 0x10) != 0) {
            optional2 = gene.scaresEntitiesWithTag;
        }
        return gene.copy(n, holderSet, optional, list, optional2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.dnaPointsRequired);
        result = result * 31 + this.allowedEntities.hashCode();
        result = result * 31 + this.potionDetails.hashCode();
        result = result * 31 + ((Object)this.attributeModifiers).hashCode();
        result = result * 31 + this.scaresEntitiesWithTag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Gene)) {
            return false;
        }
        Gene gene = (Gene)other;
        if (this.dnaPointsRequired != gene.dnaPointsRequired) {
            return false;
        }
        if (!Intrinsics.areEqual(this.allowedEntities, gene.allowedEntities)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.potionDetails, gene.potionDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributeModifiers, gene.attributeModifiers)) {
            return false;
        }
        return Intrinsics.areEqual(this.scaresEntitiesWithTag, gene.scaresEntitiesWithTag);
    }

    private static final Integer DIRECT_CODEC$lambda$7$lambda$2(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final HolderSet DIRECT_CODEC$lambda$7$lambda$3(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HolderSet)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DIRECT_CODEC$lambda$7$lambda$4(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List DIRECT_CODEC$lambda$7$lambda$5(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DIRECT_CODEC$lambda$7$lambda$6(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App DIRECT_CODEC$lambda$7(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("dna_points_required", (Object)1).forGetter(arg_0 -> Gene.DIRECT_CODEC$lambda$7$lambda$2((KProperty1)Companion.DIRECT_CODEC.1.1.INSTANCE, arg_0)), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).optionalFieldOf("allowed_entities", defaultAllowedEntities).forGetter(arg_0 -> Gene.DIRECT_CODEC$lambda$7$lambda$3((KProperty1)Companion.DIRECT_CODEC.1.2.INSTANCE, arg_0)), (App)PotionDetails.Companion.getDIRECT_CODEC().optionalFieldOf("potion_details").forGetter(arg_0 -> Gene.DIRECT_CODEC$lambda$7$lambda$4((KProperty1)Companion.DIRECT_CODEC.1.3.INSTANCE, arg_0)), (App)AttributeEntry.Companion.getDIRECT_CODEC().listOf().optionalFieldOf("attribute_modifiers", (Object)CollectionsKt.emptyList()).forGetter(arg_0 -> Gene.DIRECT_CODEC$lambda$7$lambda$5((KProperty1)Companion.DIRECT_CODEC.1.4.INSTANCE, arg_0)), (App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).optionalFieldOf("scares_entities_with_tag").forGetter(arg_0 -> Gene.DIRECT_CODEC$lambda$7$lambda$6((KProperty1)Companion.DIRECT_CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)instance, Gene::new);
    }

    private static final Integer DIRECT_STREAM_CODEC$lambda$8(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final HolderSet DIRECT_STREAM_CODEC$lambda$9(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HolderSet)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DIRECT_STREAM_CODEC$lambda$10(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List DIRECT_STREAM_CODEC$lambda$11(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DIRECT_STREAM_CODEC$lambda$12(KProperty1 $tmp0, Gene p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Codec codec = RecordCodecBuilder.create(Gene::DIRECT_CODEC$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        DIRECT_CODEC = codec;
        Function<Gene, Integer> function = arg_0 -> Gene.DIRECT_STREAM_CODEC$lambda$8((KProperty1)Companion.DIRECT_STREAM_CODEC.1.INSTANCE, arg_0);
        StreamCodec streamCodec = ByteBufCodecs.holderSet((ResourceKey)Registries.ENTITY_TYPE);
        Function<Gene, HolderSet> function2 = arg_0 -> Gene.DIRECT_STREAM_CODEC$lambda$9((KProperty1)Companion.DIRECT_STREAM_CODEC.2.INSTANCE, arg_0);
        StreamCodec streamCodec2 = ByteBufCodecs.optional(PotionDetails.Companion.getDIRECT_STREAM_CODEC());
        Function<Gene, Optional> function3 = arg_0 -> Gene.DIRECT_STREAM_CODEC$lambda$10((KProperty1)Companion.DIRECT_STREAM_CODEC.3.INSTANCE, arg_0);
        StreamCodec streamCodec3 = AttributeEntry.Companion.getDIRECT_STREAM_CODEC().apply(ByteBufCodecs.list());
        Function<Gene, List> function4 = arg_0 -> Gene.DIRECT_STREAM_CODEC$lambda$11((KProperty1)Companion.DIRECT_STREAM_CODEC.4.INSTANCE, arg_0);
        ResourceKey resourceKey = Registries.ENTITY_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENTITY_TYPE");
        StreamCodec streamCodec4 = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, function, (StreamCodec)streamCodec, function2, (StreamCodec)streamCodec2, function3, (StreamCodec)streamCodec3, function4, (StreamCodec)ByteBufCodecs.optional(OtherUtil.INSTANCE.tagKeyStreamCodec(resourceKey)), arg_0 -> Gene.DIRECT_STREAM_CODEC$lambda$12((KProperty1)Companion.DIRECT_STREAM_CODEC.5.INSTANCE, arg_0), Gene::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec4, (String)"composite(...)");
        DIRECT_STREAM_CODEC = streamCodec4;
        RegistryFileCodec registryFileCodec = RegistryFileCodec.create(ModGenes.INSTANCE.getGENE_REGISTRY_KEY(), DIRECT_CODEC, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)registryFileCodec, (String)"create(...)");
        CODEC = (Codec)registryFileCodec;
        StreamCodec streamCodec5 = ByteBufCodecs.holder(ModGenes.INSTANCE.getGENE_REGISTRY_KEY(), DIRECT_STREAM_CODEC);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec5, (String)"holder(...)");
        STREAM_CODEC = streamCodec5;
        Codec codec2 = HolderSetCodec.create(ModGenes.INSTANCE.getGENE_REGISTRY_KEY(), CODEC, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        HOLDER_SET_CODEC = codec2;
        StreamCodec streamCodec6 = ByteBufCodecs.holderSet(ModGenes.INSTANCE.getGENE_REGISTRY_KEY());
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec6, (String)"holderSet(...)");
        HOLDER_SET_STREAM_CODEC = streamCodec6;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$AttributeEntry;", "", "attribute", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "modifier", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "<init>", "(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V", "getAttribute", "()Lnet/minecraft/core/Holder;", "getModifier", "()Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
    public static final class AttributeEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Holder<Attribute> attribute;
        @NotNull
        private final AttributeModifier modifier;
        @NotNull
        private static final Codec<AttributeEntry> DIRECT_CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, AttributeEntry> DIRECT_STREAM_CODEC;

        public AttributeEntry(@NotNull Holder<Attribute> attribute, @NotNull AttributeModifier modifier) {
            Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            this.attribute = attribute;
            this.modifier = modifier;
        }

        @NotNull
        public final Holder<Attribute> getAttribute() {
            return this.attribute;
        }

        @NotNull
        public final AttributeModifier getModifier() {
            return this.modifier;
        }

        @NotNull
        public final Holder<Attribute> component1() {
            return this.attribute;
        }

        @NotNull
        public final AttributeModifier component2() {
            return this.modifier;
        }

        @NotNull
        public final AttributeEntry copy(@NotNull Holder<Attribute> attribute, @NotNull AttributeModifier modifier) {
            Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return new AttributeEntry(attribute, modifier);
        }

        public static /* synthetic */ AttributeEntry copy$default(AttributeEntry attributeEntry, Holder holder, AttributeModifier attributeModifier, int n, Object object) {
            if ((n & 1) != 0) {
                holder = attributeEntry.attribute;
            }
            if ((n & 2) != 0) {
                attributeModifier = attributeEntry.modifier;
            }
            return attributeEntry.copy(holder, attributeModifier);
        }

        @NotNull
        public String toString() {
            return "AttributeEntry(attribute=" + this.attribute + ", modifier=" + this.modifier + ")";
        }

        public int hashCode() {
            int result = this.attribute.hashCode();
            result = result * 31 + this.modifier.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttributeEntry)) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)other;
            if (!Intrinsics.areEqual(this.attribute, attributeEntry.attribute)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modifier, (Object)attributeEntry.modifier);
        }

        private static final Holder DIRECT_CODEC$lambda$2$lambda$0(KProperty1 $tmp0, AttributeEntry p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Holder)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final AttributeModifier DIRECT_CODEC$lambda$2$lambda$1(KProperty1 $tmp0, AttributeEntry p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (AttributeModifier)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App DIRECT_CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Attribute.CODEC.fieldOf("attribute").forGetter(arg_0 -> AttributeEntry.DIRECT_CODEC$lambda$2$lambda$0((KProperty1)Companion.DIRECT_CODEC.1.1.INSTANCE, arg_0)), (App)AttributeModifier.CODEC.fieldOf("modifier").forGetter(arg_0 -> AttributeEntry.DIRECT_CODEC$lambda$2$lambda$1((KProperty1)Companion.DIRECT_CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, AttributeEntry::new);
        }

        private static final Holder DIRECT_STREAM_CODEC$lambda$3(KProperty1 $tmp0, AttributeEntry p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Holder)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final AttributeModifier DIRECT_STREAM_CODEC$lambda$4(KProperty1 $tmp0, AttributeEntry p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (AttributeModifier)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(AttributeEntry::DIRECT_CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            DIRECT_CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)Attribute.STREAM_CODEC, arg_0 -> AttributeEntry.DIRECT_STREAM_CODEC$lambda$3((KProperty1)Companion.DIRECT_STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)AttributeModifier.STREAM_CODEC, arg_0 -> AttributeEntry.DIRECT_STREAM_CODEC$lambda$4((KProperty1)Companion.DIRECT_STREAM_CODEC.2.INSTANCE, arg_0), AttributeEntry::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            DIRECT_STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$AttributeEntry$Companion;", "", "<init>", "()V", "DIRECT_CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$AttributeEntry;", "getDIRECT_CODEC", "()Lcom/mojang/serialization/Codec;", "DIRECT_STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getDIRECT_STREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<AttributeEntry> getDIRECT_CODEC() {
                return DIRECT_CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, AttributeEntry> getDIRECT_STREAM_CODEC() {
                return DIRECT_STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006J \u0010\f\u001a\u00020\r*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\nR\u001b\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000bR\u001b\u0010\u0010\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR'\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001f*\b\u0012\u0002\b\u0003\u0018\u00010\u001e0\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00070'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001d\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0#\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R#\u0010-\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0'\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010*R\u001d\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0007000#\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010%R#\u00102\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0007000'\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010*\u00a8\u00064"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$Companion;", "", "<init>", "()V", "translationKey", "", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "getTranslationKey", "(Lnet/minecraft/resources/ResourceKey;)Ljava/lang/String;", "Lnet/minecraft/core/Holder;", "(Lnet/minecraft/core/Holder;)Ljava/lang/String;", "isGene", "", "geneRk", "geneHolder", "isNegative", "(Lnet/minecraft/core/Holder;)Z", "isMutation", "isHelixOnly", "isDisabled", "getNameComponent", "Lnet/minecraft/network/chat/MutableComponent;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "unknownGeneComponent", "getUnknownGeneComponent", "()Lnet/minecraft/network/chat/MutableComponent;", "defaultAllowedEntities", "Lnet/neoforged/neoforge/registries/holdersets/AnyHolderSet;", "Lnet/minecraft/world/entity/EntityType;", "kotlin.jvm.PlatformType", "getDefaultAllowedEntities", "()Lnet/neoforged/neoforge/registries/holdersets/AnyHolderSet;", "DIRECT_CODEC", "Lcom/mojang/serialization/Codec;", "getDIRECT_CODEC", "()Lcom/mojang/serialization/Codec;", "DIRECT_STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getDIRECT_STREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "CODEC", "getCODEC", "STREAM_CODEC", "getSTREAM_CODEC", "HOLDER_SET_CODEC", "Lnet/minecraft/core/HolderSet;", "getHOLDER_SET_CODEC", "HOLDER_SET_STREAM_CODEC", "getHOLDER_SET_STREAM_CODEC", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTranslationKey(@NotNull ResourceKey<Gene> $this$translationKey) {
            Intrinsics.checkNotNullParameter($this$translationKey, (String)"<this>");
            String namespace = $this$translationKey.location().getNamespace();
            String path = $this$translationKey.location().getPath();
            return "gene." + namespace + "." + path;
        }

        @NotNull
        public final String getTranslationKey(@NotNull Holder<Gene> $this$translationKey) {
            Intrinsics.checkNotNullParameter($this$translationKey, (String)"<this>");
            ResourceKey resourceKey = $this$translationKey.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            return this.getTranslationKey((ResourceKey<Gene>)resourceKey);
        }

        public final boolean isGene(@Nullable Holder<Gene> $this$isGene, @Nullable ResourceKey<Gene> geneRk) {
            return $this$isGene != null && geneRk != null && Intrinsics.areEqual((Object)$this$isGene.getKey(), geneRk);
        }

        public final boolean isGene(@Nullable Holder<Gene> $this$isGene, @NotNull Holder<Gene> geneHolder) {
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            return Intrinsics.areEqual($this$isGene, geneHolder) || this.isGene($this$isGene, (ResourceKey<Gene>)geneHolder.getKey());
        }

        public final boolean isNegative(@NotNull Holder<Gene> $this$isNegative) {
            Intrinsics.checkNotNullParameter($this$isNegative, (String)"<this>");
            return $this$isNegative.is(ModGeneTagsProvider.Companion.getNEGATIVE());
        }

        public final boolean isMutation(@NotNull Holder<Gene> $this$isMutation) {
            Intrinsics.checkNotNullParameter($this$isMutation, (String)"<this>");
            return $this$isMutation.is(ModGeneTagsProvider.Companion.getMUTATION());
        }

        public final boolean isHelixOnly(@NotNull Holder<Gene> $this$isHelixOnly) {
            Intrinsics.checkNotNullParameter($this$isHelixOnly, (String)"<this>");
            return $this$isHelixOnly.is(ModGeneTagsProvider.Companion.getHELIX_ONLY());
        }

        public final boolean isDisabled(@NotNull Holder<Gene> $this$isDisabled) {
            Intrinsics.checkNotNullParameter($this$isDisabled, (String)"<this>");
            return $this$isDisabled.is(ModGeneTagsProvider.Companion.getDISABLED());
        }

        @NotNull
        public final MutableComponent getNameComponent(@NotNull ResourceKey<Gene> geneRk, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter(geneRk, (String)"geneRk");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return this.getNameComponent((Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(geneRk, registries)));
        }

        public static /* synthetic */ MutableComponent getNameComponent$default(Companion companion, ResourceKey resourceKey, HolderLookup.Provider provider, int n, Object object) {
            if ((n & 2) != 0) {
                RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
                Intrinsics.checkNotNull((Object)registryAccess);
                provider = (HolderLookup.Provider)registryAccess;
            }
            return companion.getNameComponent((ResourceKey<Gene>)resourceKey, provider);
        }

        @NotNull
        public final MutableComponent getNameComponent(@NotNull Holder<Gene> geneHolder) {
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            ChatFormatting color = this.isDisabled(geneHolder) ? ChatFormatting.DARK_RED : (this.isNegative(geneHolder) ? ChatFormatting.RED : (this.isMutation(geneHolder) ? ChatFormatting.DARK_PURPLE : ChatFormatting.GRAY));
            MutableComponent component = ModLanguageProvider.Companion.toComponent(this.getTranslationKey(geneHolder), new Object[0]).withStyle(arg_0 -> Companion.getNameComponent$lambda$0(color, geneHolder, arg_0));
            if (this.isDisabled(geneHolder)) {
                component.append((Component)ModLanguageProvider.Companion.toComponent("gene.geneticsresequenced.disabled", new Object[0]));
            }
            Intrinsics.checkNotNull((Object)component);
            return component;
        }

        @NotNull
        public final MutableComponent getUnknownGeneComponent() {
            return unknownGeneComponent;
        }

        @NotNull
        public final AnyHolderSet<EntityType<?>> getDefaultAllowedEntities() {
            return defaultAllowedEntities;
        }

        @NotNull
        public final Codec<Gene> getDIRECT_CODEC() {
            return DIRECT_CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, Gene> getDIRECT_STREAM_CODEC() {
            return DIRECT_STREAM_CODEC;
        }

        @NotNull
        public final Codec<Holder<Gene>> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, Holder<Gene>> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @NotNull
        public final Codec<HolderSet<Gene>> getHOLDER_SET_CODEC() {
            return HOLDER_SET_CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, HolderSet<Gene>> getHOLDER_SET_STREAM_CODEC() {
            return HOLDER_SET_STREAM_CODEC;
        }

        private static final Style getNameComponent$lambda$0(ChatFormatting $color, Holder $geneHolder, Style it) {
            Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
            Intrinsics.checkNotNullParameter((Object)$geneHolder, (String)"$geneHolder");
            Style style = it.withColor($color);
            Object[] objectArray = new Object[1];
            ResourceKey resourceKey = $geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            objectArray[0] = resourceKey.location().toString();
            Style style2 = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.copy_gene_id", objectArray)));
            ResourceKey resourceKey2 = $geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey2);
            return style2.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, resourceKey2.location().toString()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$PotionDetails;", "", "effect", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/effect/MobEffect;", "level", "", "duration", "showIcon", "", "<init>", "(Lnet/minecraft/core/Holder;IIZ)V", "getEffect", "()Lnet/minecraft/core/Holder;", "getLevel", "()I", "getDuration", "getShowIcon", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
    public static final class PotionDetails {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Holder<MobEffect> effect;
        private final int level;
        private final int duration;
        private final boolean showIcon;
        @NotNull
        private static final Codec<PotionDetails> DIRECT_CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, PotionDetails> DIRECT_STREAM_CODEC;

        public PotionDetails(@NotNull Holder<MobEffect> effect, int level, int duration, boolean showIcon) {
            Intrinsics.checkNotNullParameter(effect, (String)"effect");
            this.effect = effect;
            this.level = level;
            this.duration = duration;
            this.showIcon = showIcon;
        }

        public /* synthetic */ PotionDetails(Holder holder, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 1;
            }
            if ((n3 & 4) != 0) {
                n2 = -1;
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            this((Holder<MobEffect>)holder, n, n2, bl);
        }

        @NotNull
        public final Holder<MobEffect> getEffect() {
            return this.effect;
        }

        public final int getLevel() {
            return this.level;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final boolean getShowIcon() {
            return this.showIcon;
        }

        @NotNull
        public final Holder<MobEffect> component1() {
            return this.effect;
        }

        public final int component2() {
            return this.level;
        }

        public final int component3() {
            return this.duration;
        }

        public final boolean component4() {
            return this.showIcon;
        }

        @NotNull
        public final PotionDetails copy(@NotNull Holder<MobEffect> effect, int level, int duration, boolean showIcon) {
            Intrinsics.checkNotNullParameter(effect, (String)"effect");
            return new PotionDetails(effect, level, duration, showIcon);
        }

        public static /* synthetic */ PotionDetails copy$default(PotionDetails potionDetails, Holder holder, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                holder = potionDetails.effect;
            }
            if ((n3 & 2) != 0) {
                n = potionDetails.level;
            }
            if ((n3 & 4) != 0) {
                n2 = potionDetails.duration;
            }
            if ((n3 & 8) != 0) {
                bl = potionDetails.showIcon;
            }
            return potionDetails.copy(holder, n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "PotionDetails(effect=" + this.effect + ", level=" + this.level + ", duration=" + this.duration + ", showIcon=" + this.showIcon + ")";
        }

        public int hashCode() {
            int result = this.effect.hashCode();
            result = result * 31 + Integer.hashCode(this.level);
            result = result * 31 + Integer.hashCode(this.duration);
            result = result * 31 + Boolean.hashCode(this.showIcon);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PotionDetails)) {
                return false;
            }
            PotionDetails potionDetails = (PotionDetails)other;
            if (!Intrinsics.areEqual(this.effect, potionDetails.effect)) {
                return false;
            }
            if (this.level != potionDetails.level) {
                return false;
            }
            if (this.duration != potionDetails.duration) {
                return false;
            }
            return this.showIcon == potionDetails.showIcon;
        }

        private static final Holder DIRECT_CODEC$lambda$4$lambda$0(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Holder)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer DIRECT_CODEC$lambda$4$lambda$1(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer DIRECT_CODEC$lambda$4$lambda$2(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean DIRECT_CODEC$lambda$4$lambda$3(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App DIRECT_CODEC$lambda$4(RecordCodecBuilder.Instance instance) {
            return instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(arg_0 -> PotionDetails.DIRECT_CODEC$lambda$4$lambda$0((KProperty1)Companion.DIRECT_CODEC.1.1.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(arg_0 -> PotionDetails.DIRECT_CODEC$lambda$4$lambda$1((KProperty1)Companion.DIRECT_CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("duration", (Object)-1).forGetter(arg_0 -> PotionDetails.DIRECT_CODEC$lambda$4$lambda$2((KProperty1)Companion.DIRECT_CODEC.1.3.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)false).forGetter(arg_0 -> PotionDetails.DIRECT_CODEC$lambda$4$lambda$3((KProperty1)Companion.DIRECT_CODEC.1.4.INSTANCE, arg_0))).apply((Applicative)instance, PotionDetails::new);
        }

        private static final Holder DIRECT_STREAM_CODEC$lambda$5(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Holder)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer DIRECT_STREAM_CODEC$lambda$6(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer DIRECT_STREAM_CODEC$lambda$7(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean DIRECT_STREAM_CODEC$lambda$8(KProperty1 $tmp0, PotionDetails p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(PotionDetails::DIRECT_CODEC$lambda$4);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            DIRECT_CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)MobEffect.STREAM_CODEC, arg_0 -> PotionDetails.DIRECT_STREAM_CODEC$lambda$5((KProperty1)Companion.DIRECT_STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.VAR_INT, arg_0 -> PotionDetails.DIRECT_STREAM_CODEC$lambda$6((KProperty1)Companion.DIRECT_STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.VAR_INT, arg_0 -> PotionDetails.DIRECT_STREAM_CODEC$lambda$7((KProperty1)Companion.DIRECT_STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> PotionDetails.DIRECT_STREAM_CODEC$lambda$8((KProperty1)Companion.DIRECT_STREAM_CODEC.4.INSTANCE, arg_0), PotionDetails::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            DIRECT_STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$PotionDetails$Companion;", "", "<init>", "()V", "DIRECT_CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene$PotionDetails;", "getDIRECT_CODEC", "()Lcom/mojang/serialization/Codec;", "DIRECT_STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getDIRECT_STREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<PotionDetails> getDIRECT_CODEC() {
                return DIRECT_CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, PotionDetails> getDIRECT_STREAM_CODEC() {
                return DIRECT_STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

