/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.entity;

import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.DamageGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.DeathGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.ScareGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/entity/EntityEvents;", "", "<init>", "()V", "onLivingDeath", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "onDetonate", "Lnet/neoforged/neoforge/event/level/ExplosionEvent$Detonate;", "onLivingAboutToBeDamaged", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "onLivingDamagePre", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "onLivingHurtPost", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "onEntityTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Pre;", "onEntitySpawn", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "geneticsresequenced-1.21.1"})
public final class EntityEvents {
    @NotNull
    public static final EntityEvents INSTANCE = new EntityEvents();

    private EntityEvents() {
    }

    @SubscribeEvent
    public final void onLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathGenes.INSTANCE.handleEmeraldHeart(event);
        DeathGenes.INSTANCE.handleExplosiveExit(event);
        DeathGenes.INSTANCE.handleSlimyDeath(event);
    }

    @SubscribeEvent
    public final void onDetonate(@NotNull ExplosionEvent.Detonate event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathGenes.INSTANCE.explosiveExitDetonation(event);
    }

    @SubscribeEvent
    public final void onLivingAboutToBeDamaged(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageGenes.INSTANCE.handleNoFallDamage(event);
        DamageGenes.INSTANCE.handleWitherProof(event);
        DamageGenes.INSTANCE.handleFireProof(event);
        DamageGenes.INSTANCE.handlePoisonProof(event);
    }

    @SubscribeEvent
    public final void onLivingDamagePre(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageGenes.INSTANCE.handleDragonHealth(event);
        DamageGenes.INSTANCE.handleJohnny(event);
    }

    @SubscribeEvent
    public final void onLivingHurtPost(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getNewDamage() <= 0.0f) {
            return;
        }
        DamageGenes.INSTANCE.handleThorns(event);
        DamageGenes.INSTANCE.handleClaws(event);
        DamageGenes.INSTANCE.handleWitherHit(event);
        DamageGenes.INSTANCE.handleChilling(event);
    }

    @SubscribeEvent
    public final void onEntityTick(@NotNull EntityTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        TickGenes.INSTANCE.handleBioluminescence(entity2);
        TickGenes.INSTANCE.handlePhotosynthesis(entity2);
        TickGenes.INSTANCE.handleTickingGenes(entity2);
    }

    @SubscribeEvent
    public final void onEntitySpawn(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            ScareGenes.INSTANCE.attachScareTask((PathfinderMob)entity);
        }
    }
}

