/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.entity;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.entity.goals.SupportSlimeAttackGoal;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.ModScheduler;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010#\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\rH\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime;", "Lnet/minecraft/world/entity/monster/Slime;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "pLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "level", "ownerUuid", "Ljava/util/UUID;", "(Lnet/minecraft/world/level/Level;Ljava/util/UUID;)V", "defineSynchedData", "", "pBuilder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "onAddedToLevel", "setOwnerIfNotSet", "getOwnerUuid", "setOwner", "tick", "ticksWithoutTarget", "", "despawnAnimationPlaying", "", "checkIfShouldDespawn", "despawn", "readAdditionalSaveData", "pCompound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "setSize", "pSize", "pResetHealth", "push", "pEntity", "Lnet/minecraft/world/entity/Entity;", "playerTouch", "Lnet/minecraft/world/entity/player/Player;", "shouldSlimeAttackEntity", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "registerGoals", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSupportSlime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupportSlime.kt\ndev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1062#2:249\n295#2,2:250\n*S KotlinDebug\n*F\n+ 1 SupportSlime.kt\ndev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime\n*L\n108#1:249\n110#1:250,2\n*E\n"})
public final class SupportSlime
extends Slime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ticksWithoutTarget;
    private boolean despawnAnimationPlaying;
    @NotNull
    private static final String OWNER_UUID_NBT_KEY = "OwnerUUID";
    @NotNull
    private static final EntityDataAccessor<Optional<UUID>> OWNER;

    public SupportSlime(@NotNull EntityType<SupportSlime> pEntityType, @NotNull Level pLevel) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        super(pEntityType, pLevel);
    }

    public SupportSlime(@NotNull Level level, @NotNull UUID ownerUuid) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
        Object object = ModEntityTypes.INSTANCE.getSUPPORT_SLIME().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<SupportSlime>)((EntityType)object), level);
        this.setOwner(ownerUuid);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder pBuilder) {
        Intrinsics.checkNotNullParameter((Object)pBuilder, (String)"pBuilder");
        pBuilder.define(OWNER, Optional.empty());
        super.defineSynchedData(pBuilder);
    }

    public void onAddedToLevel() {
        if (!this.level().isClientSide && this.getOwnerUuid() == null) {
            this.setOwnerIfNotSet();
        }
        super.onAddedToLevel();
    }

    private final void setOwnerIfNotSet() {
        Object v1;
        block3: {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(10.0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable $this$sortedByDescending$iv = list;
            boolean $i$f$sortedByDescending = false;
            List nearbyLivingEntities = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
                final /* synthetic */ SupportSlime this$0;
                {
                    this.this$0 = supportSlime;
                }

                public final int compare(T a, T b) {
                    LivingEntity it = (LivingEntity)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(this.this$0.distanceToSqr((Entity)it));
                    it = (LivingEntity)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(this.this$0.distanceToSqr((Entity)it)));
                }
            });
            Iterable $this$firstOrNull$iv = nearbyLivingEntities;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LivingEntity it = (LivingEntity)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!GenesData.Companion.hasGene(it, ModGenes.INSTANCE.getSLIMY_DEATH())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        LivingEntity owner = v1;
        if (owner != null) {
            UUID uUID = owner.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.setOwner(uUID);
        } else {
            GeneticsResequenced.Companion.getLOGGER().warn("Support Slime spawned without an owner!");
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    public final UUID getOwnerUuid() {
        UUID uUID;
        try {
            uUID = ((Optional)this.entityData.get(OWNER)).orElse(null);
        }
        catch (NullPointerException e) {
            uUID = null;
        }
        return uUID;
    }

    private final void setOwner(UUID ownerUuid) {
        this.entityData.set(OWNER, Optional.of(ownerUuid));
    }

    public void tick() {
        super.tick();
        this.checkIfShouldDespawn();
    }

    private final void checkIfShouldDespawn() {
        if (this.isNoAi()) {
            return;
        }
        if (this.despawnAnimationPlaying) {
            return;
        }
        Object object = ServerConfig.Companion.getSlimyDeathDespawnCheckTimer().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (this.tickCount % ((Number)object).intValue() != 0) {
            return;
        }
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0));
        boolean nearEnemies = false;
        boolean nearOwner = false;
        for (Entity entity : nearbyEntities) {
            if (nearEnemies && nearOwner) break;
            if (Intrinsics.areEqual((Object)entity.getUUID(), (Object)this.getOwnerUuid())) {
                nearOwner = true;
            }
            if (!(entity instanceof Mob)) continue;
            LivingEntity livingEntity = ((Mob)entity).getTarget();
            if (!Intrinsics.areEqual((Object)(livingEntity != null ? livingEntity.getUUID() : null), (Object)this.getOwnerUuid())) continue;
            nearEnemies = true;
        }
        if (!nearOwner) {
            this.despawn();
        }
        if (nearEnemies) {
            this.ticksWithoutTarget = 0;
        } else {
            Object object2 = ServerConfig.Companion.getSlimyDeathDespawnCheckTimer().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            this.ticksWithoutTarget += ((Number)object2).intValue();
            if (this.ticksWithoutTarget > ((Number)ServerConfig.Companion.getSlimyDeathDespawnTime().get()).intValue()) {
                this.despawn();
            }
        }
    }

    private final void despawn() {
        this.despawnAnimationPlaying = true;
        if (this.getSize() <= 1) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.setSize(this.getSize() - 1, true);
        ModScheduler.INSTANCE.scheduleTaskInTicks(30, () -> SupportSlime.despawn$lambda$2(this));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
        super.readAdditionalSaveData(pCompound);
        UUID uUID = OtherUtil.INSTANCE.getUuidOrNull(pCompound, OWNER_UUID_NBT_KEY);
        if (uUID == null) {
            return;
        }
        UUID owner = uUID;
        this.setOwner(owner);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
        super.addAdditionalSaveData(pCompound);
        UUID owner = this.getOwnerUuid();
        if (owner != null) {
            pCompound.putUUID(OWNER_UUID_NBT_KEY, owner);
        }
    }

    public void setSize(int pSize, boolean pResetHealth) {
        block1: {
            super.setSize(pSize, pResetHealth);
            AttributeInstance attributeInstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attributeInstance != null) {
                attributeInstance.setBaseValue((double)pSize * 3.0);
            }
            AttributeInstance attributeInstance2 = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeInstance2 == null) break block1;
            attributeInstance2.setBaseValue(0.4 + 0.2 * (double)pSize);
        }
    }

    public void push(@NotNull Entity pEntity) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        if (!Intrinsics.areEqual((Object)pEntity.getUUID(), (Object)this.getOwnerUuid())) {
            super.push(pEntity);
        }
    }

    public void playerTouch(@NotNull Player pEntity) {
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
    }

    private final boolean shouldSlimeAttackEntity(LivingEntity livingEntity) {
        UUID uUID = this.getOwnerUuid();
        if (uUID == null) {
            return false;
        }
        UUID owner = uUID;
        Mob mob = livingEntity instanceof Mob ? (Mob)livingEntity : null;
        if (mob == null) {
            return false;
        }
        Mob mob2 = mob;
        LivingEntity livingEntity2 = mob2.getTarget();
        boolean mobIsAttackingOwner = Intrinsics.areEqual((Object)(livingEntity2 != null ? livingEntity2.getUUID() : null), (Object)owner);
        return mobIsAttackingOwner;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new SupportSlimeAttackGoal(this));
        this.targetSelector.removeAllGoals(SupportSlime::registerGoals$lambda$3);
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, arg_0 -> SupportSlime.registerGoals$lambda$4(this, arg_0)));
    }

    private static final void despawn$lambda$2(SupportSlime this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.despawn();
    }

    private static final boolean registerGoals$lambda$3(Goal it) {
        return true;
    }

    private static final boolean registerGoals$lambda$4(SupportSlime this$0, LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return this$0.shouldSlimeAttackEntity(it);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(SupportSlime.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        OWNER = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime$Companion;", "", "<init>", "()V", "setAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;", "OWNER_UUID_NBT_KEY", "", "OWNER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Ljava/util/UUID;", "spawnEggMessage", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier setAttributes() {
            AttributeSupplier attributeSupplier = Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 20.0).build();
            Intrinsics.checkNotNullExpressionValue((Object)attributeSupplier, (String)"build(...)");
            return attributeSupplier;
        }

        public final void spawnEggMessage(@NotNull PlayerInteractEvent.RightClickBlock event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getSide().isClient()) {
                return;
            }
            Player player = event.getEntity();
            ItemStack item = event.getItemStack();
            if (!item.is((Item)ModItems.INSTANCE.getFRIENDLY_SLIME_SPAWN_EGG().get())) {
                return;
            }
            Intrinsics.checkNotNull((Object)player);
            if (!GenesData.Companion.hasGene((LivingEntity)player, ModGenes.INSTANCE.getSLIMY_DEATH())) {
                Object[] objectArray = new Object[1];
                ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getSLIMY_DEATH();
                RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
                Intrinsics.checkNotNull((Object)registryAccess);
                objectArray[0] = Gene.Companion.getNameComponent(resourceKey, (HolderLookup.Provider)registryAccess);
                player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.support_slime_creative", objectArray));
            }
            if (player.level().getDifficulty() == Difficulty.PEACEFUL) {
                player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.support_slime_peaceful", new Object[0]));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

