/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import dev.aaronhowser.mods.geneticsresequenced.block.AntiFieldBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.blood_purifier.BloodPurifierBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.cell_analyzer.CellAnalyzerBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.dna_decryptor.DnaDecryptorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.dna_extractor.DnaExtractorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator.IncubatorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.plasmid_infuser.PlasmidInfuserBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.plasmid_injector.PlasmidInjectorBlock;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.entries.BaseEntryProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/modonomicon/categories/BlocksCategoryProvider;", "Lcom/klikli_dev/modonomicon/api/datagen/CategoryProvider;", "parent", "Lcom/klikli_dev/modonomicon/api/datagen/ModonomiconProviderBase;", "<init>", "(Lcom/klikli_dev/modonomicon/api/datagen/ModonomiconProviderBase;)V", "realThis", "getRealThis", "()Ldev/aaronhowser/mods/geneticsresequenced/datagen/modonomicon/categories/BlocksCategoryProvider;", "categoryName", "", "categoryIcon", "Lcom/klikli_dev/modonomicon/api/datagen/book/BookIconModel;", "categoryId", "generateEntryMap", "", "()[Ljava/lang/String;", "generateEntries", "", "plasmidInjector", "Lcom/klikli_dev/modonomicon/api/datagen/book/BookEntryModel;", "location", "", "plasmidInfuser", "advancedIncubator", "incubator", "dnaDecryptor", "dnaExtractor", "coalGenerator", "cellAnalyzer", "bloodPurifierBlock", "antiFieldBlock", "geneticsresequenced-1.21.1"})
public final class BlocksCategoryProvider
extends CategoryProvider {
    @NotNull
    private final BlocksCategoryProvider realThis = this;

    public BlocksCategoryProvider(@Nullable ModonomiconProviderBase parent) {
        super(parent);
    }

    @NotNull
    public final BlocksCategoryProvider getRealThis() {
        return this.realThis;
    }

    @NotNull
    protected String categoryName() {
        return "Blocks";
    }

    @NotNull
    protected BookIconModel categoryIcon() {
        BookIconModel bookIconModel = BookIconModel.create((ItemLike)((ItemLike)ModBlocks.INSTANCE.getBLOOD_PURIFIER()));
        Intrinsics.checkNotNullExpressionValue((Object)bookIconModel, (String)"create(...)");
        return bookIconModel;
    }

    @NotNull
    public String categoryId() {
        return "blocks";
    }

    @NotNull
    protected String[] generateEntryMap() {
        String[] stringArray = new String[]{"g", "aed", "bpj", "iv", "f"};
        return stringArray;
    }

    protected void generateEntries() {
        Ref.IntRef index = new Ref.IntRef();
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.coalGenerator('g'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.cellAnalyzer('a'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.dnaExtractor('e'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.dnaDecryptor('d'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.bloodPurifierBlock('b'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.plasmidInfuser('p'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.plasmidInjector('j'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.incubator('i'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.advancedIncubator('v'));
        BlocksCategoryProvider.generateEntries$addEntry(this, index, this.antiFieldBlock('f'));
    }

    private final BookEntryModel plasmidInjector(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<PlasmidInjectorBlock> deferredBlock = ModBlocks.INSTANCE.getPLASMID_INJECTOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("Plasmid Injector") + " uses FE to inject completed " + this.item("Plasmids", "plasmid") + " into a " + this.item("Syringe", "syringe") + ".", "You can inject as many Plasmids into a single Syringe as you want."};
                this.textPage("Plasmid Injector", BaseEntryProvider.Companion.paragraphs(stringArray));
                stringArray = new String[]{"The Syringe must be full of uncompromised blood.", "Decontaminate blood in the " + this.block("Blood Purifier", "blood_purifier") + "."};
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getPLASMID_INJECTOR(), BaseEntryProvider.Companion.paragraphs(stringArray));
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel plasmidInfuser(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<PlasmidInfuserBlock> deferredBlock = ModBlocks.INSTANCE.getPLASMID_INFUSER();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("Plasmid Infuser") + " uses FE to infuse " + this.item("DNA Helices", "dna_helix") + " into a " + this.item("Plasmid", "plasmid") + ".", "Insert an empty Plasmid in the right slot, and a DNA Helix in the left slot.", "The DNA Helix will be used up, and set the Plasmid's Gene to match the Helix's."};
                this.textPage("Plasmid Infuser", BaseEntryProvider.Companion.paragraphs(stringArray));
                stringArray = new String[]{"Each Gene requires a certain amount of " + BaseEntryProvider.Companion.minor("DNA Points") + " for the Plasmid to be completed.", "- Basic Genes are worth 1 point.\n- Genes of the Plasmid's type are worth 2 points.", "A Basic Gene cannot be the first one infused into a Plasmid."};
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getPLASMID_INFUSER(), BaseEntryProvider.Companion.paragraphs(stringArray));
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel advancedIncubator(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<Block> deferredBlock = ModBlocks.INSTANCE.getADVANCED_INCUBATOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("Advanced Incubator") + " is an upgrade to the " + this.block("Incubator", "incubator") + ".", "Like the Incubator, it functions as a Brewing Stand. However, the Advanced Incubator has a temperature mechanic.", "The coil on the left of the GUI can be clicked to toggle between low and high temperatures."};
                this.textPage("Advanced Incubator", BaseEntryProvider.Companion.paragraphs(stringArray));
                stringArray = new String[]{"By default, it's " + BaseEntryProvider.Companion.bad("120 times slower") + " at low-temperature. This means a single brew takes a full 20 minutes, excluding Overclockers.", "The reason you'd *want* to use low temperature mode is that that's the only way you can get " + this.item("Genetically Modified Cells", "potion_cell_growth@gmo_cell")};
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getADVANCED_INCUBATOR(), BaseEntryProvider.Companion.paragraphs(stringArray));
                ItemStack gmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
                Intrinsics.checkNotNull((Object)gmoStack);
                EntityType entityType = EntityType.IRON_GOLEM;
                Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"IRON_GOLEM");
                ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getREGENERATION();
                HolderLookup.Provider provider = this.registries();
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"registries(...)");
                GmoCell.Companion.setDetails(gmoStack, entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(resourceKey, provider)));
                String[] stringArray2 = new String[]{this.item("Genetically Modified Cells", "potion_cell_growth@gmo_cell") + " are " + BaseEntryProvider.Companion.minor("guaranteed to have a specific Gene") + ", if crafted correctly.", "Each GM Cell has its own recipe, with a " + BaseEntryProvider.Companion.bad("chance of failure") + ".", "The recipe for this GM Cell, for example, has a 30%% chance of success by default."};
                this.spotlightPage(gmoStack, BaseEntryProvider.Companion.paragraphs(stringArray2));
                stringArray2 = new String[]{"Each Overclocker " + BaseEntryProvider.Companion.bad("decreases the chance by 10%%") + ".", "However, you can insert " + BaseEntryProvider.Companion.minor("Chorus Fruit") + " into the top right slot to increase your odds!", "By default, each Chorus Fruit increases the chance by 10%%. The Advanced Incubator will up as many Chorus Fruit as it takes to reach 100%."};
                this.textPage(BaseEntryProvider.Companion.paragraphs(stringArray2));
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel incubator(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<IncubatorBlock> deferredBlock = ModBlocks.INSTANCE.getINCUBATOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                this.textPage("Incubator", "The " + BaseEntryProvider.Companion.major("Incubator") + " is effectively a faster Brewing Stand. It runs at twice the speed, but " + BaseEntryProvider.Companion.bad("costs FE instead of Blaze Powder") + ".");
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getINCUBATOR(), "It speed can be increased with " + this.item("Overclockers", "overclocker") + ".");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel dnaDecryptor(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<DnaDecryptorBlock> deferredBlock = ModBlocks.INSTANCE.getDNA_DECRYPTOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("DNA Decryptor") + " uses FE to decrypt encrypted " + this.item("DNA Helices", "dna_helix") + ".", "Every time DNA is decrypted, it will choose a " + this.categoryLink("Gene", "genes") + ", based on the Entity the Helix came from.", "This Gene is weighted, some Genes have a higher chance than others. The Gene is chosen at the start of the process."};
                this.textPage("DNA Decryptor", BaseEntryProvider.Companion.paragraphs(stringArray));
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getDNA_DECRYPTOR(), "If the Decryptor isn't working and there's a DNA Helix in the output slot, try taking it out. The next Gene may be of a different type, which means it can't stack with the one in the output slot.");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel dnaExtractor(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<DnaExtractorBlock> deferredBlock = ModBlocks.INSTANCE.getDNA_EXTRACTOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                ItemStack itemStack = ModBlocks.INSTANCE.getDNA_EXTRACTOR().toStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
                this.spotlightPage(itemStack, "DNA Extractor", "The " + BaseEntryProvider.Companion.major("DNA Extractor") + " uses FE to convert " + this.item("Cells", "cell") + " into encrypted " + this.item("DNA Helices", "dna_helix") + ".");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel coalGenerator(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<CoalGeneratorBlock> deferredBlock = ModBlocks.INSTANCE.getCOAL_GENERATOR();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("Coal Generator") + " burns furnace fuels to generate FE.", "Furnace fuels that burn longer produce more FE.", "The amount is configurable, but defaults to 6FE/t. With this, " + BaseEntryProvider.Companion.minor("1 Coal generates 9,600 FE") + "."};
                this.textPage("Coal Generator", BaseEntryProvider.Companion.paragraphs(stringArray));
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getCOAL_GENERATOR(), "If the Coal Generator fills up with fuel burning, it " + BaseEntryProvider.Companion.minor("pauses until it has room for more energy") + ", preventing waste!");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel cellAnalyzer(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<CellAnalyzerBlock> deferredBlock = ModBlocks.INSTANCE.getCELL_ANALYZER();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                ItemStack itemStack = ModBlocks.INSTANCE.getCELL_ANALYZER().toStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
                this.spotlightPage(itemStack, "Cell Analyzer", "The " + BaseEntryProvider.Companion.major("Cell Analyzer") + " uses FE to convert " + this.item("Organic Matter", "organic_matter") + " into " + this.item("Cells", "cell") + ".");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel bloodPurifierBlock(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<BloodPurifierBlock> deferredBlock = ModBlocks.INSTANCE.getBLOOD_PURIFIER();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                ItemStack itemStack = ModBlocks.INSTANCE.getBLOOD_PURIFIER().toStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
                this.spotlightPage(itemStack, "Blood Purifier", "The " + BaseEntryProvider.Companion.major("Blood Purifier") + " uses FE to decontaminate " + this.item("Syringes", "syringe") + ".");
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private final BookEntryModel antiFieldBlock(char location) {
        BlocksCategoryProvider blocksCategoryProvider = this.realThis;
        DeferredBlock<AntiFieldBlock> deferredBlock = ModBlocks.INSTANCE.getANTI_FIELD_BLOCK();
        BaseEntryProvider entry2 = new BaseEntryProvider(blocksCategoryProvider, deferredBlock){

            protected void generatePages() {
                String[] stringArray = new String[]{"The " + BaseEntryProvider.Companion.major("Anti-Field Block") + " allows you to " + BaseEntryProvider.Companion.minor("temporarily disable certain Genes") + ".", "Specifically, it disabled the " + this.gene("Item Attraction Field", "item_magnet") + " and " + this.gene("XP Attraction Field", "xp_magnet") + " when enabled.", "The " + this.item("Anti-Field Orb", "anti_field_orb") + " functions similarly, but in item form."};
                this.textPage("Anti-Field Block", BaseEntryProvider.Companion.paragraphs(stringArray));
                stringArray = new String[]{"The Anti-Field Block is active by default, and can be disabled with a Redstone signal.", "While active, it disables all Fields within a 25 block spherical radius. This amount is configurable."};
                this.spotlightPage((ItemLike)ModBlocks.INSTANCE.getANTI_FIELD_BLOCK(), BaseEntryProvider.Companion.paragraphs(stringArray));
            }
        };
        BookEntryModel bookEntryModel = entry2.generate(location);
        Intrinsics.checkNotNullExpressionValue((Object)bookEntryModel, (String)"generate(...)");
        return bookEntryModel;
    }

    private static final void generateEntries$addEntry(BlocksCategoryProvider this$0, Ref.IntRef index, BookEntryModel entry2) {
        this$0.add(entry2.withSortNumber(index.element));
        int n = index.element;
        index.element = n + 1;
    }
}

